<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AgendaHL
 *
 * @ORM\Table(name="agenda_horario_laborable")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\AgendaHLRepository")
 */
class AgendaHL
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_agenda_hl", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="HorariosLaborables")
     * @ORM\JoinColumn(name="id_horario_laborable", referencedColumnName="id_horario_laborable")
     */
    private $idHorarioLaborable;

    /**
     * @var string
     *
     * @ORM\Column(name="hora_agenda_hl", type="string", length=15)
     */
    private $hora;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idHorarioLaborable
     *
     * @param integer $idHorarioLaborable
     *
     * @return AgendaHL
     */
    public function setIdHorarioLaborable($idHorarioLaborable)
    {
        $this->idHorarioLaborable = $idHorarioLaborable;

        return $this;
    }

    /**
     * Get idHorarioLaborable
     *
     * @return int
     */
    public function getIdHorarioLaborable()
    {
        return $this->idHorarioLaborable;
    }

    /**
     * Set hora
     *
     * @param string $hora
     *
     * @return AgendaHL
     */
    public function setHora($hora)
    {
        $this->hora = $hora;

        return $this;
    }

    /**
     * Get hora
     *
     * @return string
     */
    public function getHora()
    {
        return $this->hora;
    }
}

