<?php

namespace AgendaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;

class RecursosController extends Controller
{
    /**
     * @Route("/recursos/calendario/", name="calendario")
     */
    public function getCalendarioAction()
    {
        $anio = date("Y");
        $mes = date("m");

        if($_POST["anio"] != "")
            $anio = $_POST["anio"];

        if($_POST["mes"] != "")
            $mes = $_POST["mes"];

        $anioB = false;
        if($anio % 400 == 0)
        {
            $anioB = true;
        }
        else
        {
            if($anio % 4 == 0 && $anio % 100 != 0)
                $anioB = true;
            else
                $anioB = false;
        }

        $dias = 31;
        if($mes == 4 || $mes == 6 || $mes == 9 || $mes == 11)
        {
            $dias = 30;
        }
        elseif($mes == 2)
        {
            if($anioB)
                $dias = 29;
            else
                $dias = 28;
        }

        $html = '';
        for($i = 1; $i <= $dias; $i++)
        {
            (($i < 10) ? $day = "0".$i : $day = $i);
            $f = $anio."-".$mes."-".$day;
            $d = date("N", strtotime($f));
            $dia = "Dom";
            if($d == 1)
                $dia = "Lun";
            elseif($d == 2)
                $dia = "Mar";
            elseif($d == 3)
                $dia = "Miér";
            elseif($d == 4)
                $dia = "Jue";
            elseif($d == 5)
                $dia = "Vie";
            elseif($d == 6)
                $dia = "Sáb";

            $html .= '<div class="calendario pad5"><a name="'.$f.'" class="d100 text-center btnDia '.((date($f)  == date("Y-m-d")) ? "hoy day-active" : "").'" href="#">'.$dia.' '.$day.'</a></div>';
        }
        return new Response($html);
    }

	/**
	 * @Route("/combo/medicos/{idAsistente}", name="comboboxMedicos")
	 */
	public function getComboMedico($idAsistente)
	{
		$em = $this->getDoctrine()->getManager();
		$html = "";

		if($idAsistente == 0)
		{
			$medicos = $em->getRepository("LoginBundle:Usuario")->findBy(array("rolUsuario" => 2, "estado" => true));

			foreach($medicos as $row)
			{
				$html .= "<option value='".$row->getIdMedico()->getId()."'>".$row->getNombre().' '.$row->getApellido()."</option>";
			}
		}
		else
		{
			$asistenteMedico = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $idAsistente));

			foreach($asistenteMedico as $row)
			{
				$medico = $em->getRepository("LoginBundle:Usuario")->findOneBy(array("idMedico" => $row->getIdMedico()->getId(), "estado" => true));

				$html .= "<option value='".$medico->getIdMedico()->getId()."'>".$medico->getNombre().' '.$medico->getApellido()."</option>";
			}
		}

		return new Response($html);
	}

    /**
     * @Route("/combo/cie10/", name="comboboxCie10")
     */
    public function getComboCie10()
    {
        $em = $this->getDoctrine()->getManager();
        $cie10 = $em->getRepository("AgendaBundle:CieDiez")->findBy(array("estado" => true));

        $html = '<option value=""></option>';
        if($cie10)
        {
            foreach($cie10 aS $row)
            {
                $html .= '<option value="'.$row->getId().'">'.$row->getNombre().'</option>';
            }
        }

        return new Response($html);
    }

    /**
     * @Route("/combo/imagen/", name="comboboxImagen")
     */
    public function getComboImagen()
    {
        $em = $this->getDoctrine()->getManager();
        $imagen = $em->getRepository("AgendaBundle:PedidoImagen")->findBy(array("estado" => true));

        $html = '<option value=""></option>';
        if($imagen)
        {
            foreach($imagen aS $row)
            {
                $html .= '<option value="'.$row->getId().'">'.$row->getNombre().'</option>';
            }
        }

        return new Response($html);
    }

    /**
     * @Route("/combo/medicamento/", name="comboboxMedicamento")
     */
    public function getComboMedicamento()
    {
        $em = $this->getDoctrine()->getManager();
        $medicamento = $em->getRepository("AgendaBundle:Medicamento")->findBy(array("estado" => true));

        $html = '<option value=""></option>';
        if($medicamento)
        {
            foreach($medicamento aS $row)
            {
                $html .= '<option value="'.$row->getId().'">'.$row->getNombre().'</option>';
            }
        }

        return new Response($html);
    }

    /**
     * @Route("/combo/especialidades/{tipo}", name="comboboxEspecialidades")
     */
    public function getComboEspecialidades($tipo = 0)
    {
    	$em = $this->getDoctrine()->getManager();
    	$html = "";

    	if($tipo == 0)
    	{
    		$especialidades = $em->getRepository("AdministradorBundle:Especialidades")->findBy(array("estado" => true), array("id" => "DESC"));
    		foreach($especialidades as $row)
    		{
    			$html .= "<option value='".$row->getId()."'>".$row->getNombre()."</option>";
    		}    		
    	}
    	else
    	{
            $query = "select me from AdministradorBundle:MedicoEspecialidad me, AdministradorBundle:Especialidades e where me.idEspecialidad = e.id and e.estado = true and me.idMedico = :medico order by me.idEspecialidad DESC";
            $medEsp = $em->createQuery($query)->setParameter("medico", $_POST["idMedico"])->getResult();

            if($medEsp)
            {
                if(count($medEsp) > 1)
                {
                    foreach ($medEsp as $row) 
                    {
                        if($row->getIdEspecialidad()->getCodigo() != "MEDGENE")
                            $html .= "<option value='".$row->getIdEspecialidad()->getId()."'>".$row->getIdEspecialidad()->getNombre()."</option>";
                    }
                }
                else
                    $html .= "<option value='".$medEsp[0]->getIdEspecialidad()->getId()."'>".$medEsp[0]->getIdEspecialidad()->getNombre()."</option>";
            }
    	}
    	return new Response($html);
    }

    /**
     * @Route("/recursos/paciente/{id}/{cedula}", name="cedulaPaciente")
     */
    public function getPacientes($id = 0, $cedula="")
    {
    	$em = $this->getDoctrine()->getManager();
        $json = ["success" => false];
    	if($id != 0)
        {
    		$paciente = $em->getRepository("AdministradorBundle:Paciente")->find($id);
            if($paciente)
            {
                $edad = "0";
                if($paciente->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($paciente->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format("%y");
                }

                $json = [
                    "success" => true,
                    "idUsuario" => $paciente->getIdUsuario()->getId(),
                    "idPaciente" => $paciente->getId(),
                    "nombre" => $paciente->getIdUsuario()->getNombre(),
                    "apellido" => $paciente->getIdUsuario()->getApellido(),
                    "cedula" => $paciente->getIdUsuario()->getCedula(),
                    "tipo_iden" => $paciente->getIdUsuario()->getTipoIdentificacion(),
                    "usuario" => $paciente->getIdUsuario()->getLogin(),
                    "celular" => $paciente->getIdUsuario()->getTelefono(),
                    "email" => $paciente->getIdUsuario()->getEmail(),
                    "fechaNacimiento" => $paciente->getFechaNacimiento(),
                    "edad" => $edad,
                    "genero" => $paciente->getGenero(),
                    "estadoCivil" => $paciente->getEstadoCivil(),
                    "direccion" => $paciente->getDireccion(),
                    "sector" => $paciente->getSector(),
                    "contacto" => $paciente->getContacto(),
                    "ocupacion" => $paciente->getOcupacion(),
                    "medico" => $paciente->getIdMedico()->getId(),
                    "telefono" => $paciente->getTelefono(),
                    "aseguradora" => $paciente->getAseguradora(),
                    "provincia" => $paciente->getIdParroquia()->getIdCanton()->getIdProvincia()->getId(),
                    "provincia_nombre" => $paciente->getIdParroquia()->getIdCanton()->getIdProvincia()->getNombre(),
                    "canton" => $paciente->getIdParroquia()->getIdCanton()->getId(),
                    "canton_nombre" => $paciente->getIdParroquia()->getIdCanton()->getNombre(),
                    "parroquia" => $paciente->getIdParroquia()->getId(),
                    "parroquia_nombre" => $paciente->getIdParroquia()->getNombre()
                ];
            }
        }
    	else
        {
            $medico = $em->getRepository("AdministradorBundle:Medico")->find($_POST["medico"]);
            $query = "select p, u from AdministradorBundle:Paciente p, LoginBundle:Usuario u where u.id = p.idUsuario and u.rolUsuario = 4 and u.estado = true and u.cedula = '".$cedula."' and p.idMedico = ".$_POST["medico"];
            if($medico->getTipoHistorial())
            {
                $query = "select p, u from AdministradorBundle:Paciente p, LoginBundle:Usuario u where u.id = p.idUsuario and u.rolUsuario = 4 and u.estado = true and u.cedula = '".$cedula."'";
            }
            
            $paciente = $em->createQuery($query)->getResult();
            if($paciente)
            {
                $edad = "0";
                if($paciente[0]->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($paciente[0]->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format("%y");
                }

                $json = [
                    "success" => true,
                    "idUsuario" => $paciente[0]->getIdUsuario()->getId(),
                    "idPaciente" => $paciente[0]->getId(),
                    "nombre" => $paciente[0]->getIdUsuario()->getNombre(),
                    "apellido" => $paciente[0]->getIdUsuario()->getApellido(),
                    "cedula" => $paciente[0]->getIdUsuario()->getCedula(),
                    "tipo_iden" => $paciente[0]->getIdUsuario()->getTipoIdentificacion(),
                    "usuario" => $paciente[0]->getIdUsuario()->getLogin(),
                    "celular" => $paciente[0]->getIdUsuario()->getTelefono(),
                    "email" => $paciente[0]->getIdUsuario()->getEmail(),
                    "fechaNacimiento" => $paciente[0]->getFechaNacimiento(),
                    "edad" => $edad,
                    "genero" => $paciente[0]->getGenero(),
                    "estadoCivil" => $paciente[0]->getEstadoCivil(),
                    "direccion" => $paciente[0]->getDireccion(),
                    "sector" => $paciente[0]->getSector(),
                    "contacto" => $paciente[0]->getContacto(),
                    "ocupacion" => $paciente[0]->getOcupacion(),
                    "medico" => $paciente[0]->getIdMedico()->getId(),
                    "telefono" => $paciente[0]->getTelefono(),
                    "aseguradora" => $paciente[0]->getAseguradora(),
                    "provincia" => $paciente[0]->getIdParroquia()->getIdCanton()->getIdProvincia()->getId(),
                    "canton" => $paciente[0]->getIdParroquia()->getIdCanton()->getId(),
                    "parroquia" => $paciente[0]->getIdParroquia()->getId()
                ];
            }
        }
    	return new Response(json_encode($json));
    }

    /**
     * @Route("/recursos/horariosLaborables/")
     */
    public function getHorariosLaborables()
    {
    	$em = $this->getDoctrine()->getManager();

    	$horarios = $em->getRepository("AgendaBundle:HorariosLaborables")->findBy(array("idAgenda" => $_POST["idAgenda"], "idDiasLaborables" => $_POST["idDia"]), array("idDiasLaborables" => "ASC", "orden" => "ASC"));

    	$json = ["success" => false];

    	if($horarios)
    	{
    		$horario2 = [
                "idHorario2" => "",
				"horaInicio2" => "",
				"horaFin2" => ""
			];

    		if(@$horarios[1])
    		{
    			$horario2 = [
                    "idHorario2" => $horarios[1]->getId(),
    				"horaInicio2" => $horarios[1]->getHoraInicio(),
    				"horaFin2" => $horarios[1]->getHoraFin(),
                    "estado" => $horarios[1]->getEstado()
    			];
    		}

    		$json = [
    			"success" => true,
                "id" => $horarios[0]->getId(),
    			"agenda" => [
    				"idAgenda" => $horarios[0]->getIdAgenda()->getId(),
                    "medico" => [
                        "idMedico" => $horarios[0]->getIdAgenda()->getIdMedico()->getId(),
                        "nombre" => $horarios[0]->getIdAgenda()->getIdMedico()->getIdUsuario()->getNombre()." ".$horarios[0]->getIdAgenda()->getIdMedico()->getIdUsuario()->getApellido()
                    ]
    			],
    			"diasLaborables" => [
    				"idDia" => $horarios[0]->getIdDiasLaborables()->getId(),
    				"dia" => $horarios[0]->getIdDiasLaborables()->getNombre()
    			],
    			"horaInicio" => $horarios[0]->getHoraInicio(),
    			"horaFin" => $horarios[0]->getHoraFin(),
    			"horario2" => $horario2,
                "minutos" => $horarios[0]->getMinutos(),
                "estado" => $horarios[0]->getEstado()
    		];
    	}

    	return new Response(json_encode($json));
    }

    /**
     * @Route("/recursos/horariosLaborables/agenda/")
     */
    public function getHorariosLaborablesAgenda()
    {
        $em = $this->getDoctrine()->getManager();
        $horarios = $em->getRepository("AgendaBundle:HorariosLaborables")->findBy(array("idAgenda" => $_POST["idAgenda"]));

        if($horarios)
        {
            $con = 0;
            foreach($horarios as $row)
            {
                $json[] = [
                    "success" => true,
                    "idDia" => $row->getIdDiasLaborables()->getId()
                ];
                $con++;
            }
        }
        else
        {
            $json[] = [
                "success" => false
            ];
        }

        return new Response(json_encode($json));
    }

    /**
     * @Route("/recursos/agenda/", name="agendaMedico")
     */
    public function getAgenda()
    {
        $em = $this->getDoctrine()->getManager();
        $agenda = $em->getRepository("AgendaBundle:Agenda")->findOneBy(array("idMedico" => $_POST["idMedico"]));
        $json = [
            "success" => false
        ];

        if($agenda)
        {
            $json = [
                "success" => true,
                "idAgenda" => $agenda->getId(),
                "idMedico" => $agenda->getIdMedico()->getId()
            ];
        }

        $response = new Response();
        $response->setContent(json_encode($json));
        $response->headers->set('Content-Type', 'application/json');

        //return new Response(json_encode($json));
        return $response;
    }

    /**
     * @Route("/recursos/cita/")
     */
    public function getCitaMedica()
    {
        $em = $this->getDoctrine()->getManager();
        $id = $_POST["id"];

        if($_POST["idPaciente"] != "" && $_POST["fecha"] != "")
        {
            $citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->findOneBy(array("idPaciente" => $_POST["idPaciente"], "fecha" => $_POST["fecha"]));
        }
        else
        {
            $citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->find($id);
        }

        $json = ["success" => false];

        if($citaMedica)
        {
            $json = [
                "success" => true,
                "id" => $citaMedica->getId(),
                "paciente" => [
                    "idPaciente" => $citaMedica->getIdPaciente()->getId(),
                    "idUsuario" => $citaMedica->getIdPaciente()->getIdUsuario()->getId(),
                ],
                "estadoCita" => [
                    "idEstadoCita" => $citaMedica->getIdEstadoCita()->getId()
                ],
                "agenda" => [
                    "idAgenda" => $citaMedica->getIdAgenda()->getId()
                ],
                "especialidad" => [
                    "idEspecialidad" => $citaMedica->getIdEspecialidad()->getId()
                ],
                "fecha" => $citaMedica->getFecha(),
                "hora" => $citaMedica->getHora(),
            ];
        }

        return new Response(json_encode($json));
    }

    /**
     * @Route("/recursos/cantones/cmb/", name="cmbCantones")
     */
    public function getCmbCantones()
    {
        $em = $this->getDoctrine()->getManager();
        $cantones = $em->getRepository("AdministradorBundle:Cantones")->findBy(array("idProvincia" => $_POST["provincia"]), array("codigo" => "ASC"));
        $primerId = 0;
        $html = '';
        if($cantones)
        {
            $primerId = $cantones[0]->getId();
            foreach($cantones as $row)
            {
                $html .= '<option value="'.$row->getId().'" '.(($row->getId() == $_POST["id"]) ? "selected" : "").'>'.$row->getNombre().'</option>';
            }
        }
        $json = ["primerId" => $primerId, "cmb" => $html];
        return new Response(json_encode($json));
    }

    /**
     * @Route("/recursos/parroquias/cmb/", name="cmbParroquias")
     */
    public function getCmbParroquias()
    {
        $em = $this->getDoctrine()->getManager();
        $parroquias = $em->getRepository("AdministradorBundle:Parroquias")->findBy(array("idCanton" => $_POST["canton"]), array("codigo" => "ASC"));
        $primerId = 0;
        $html = '';
        if($parroquias)
        {
            $primerId = $parroquias[0]->getId();
            foreach($parroquias as $row)
            {
                $html .= '<option value="'.$row->getId().'" '.(($row->getId() == $_POST["id"]) ? "selected" : "").'>'.$row->getNombre().'</option>';
            }
        }
        $json = ["primerId" => $primerId, "cmb" => $html];
        return new Response(json_encode($json));
    }
}
