<?php

namespace AgendaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AdministradorBundle\Entity\ChatPromocion;

class PromocionesController extends Controller
{
	/**
	 * @Route("/promociones/", name="promocionesMedico")
	 */
	public function promocionesAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
			$promociones = $em->getRepository("AdministradorBundle:ChatPromocion")->findBy(array("idMedico" => $usuario->getIdMedico()->getId()));
			$noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }
			
			return $this->render("@Agenda/Promociones/index.html.twig", array("usuario" => $usuario, "promociones" => $promociones, "noticias" => $noticias));
		}
	}

	/**
	 * @Route("/promociones/vistas/", name="promocionesVistas")
	 */
	public function promocionesVistas(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
		$promociones = $em->getRepository("AdministradorBundle:ChatPromocion")->findBy(array("idMedico" => $usuario->getIdMedico()->getId()));
		foreach ($promociones as $row) 
		{
			$row->setEstado(true);
		}
		$em->flush();

		return new Response("ok");
	}

}
