<?php

namespace AgendaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;

class NotificacionesController extends Controller
{
	/**
	 * @Route("/notificaciones/pacientes/", name="notificacionPacientes")
	 */
	public function indexAction(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$m = "Recordatorio enviado a:";
		$citas = $em->getRepository("AgendaBundle:CitaMedica")->findBy(array("fecha" => date("Y-m-d", strtotime("+1 day"))));
		if($citas)
		{
			foreach($citas as $row)
			{
				if($row->getIdPaciente()->getIdUsuario()->getEmail() != null && $row->getIdPaciente()->getIdUsuario()->getEmail() != "")
				{
					$message = (new \Swift_Message("Recordatorio Cita Médica"))
					->setFrom($row->getIdAgenda()->getIdMedico()->getIdUsuario()->getEmail())
					->setTo($row->getIdPaciente()->getIdUsuario()->getEmail())
					//->setTo([$row->getIdPaciente()->getIdUsuario()->getEmail(), "mafer023028@gmail.com"])
					->setBody($this->renderView("@Agenda/Notificaciones/index.html.twig", array("cita" => $row)), 'text/html');

					$this->get("mailer")->send($message);
					$m .= "<br>".$row->getIdPaciente()->getIdUsuario()->getEmail();
				}
			}			
		}
		else
			$m = "ERROR";

		return new Response($m);
	}
}
