<?php

namespace AgendaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AgendaBundle\Entity\ImagenVideoEspecialidad;

class ImagenVideoEspecialidadController extends Controller
{
	/**
	 * @Route("/especialidad/subir/imagen/", name="subirImagenEspecialidad")
	 */
	public function subirImagenEspecialidad()
	{
		$em = $this->getDoctrine()->getManager();
		$imgVideo = new ImagenVideoEspecialidad();

		$imagen = $_FILES["flImagen"];
		$array = explode(".", $imagen["name"]);
		$extension = end($array);

		$nombreImage = md5(date("YmdHis")).".".$extension;
		$rutaImagen = "6973e3e05f3cea01fbdedd4/fotografias/".$nombreImage;
		$subir = move_uploaded_file($imagen["tmp_name"], $rutaImagen);

		if($subir)
		{
			chmod($rutaImagen, 0777);
			$this->redimensionar_imagen($rutaImagen, $extension);

			$paciente = $em->getRepository("AdministradorBundle:Paciente")->find($_POST["paciente"]);
			$especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find($_POST["especialidad"]);

			$imgVideo->setIdPaciente($paciente);
			$imgVideo->setIdEspecialidad($especialidad);
			$imgVideo->setUrlImgVideo($rutaImagen);
			$imgVideo->setTipoImgVideo("IMG");
			$imgVideo->setEstado(true);

			$em->persist($imgVideo);
			$em->flush();

			return new Response("ok");
		}
		else
			return new Response("nok");
	}

	/**
	 * @Route("/especialidad/subir/video/", name="subirVideoEspecialidad")
	 */
	public function subirVideoEspecialidad()
	{
		$em = $this->getDoctrine()->getManager();
		$imgVideo = new ImagenVideoEspecialidad();

		$video = $_FILES["flVideo"];
		$array = explode(".", $video["name"]);
		$extension = end($array);

		$nombreVideo = md5(date("YmdHis")).".".$extension;
		$rutaVideo = "6973e3e05f3cea01fbdedd4/videos/".$nombreVideo;
		$subir = move_uploaded_file($video["tmp_name"], $rutaVideo);

		if($subir)
		{
			chmod($rutaVideo, 0777);

			$paciente = $em->getRepository("AdministradorBundle:Paciente")->find($_POST["paciente"]);
			$especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find($_POST["especialidad"]);

			$imgVideo->setIdPaciente($paciente);
			$imgVideo->setIdEspecialidad($especialidad);
			$imgVideo->setUrlImgVideo($rutaVideo);
			$imgVideo->setTipoImgVideo("VIDEO");
			$imgVideo->setEstado(true);

			$em->persist($imgVideo);
			$em->flush();

			return new Response("ok");
		}
		else
			return new Response("nok");			
	}

	/**
	 * @Route("/especialidad/read/imgvideo/", name="readImgVideo")
	 */
	public function getImagenVideoEspecialidad()
	{
		$em = $this->getDoctrine()->getManager();
		$imgVideo = $em->getRepository("AgendaBundle:ImagenVideoEspecialidad")->findBy(array("idPaciente" => $_POST["paciente"], "idEspecialidad" => $_POST["especialidad"], "tipoImgVideo" => $_POST["tipo"]));

		if($imgVideo)
		{
			foreach($imgVideo as $row)
			{
				$json[] = [
					"success" => true,
					"id" => $row->getId(),
					"ruta" => $row->getUrlImgVideo()
				];
			}
		}
		else
		{
			$json[] = [
				"success" => false
			];
		}

		return new Response(json_encode($json));
	}

	/**
	 * @Route("/especialidad/delete/imagen/", name="deleteImgEspecialidad")
	 */
	public function deleteImgEspecialidadAction(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$imgVideo = $em->getRepository("AgendaBundle:ImagenVideoEspecialidad")->find($request->get("id"));
		
		if(file_exists($imgVideo->getUrlImgVideo()))
			unlink($imgVideo->getUrlImgVideo());

		$em->remove($imgVideo);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/medico/logo/subir/", name="subirLogoMedico")
	 */
	public function subirLogoMedico()
	{
		$em = $this->getDoctrine()->getManager();
		$medico = $em->getRepository("AdministradorBundle:Medico")->find($_POST["medico"]);

		$imagen = $_FILES["flImagen"];
		$array = explode(".", $imagen["name"]);
		$extension = end($array);

		$nombreImage = md5($medico->getId().$medico->getIdUsuario()->getCedula()).".".$extension;
		$rutaImagen = "6973e3e05f3cea01fbdedd4/logos/".$nombreImage;
		$subir = move_uploaded_file($imagen["tmp_name"], $rutaImagen);

		if($subir)
		{
			chmod($rutaImagen, 0777);
			$this->redimensionar_imagen($rutaImagen, $extension);

			$img = file_get_contents($rutaImagen);
			$img64 = base64_encode($img);

			$medico->setUrlImagen($rutaImagen);
			$medico->setImagen($img64);
			$em->flush();

			return new Response($rutaImagen);
		}
		else
			return new Response("nok");
	}

	function redimensionar_imagen($rutaImagenOriginal, $extensionImagen)
	{
				
		list($ancho, $alto) = getimagesize($rutaImagenOriginal);

		if($ancho > $alto)
		{
			$max_ancho = 500;
			$max_alto = ($alto * 500)/$ancho;
		}
		else if($ancho < $alto)
		{
			$max_alto = 500;
			$max_ancho = ($ancho * 500)/$alto;
		}
		else
		{
			$max_ancho = 500;
			$max_alto = 500;
		}
		
		if($extensionImagen == "jpg" || $extensionImagen == "jpeg")
			$img_original=imagecreatefromjpeg($rutaImagenOriginal);
	    else if ($extensionImagen == "png")
	        $img_original = imagecreatefrompng($rutaImagenOriginal);
	    else if ($extensionImagen == "gif")
	        $img_original=imagecreatefromgif($rutaImagenOriginal);
		
		
		$tmp_img = imagecreatetruecolor($max_ancho, $max_alto);	
		
		imagecopyresampled($tmp_img, $img_original, 0, 0, 0, 0, $max_ancho, $max_alto, $ancho, $alto);
		
		imagedestroy($img_original);
		
		$calidad = 95;
		
		imagejpeg($tmp_img, $rutaImagenOriginal, $calidad);
	}
}
