<?php

namespace AgendaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AgendaBundle\Entity\EvolucionMedica;
use AgendaBundle\Entity\EvolucionSignosVitales;

class EvolucionController extends Controller
{
    /**
     * @Route("/evolucion/create", name="createEvolucionConsulta")
     */
    public function createEvolucionConsulta()
    {
    	$em = $this->getDoctrine()->getManager();
    	$resumenHc = $em->getRepository("AgendaBundle:ResumenHistoriaClinica")->find($_POST["resumen"]);

    	$evolucion = new EvolucionMedica();
    	$evolucion->setIdResumenHc($resumenHc);
    	$evolucion->setFecha(date("Y-m-d"));
    	$evolucion->setHora(date("H:i:s"));
    	$evolucion->setEvolucionObjetiva($_POST["objetiva"]);
    	$evolucion->setEvolucionSubjetiva($_POST["subjetiva"]);
    	$evolucion->setApreciacionEvolucion($_POST["apreciacion"]);
    	$evolucion->setPlanesEvolucion($_POST["planes"]);

    	$em->persist($evolucion);

        $preSist = $_POST["pre_sist"];
        $preDias = $_POST["pre_dias"];
        $freCard = $_POST["fre_card"];
        $freResp = $_POST["fre_resp"];
        $temBuca = $_POST["tem_buca"];
        $temAxil = $_POST["tem_axil"];
        $pesoKg = $_POST["peso_kg"];
        $pesoLb = $_POST["peso_lb"];
        $tallaCm = $_POST["talla_cm"];
        $indicMC = $_POST["indic_mc"];
        $periCef = $_POST["peri_cef"];
        $satOxig = $_POST["sat_oxig"];
        $periAbd = $_POST["peri_abd"];
        $tempAlt = $_POST["temp_alt"];
        $tipSangre = $_POST["tip_sangre"];

        if($_POST["sig_vit"] == "si")
        {
            $evoSigVit = new EvolucionSignosVitales();
            $evoSigVit->setIdEvolucion($evolucion);
            $evoSigVit->setPresionAsistolicaSv($preSist);
            $evoSigVit->setPresionDiastolicaSv($preDias);
            $evoSigVit->setFrecuenciaCardiaSv($freCard);
            $evoSigVit->setFrecuenciaRespiraSv($freResp);
            $evoSigVit->setTemperaturaBucalSv($temBuca);
            $evoSigVit->setTemperaturaAxilarSv($temAxil);
            $evoSigVit->setPesoSv($pesoKg);
            $evoSigVit->setConversionSv($pesoLb);
            $evoSigVit->setTallaSv($tallaCm);
            $evoSigVit->setIndiceMasaCorpSv($indicMC);
            $evoSigVit->setPerimetroCefilicoSv($periCef);
            $evoSigVit->setSaturacionOxigenoSv($satOxig);
            $evoSigVit->setPerimetroAbdominalSv($periAbd);
            $evoSigVit->setTemperaturaAltSv($tempAlt);
            $evoSigVit->setTipoSangreSv($tipSangre);

            $em->persist($evoSigVit);
        }

    	$em->flush();

    	return new Response("ok");
    }

    /**
     * @Route("/evolucion/read/", name="readEvolucionConsulta")
     */
    public function readEvolucionConsulta()
    {
    	$em = $this->getDoctrine()->getManager();
    	$evolucion = $em->getRepository("AgendaBundle:EvolucionMedica")->findBy(array("idResumenHc" => $_POST["resumen"]), array("id" => "DESC"));

    	$html = '';
    	if($evolucion)
    	{
    		$html .= '<table class="table table-sm table-bordered">
    		<thead class="thead-light">
    			<tr>
    				<th>Fecha</th><th>Evolución Objetiva</th><th>Evolución Subjetiva</th><th>Apreciación</th><th>Planes de Evolución</th><th></th>
    			</tr>
    		</thead>
    		<tbody>';
    		foreach($evolucion as $row)
    		{
    			$html .= '<tr>
					<td>'.$row->getFecha().' - '.$row->getHora().'</td>
					<td>'.nl2br($row->getEvolucionObjetiva()).'</td>
					<td>'.nl2br($row->getEvolucionSubjetiva()).'</td>
					<td>'.nl2br($row->getApreciacionEvolucion()).'</td>
					<td>'.nl2br($row->getPlanesEvolucion()).'</td>
                    <td>';

                $sigVitEvo = $em->getRepository("AgendaBundle:EvolucionSignosVitales")->findOneBy(array("idEvolucion" => $row->getId()));

                if($sigVitEvo)
                {
                    $html .= '<button type="button" class="btn btn-link btn-sm btnSigVitEvo" id="'.base64_encode($sigVitEvo->getId()).'">Signos Vitales</button>';
                }

				$html .= '</td></tr>';
    		}
    		$html .= '</tbody></table>';
    	}

    	return new Response($html);
    }

    /**
     * @Route("/evolucion/signos_vitales/", name="readEvolucionSignosVitales")
     */
    public function readEvolucionSignosVitales()
    {
        $em = $this->getDoctrine()->getManager();

        $sigVitEvo = $em->getRepository("AgendaBundle:EvolucionSignosVitales")->find($_POST["id"]);
        $html = '';

        if($sigVitEvo)
        {
            $contador3 = 0;
            $html .= '<table class="table table-striped">';

            if($sigVitEvo->getPresionAsistolicaSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Presión Sistólica:</strong> '.$sigVitEvo->getPresionAsistolicaSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getPresionDiastolicaSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Presión Diastólica:</strong> '.$sigVitEvo->getPresionDiastolicaSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getFrecuenciaCardiaSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Frecuencia Cardíaca:</strong>  '.$sigVitEvo->getFrecuenciaCardiaSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getFrecuenciaRespiraSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Frecuencia Respiratoria:</strong> '.$sigVitEvo->getFrecuenciaRespiraSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getTemperaturaBucalSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Temperatura Bucal:</strong>  '.$sigVitEvo->getTemperaturaBucalSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getTemperaturaAxilarSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Temperatura Axilar:</strong> '.$sigVitEvo->getTemperaturaAxilarSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getTallaSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Talla (cm):</strong> '.$sigVitEvo->getTallaSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getPesoSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Peso (kg):</strong> '.$sigVitEvo->getPesoSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getConversionSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Peso (lb):</strong> '.$sigVitEvo->getConversionSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getIndiceMasaCorpSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Indice de masa corporal:</strong> '.$sigVitEvo->getIndiceMasaCorpSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getPerimetroCefilicoSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Perímetro Cefílico:</strong> '.$sigVitEvo->getPerimetroCefilicoSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getSaturacionOxigenoSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Saturación de Oxígeno:</strong> '.$sigVitEvo->getSaturacionOxigenoSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getPerimetroAbdominalSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Perímetro Abdominal:</strong> '.$sigVitEvo->getPerimetroAbdominalSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getTemperaturaAltSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Temperatura Alterna:</strong> '.$sigVitEvo->getTemperaturaAltSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            if($sigVitEvo->getTipoSangreSv() != "")
            {
                $contador3++;
                if($contador3 == 1) 
                    $html .= '<tr>';
                $html .= '<td><strong>Tipo de Sangre:</strong> '.$sigVitEvo->getTipoSangreSv().'</td>';
                if($contador3 == 3)
                {
                    $html .= '</tr>';
                    $contador3 = 0;
                }
            }

            $html .= '</table>';
        }

        return new Response($html);
    }
}
