<?php

namespace AgendaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AgendaBundle\Entity\Documentos;
use AgendaBundle\Entity\Formulario024;
use AgendaBundle\Entity\Formulario053;
use AgendaBundle\Entity\NutricionFormulario;
use AgendaBundle\Entity\FormularioPsicologia;
use Knp\Bundle\SnappyBundle\Snappy\Response\PdfResponse;

class DocumentosMedicosController extends Controller
{
	/**
	 * @Route("/documentos/", name="homeDocum")
	 */
	public function indexAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || !$request->getSession()->has("usuario") || $request->getSession()->get("rol") == 1)
			return $this->redirectToRoute("logout");
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
            $noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }
			return $this->render("@Agenda/Documentos/index.html.twig", array("usuario" => $usuario, "noticias" => $noticias));
		}
	}

	/**
	 * @Route("/documentos/certificado/", name="documCertificado")
	 */
	public function certificadoAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || !$request->getSession()->has("usuario") || $request->getSession()->get("rol") == 1)
			return $this->redirectToRoute("logout");
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
            $noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
            	$medicos = $em->getRepository("AdministradorBundle:Medico")->findOneBy(array("idUsuario" => $request->getSession()->get("usuario")));
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $documento = $em->getRepository("AgendaBundle:Documentos")->findOneBy(array("codigo" => "CERTMED", "idMedico" => $medicos->getId()));
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }
            else
            {
            	$asistente = $em->getRepository("AdministradorBundle:Asistente")->findOneBy(array("idUsuario" => $request->getSession()->get("usuario")));
            	$medicos = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $asistente->getId()), array("idMedico" => "ASC"));
            	$documento = $em->getRepository("AgendaBundle:Documentos")->findOneBy(array("codigo" => "CERTMED", "idMedico" => $medicos[0]->getIdMedico()->getId()));
            }

			return $this->render("@Agenda/Documentos/certificado.html.twig", array(
				"usuario" => $usuario,
				"noticias" => $noticias,
				"medicos" => $medicos,
				"documento" => $documento
			));
		}
	}

	/**
     * @Route("/documentos/certificado/ocupacional", name="documCertificadoOcupa")
     */
    public function certificadoActionOcupacional(Request $request)
    {
        if (
            !$request->getSession()->has('rol') ||
            !$request->getSession()->has('usuario') ||
            $request->getSession()->get('rol') == 1
        ) {
            return $this->redirectToRoute('logout');
        } else {
            $em = $this->getDoctrine()->getManager();
            $usuario = $em
                ->getRepository('LoginBundle:Usuario')
                ->find($request->getSession()->get('usuario'));
            $noticias = '';
            if ($request->getSession()->get('rol') == 2) {
                $medicos = $em
                    ->getRepository('AdministradorBundle:Medico')
                    ->findOneBy([
                        'idUsuario' => $request->getSession()->get('usuario'),
                    ]);
                $queryNot =
                    'select n from AdministradorBundle:Noticas n order by n.id desc';
                $documento = $em
                    ->getRepository('AgendaBundle:Documentos')
                    ->findOneBy([
                        'codigo' => 'CERTOCU',
                        'idMedico' => $medicos->getId(),
                    ]);
                    if($documento == null){
                       $documento1 = new Documentos();
                       $documento1->setIdMedico($medicos); 
                       $documento1->setCodigo('CERTOCU');
                       $documento1->setTexto('<p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif"><strong>CERTIFICADO OCUPACIONAL </strong></span></span></p>

                       <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Dr./Dra. PROMDOCTOR&nbsp;M&eacute;dico PROMESPECIALIDAD del PROMCONSULTORIO<strong>&nbsp;</strong></span></span></p>
                       
                       <p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">CERTIFICO</span></span></p>
                       
                       <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Que el Sr/Sra PROMPACIENTE&nbsp;con c&eacute;dula de identidad No. PROMCEDPACIENTE, de PROMEDAD a&ntilde;os de edad, de nacionalidad PROMNACIONALIDAD luego de ex&aacute;men m&eacute;dico, laboratorial y con diagn&oacute;stico: PROMDIAGNOSTICO, se encuentra en perfecto estado de salud para desempe&ntilde;ar actividades laborales de PROMACTIVIDADES.</span></span></p>
                       
                       <p>&nbsp;</p>
                       
                       <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Es todo cuanto puedo certificar, pudiendo el peticionario hacer uso del presente certificado para los fines que estime conveniente, excepto los que no contemple la ley.</span></span></p>
                       
                       <p>&nbsp;</p>
                       
                       <p>&nbsp;</p>
                       
                       <p>PROMFECHA</p>
                       
                       <p>&nbsp;</p>
                       ');
                       $em->persist($documento1);
                       $em->flush();
                       $documento = $documento1;
                    }
                $noticias = $em
                    ->createQuery($queryNot)
                    ->setMaxResults(1)
                    ->getResult();
            } else {
                $asistente = $em
                    ->getRepository('AdministradorBundle:Asistente')
                    ->findOneBy([
                        'idUsuario' => $request->getSession()->get('usuario'),
                    ]);
                $medicos = $em
                    ->getRepository('AdministradorBundle:AsistenteMedico')
                    ->findBy(
                        ['idAsistente' => $asistente->getId()],
                        ['idMedico' => 'ASC']
                    );
                $documento = $em
                    ->getRepository('AgendaBundle:Documentos')
                    ->findOneBy([
                        'codigo' => 'CERTOCU',
                        'idMedico' => $medicos[0]->getIdMedico()->getId(),
                    ]);

                    if($documento == null){

                        $medicon = $em
                        ->getRepository('AdministradorBundle:Medico')
                        ->findOneBy([
                            'idUsuario' => $request->getSession()->get('usuario'),
                        ]);

                        $documento1 = new Documentos();
                        $documento1->setIdMedico($medicon); 
                        $documento1->setCodigo('CERTOCU');
                        $documento1->setTexto('<p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif"><strong>CERTIFICADO OCUPACIONAL </strong></span></span></p>
 
                        <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Dr./Dra. PROMDOCTOR&nbsp;M&eacute;dico PROMESPECIALIDAD del PROMCONSULTORIO<strong>&nbsp;</strong></span></span></p>
                        
                        <p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">CERTIFICO</span></span></p>
                        
                        <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Que el Sr/Sra PROMPACIENTE&nbsp;con c&eacute;dula de identidad No. PROMCEDPACIENTE, de PROMEDAD a&ntilde;os de edad, de nacionalidad PROMNACIONALIDAD luego de ex&aacute;men m&eacute;dico, laboratorial y con diagn&oacute;stico: PROMDIAGNOSTICO, se encuentra en perfecto estado de salud para desempe&ntilde;ar actividades laborales de PROMACTIVIDADES.</span></span></p>
                        
                        <p>&nbsp;</p>
                        
                        <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Es todo cuanto puedo certificar, pudiendo el peticionario hacer uso del presente certificado para los fines que estime conveniente, excepto los que no contemple la ley.</span></span></p>
                        
                        <p>&nbsp;</p>
                        
                        <p>&nbsp;</p>
                        
                        <p>PROMFECHA</p>
                        
                        <p>&nbsp;</p>
                        ');
                        $em->persist($documento1);
                        $em->flush();
                        $documento = $documento1;
                     }

                //Validar con asistentes la creación del documento    
            }

            return $this->render(
                '@Agenda/Documentos/certificadoOcupacional.html.twig',
                [
                    'usuario' => $usuario,
                    'noticias' => $noticias,
                    'medicos' => $medicos,
                    'documento' => $documento,
                ]
            );
        }
    }

	/**
     * @Route("/documentos/certificado/general", name="documCertificadoGener")
     */
    public function certificadoActionGeneral(Request $request)
    {
        if (
            !$request->getSession()->has('rol') ||
            !$request->getSession()->has('usuario') ||
            $request->getSession()->get('rol') == 1
        ) {
            return $this->redirectToRoute('logout');
        } else {
            $em = $this->getDoctrine()->getManager();
            $usuario = $em
                ->getRepository('LoginBundle:Usuario')
                ->find($request->getSession()->get('usuario'));
            $noticias = '';
            if ($request->getSession()->get('rol') == 2) {
                $medicos = $em
                    ->getRepository('AdministradorBundle:Medico')
                    ->findOneBy([
                        'idUsuario' => $request->getSession()->get('usuario'),
                    ]);
                $queryNot =
                    'select n from AdministradorBundle:Noticas n order by n.id desc';
                $documento = $em
                    ->getRepository('AgendaBundle:Documentos')
                    ->findOneBy([
                        'codigo' => 'CERTGEN',
                        'idMedico' => $medicos->getId(),
                    ]);

                if($documento == null){
                    $documento1 = new Documentos();
                    $documento1->setIdMedico($medicos); 
                    $documento1->setCodigo('CERTGEN');
                    $documento1->setTexto('<p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif"><strong>CERTIFICADO POBLACI&Oacute;N EN GENERAL </strong></span></span></p>

                    <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Dr./Dra. PROMDOCTOR&nbsp;M&eacute;dico PROMESPECIALIDAD del PROMCONSULTORIO<strong>&nbsp;</strong></span></span></p>
                    
                    <p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">CERTIFICO</span></span></p>
                    
                    <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Que el Sr/Sra PROMPACIENTE&nbsp;con c&eacute;dula de identidad No. PROMCEDPACIENTE, de PROMEDAD a&ntilde;os de edad, de nacionalidad PROMNACIONALIDAD luego de ex&aacute;men m&eacute;dico, laboratorial y con diagn&oacute;stico: PROMDIAGNOSTICO, se encuentra en &oacute;ptimas condiciones de salud.</span></span></p>
                    
                    <p>&nbsp;</p>
                    
                    <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Es todo cuanto puedo certificar, pudiendo el peticionario hacer uso del presente certificado para los fines que estime conveniente, excepto los que no contemple la ley.</span></span></p>
                    
                    <p>&nbsp;</p>
                    
                    <p>&nbsp;</p>
                    
                    <p>PROMFECHA</p>
                    
                    <p>&nbsp;</p>
                    
                    ');
                    $em->persist($documento1);
                    $em->flush();
                    $documento = $documento1;
                    }
                $noticias = $em
                    ->createQuery($queryNot)
                    ->setMaxResults(1)
                    ->getResult();
            } else {
                $asistente = $em
                    ->getRepository('AdministradorBundle:Asistente')
                    ->findOneBy([
                        'idUsuario' => $request->getSession()->get('usuario'),
                    ]);
                $medicos = $em
                    ->getRepository('AdministradorBundle:AsistenteMedico')
                    ->findBy(
                        ['idAsistente' => $asistente->getId()],
                        ['idMedico' => 'ASC']
                    );
                $documento = $em
                    ->getRepository('AgendaBundle:Documentos')
                    ->findOneBy([
                        'codigo' => 'CERTGEN',
                        'idMedico' => $medicos[0]->getIdMedico()->getId(),
                    ]);

                    if($documento == null){

                        $medicon = $em
                        ->getRepository('AdministradorBundle:Medico')
                        ->findOneBy([
                            'idUsuario' => $request->getSession()->get('usuario'),
                        ]);


                        $documento1 = new Documentos();
                        $documento1->setIdMedico($medicon); 
                        $documento1->setCodigo('CERTGEN');
                        $documento1->setTexto('<p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif"><strong>CERTIFICADO POBLACI&Oacute;N EN GENERAL </strong></span></span></p>
    
                        <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Dr./Dra. PROMDOCTOR&nbsp;M&eacute;dico PROMESPECIALIDAD del PROMCONSULTORIO<strong>&nbsp;</strong></span></span></p>
                        
                        <p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">CERTIFICO</span></span></p>
                        
                        <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Que el Sr/Sra PROMPACIENTE&nbsp;con c&eacute;dula de identidad No. PROMCEDPACIENTE, de PROMEDAD a&ntilde;os de edad, de nacionalidad PROMNACIONALIDAD luego de ex&aacute;men m&eacute;dico, laboratorial y con diagn&oacute;stico: PROMDIAGNOSTICO, se encuentra en &oacute;ptimas condiciones de salud.</span></span></p>
                        
                        <p>&nbsp;</p>
                        
                        <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Es todo cuanto puedo certificar, pudiendo el peticionario hacer uso del presente certificado para los fines que estime conveniente, excepto los que no contemple la ley.</span></span></p>
                        
                        <p>&nbsp;</p>
                        
                        <p>&nbsp;</p>
                        
                        <p>PROMFECHA</p>
                        
                        <p>&nbsp;</p>
                        
                        ');
                        $em->persist($documento1);
                        $em->flush();
                        $documento = $documento1;
                        }

            }

            return $this->render(
                '@Agenda/Documentos/certificadoGeneral.html.twig',
                [
                    'usuario' => $usuario,
                    'noticias' => $noticias,
                    'medicos' => $medicos,
                    'documento' => $documento,
                ]
            );
        }
    }
    
    /**
     * @Route("/documentos/certificado/movilidad", name="documCertificadoMovil")
     */
    public function certificadoActionMovilidad(Request $request){
        if (
            !$request->getSession()->has('rol') ||
            !$request->getSession()->has('usuario') ||
            $request->getSession()->get('rol') == 1
        ) {
            return $this->redirectToRoute('logout');
        } else {
        $em = $this->getDoctrine()->getManager();
        $usuario = $em
            ->getRepository('LoginBundle:Usuario')
            ->find($request->getSession()->get('usuario'));
        $noticias = '';
        if ($request->getSession()->get('rol') == 2) {
            $medicos = $em
                ->getRepository('AdministradorBundle:Medico')
                ->findOneBy([
                    'idUsuario' => $request->getSession()->get('usuario'),
                ]);
            $queryNot =
                'select n from AdministradorBundle:Noticas n order by n.id desc';
            $documento = $em
                ->getRepository('AgendaBundle:Documentos')
                ->findOneBy([
                    'codigo' => 'CERTMOV',
                    'idMedico' => $medicos->getId(),
                ]);
            if($documento == null){
                $documento1 = new Documentos();
                $documento1->setIdMedico($medicos);
                $documento1->setCodigo('CERTMOV');
                $documento1->setTexto('<p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif"><strong>CERTIFICADO DE MOVILIDAD</strong></span></span></p></body></br>

                <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Fecha: PROMFECHA</span></span></br>
                <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Paciente: PROMPACIENTE</span></span></br>
                
                </br><p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">PROMDESTINATARIO</span></span></p>
        
                <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Presente.</span></span></br>
                
                <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Por medio de la presente, emito el respectivo certificado para que PROMPACIENTE&nbsp;con c&eacute;dula de identidad No. PROMCEDPACIENTE, acuda el PROMOVILF al PROMDESTINO, en compa&ntilde;&iacute;a de PROMACOMPA con c&eacute;dula de identidad No. PROMCEDACOMPA para realizar su respectivo ex&aacute;men PROMEXAMEN, para PROMOTIVO, en el automovil con Placa PROMPLACA.</span></span></p>
                
                <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Agradecemos por su respectiva colaboraci&oacute;n.</span></span></p>
                
                <p>&nbsp;</p>
                
                <p>&nbsp;</p>
                
                <p></p>
                
                <p>&nbsp;</p>');
                $em->persist($documento1);
                $em->flush();
                $documento = $documento1;
            }
            $noticias = $em
                ->createQuery($queryNot)
                ->setMaxResults(1)
                ->getResult();
        } else{
            $asistente = $em
                ->getRepository('AdministradorBundle:Asistente')
                ->findOneBy([
                    'idUsuario' => $request->getSession()->get('usuario')
                ]);
            $medicos = $em
                ->getRepository('AdministradorBundle:AsistenteMedico')
                ->findBy(
                    ['idAsistente' => $asistente->getId()],
                    ['idMedico' => 'ASC']
                );
            $documento = $em
                ->getRepository('AgendaBundle:Documentos')
                ->findOneBy([
                    'codigo' => 'CERTMOV',
                    'idMedico' => $medicos[0]->getIdMedico->getId()
                ]);
            if($documento == null){

                $medicon = $em
                    ->getRepository('AdministradorBundle:Medico')
                    ->findOneBy([
                        'idUsuario' => $request->getSession()->get('usuario'),
                    ]);

                    $documento1 = new Documentos();
                    $documento1->setIdMedico($medicon); 
                    $documento1->setCodigo('CERTMOV');
                    $documento1->setTexto('<p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif"><strong>CERTIFICADO DE MOVILIDAD</strong></span></span></p></body></br>

                    <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Fecha: PROMFECHA</span></span></br>
                    <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Paciente: PROMPACIENTE</span></span></br>
                    
                    </br><p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">PROMDESTINATARIO</span></span></p>
            
                    <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Presente.</span></span></br>
                    
                    <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Por medio de la presente, emito el respectivo certificado para que PROMPACIENTE&nbsp;con c&eacute;dula de identidad No. PROMCEDPACIENTE, acuda el PROMOVILF al PROMDESTINO, en compa&ntilde;&iacute;a de PROMACOMPA con c&eacute;dula de identidad No. PROMCEDACOMPA para realizar su respectivo ex&aacute;men PROMEXAMEN, para PROMOTIVO, en el automovil con Placa PROMPLACA.</span></span></p>
                    
                    <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Agradecemos por su respectiva colaboraci&oacute;n.</span></span></p>
                    
                    <p>&nbsp;</p>
                    
                    <p>&nbsp;</p>
                    
                    <p></p>
                    
                    <p>&nbsp;</p>
                    ');
                    $em->persist($documento1);
                    $em->flush();
                    $documento = $documento1;

            }
        }
        
            return $this->render('@Agenda/Documentos/certificadoMovilidad.html.twig', [
                'usuario' => $usuario,
                'noticias' => $noticias,
                'medicos' => $medicos,
                'documento' => $documento,
            ]);
        }
    }

    /**
     * @Route("/documentos/orden/ingreso", name="documOrdenIngreso")
     */
    public function ordenActionIngreso(Request $request) {
        if (
            !$request->getSession()->has('rol') ||
            !$request->getSession()->has('usuario') ||
            $request->getSession()->get('rol') == 1
        ) {
            return $this->redirectToRoute('logout');
        } else {
            $em = $this->getDoctrine()->getManager();
            $usuario = $em
                ->getRepository('LoginBundle:Usuario')
                ->find($request->getSession()->get('usuario'));
            $noticias = '';
            if ($request->getSession()->get('rol') == 2) {
                $medicos = $em
                    ->getRepository('AdministradorBundle:Medico')
                    ->findOneBy([
                        'idUsuario' => $request->getSession()->get('usuario'),
                    ]);
                $queryNot =
                    'select n from AdministradorBundle:Noticas n order by n.id desc';
                $documento = $em
                    ->getRepository('AgendaBundle:Documentos')
                    ->findOneBy([
                        'codigo' => 'ORDING',
                        'idMedico' => $medicos->getId(),
                    ]);

                if($documento == null){
                    $documento1 = new Documentos();
                    $documento1->setIdMedico($medicos); 
                    $documento1->setCodigo('ORDING');
                    $documento1->setTexto('<p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">PROMFECHA</span></span></br></p>
                    <p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif"><strong>ORDEN DE INGRESO</strong></span></span></p></body></br>
            
                    <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">PROMDESTINATARIO</span></span></p></br>
                    
                    <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Favor ingresar a PROMPACIENTE&nbsp;con diagn&oacute;stico de PROMDIAGNOSTICO para realizarse un PROMPEXAMEN.</span></span></p>
                    
                    <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Fecha de ingreso: PROMINGRESOF</span></span></br>
                    <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Hora de ingreso: PROMHORAI</span></span></br>
            
                    </br><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Fecha de cirugia: PROMCIRFECHA</span></span></br>
                    <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Hora de cirugia: PROMCIRUGIAH</span></span>
                    
                    <p>&nbsp;</p>
                    
                    <p></p>
                    
                    <p>&nbsp;</p>
                    
                    ');
                    $em->persist($documento1);
                    $em->flush();
                    $documento = $documento1;
                    }
                $noticias = $em
                    ->createQuery($queryNot)
                    ->setMaxResults(1)
                    ->getResult();
            } else {
                $asistente = $em
                    ->getRepository('AdministradorBundle:Asistente')
                    ->findOneBy([
                        'idUsuario' => $request->getSession()->get('usuario'),
                    ]);
                $medicos = $em
                    ->getRepository('AdministradorBundle:AsistenteMedico')
                    ->findBy(
                        ['idAsistente' => $asistente->getId()],
                        ['idMedico' => 'ASC']
                    );
                $documento = $em
                    ->getRepository('AgendaBundle:Documentos')
                    ->findOneBy([
                        'codigo' => 'ORDING',
                        'idMedico' => $medicos[0]->getIdMedico()->getId(),
                    ]);

                    if($documento == null){

                        $medicon = $em
                        ->getRepository('AdministradorBundle:Medico')
                        ->findOneBy([
                            'idUsuario' => $request->getSession()->get('usuario'),
                        ]);


                        $documento1 = new Documentos();
                        $documento1->setIdMedico($medicon); 
                        $documento1->setCodigo('ORDING');
                        $documento1->setTexto('<p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">PROMFECHA</span></span></br></p>
                        <p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif"><strong>ORDEN DE INGRESO</strong></span></span></p></body></br>
                
                        <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">PROMDESTINATARIO</span></span></p></br>
                        
                        <p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Favor ingresar a PROMPACIENTE&nbsp;con diagn&oacute;stico de PROMDIAGNOSTICO para realizarse un PROMPEXAMEN.</span></span></p>
                        
                        <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Fecha de ingreso: PROMINGRESOF</span></span></br>
                        <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Hora de ingreso: PROMHORAI</span></span></br>
                
                        </br><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Fecha de cirugia: PROMCIRFECHA</span></span></br>
                        <span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Hora de cirugia: PROMCIRUGIAH</span></span>
                        
                        <p>&nbsp;</p>
                        
                        <p></p>
                        
                        <p>&nbsp;</p>
                        
                        ');
                        $em->persist($documento1);
                        $em->flush();
                        $documento = $documento1;
                        }

            }

            return $this->render(
                '@Agenda/Documentos/ordenIngreso.html.twig',
                [
                    'usuario' => $usuario,
                    'noticias' => $noticias,
                    'medicos' => $medicos,
                    'documento' => $documento,
                ]
            );
        }
    }

	/**
	 * @Route("/documentos/consentimiento/", name="documConsentimiento")
	 */
	public function consentimientoAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || !$request->getSession()->has("usuario") || $request->getSession()->get("rol") == 1)
			return $this->redirectToRoute("logout");
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
            $noticias = "";
            $formularios = null;
            if($request->getSession()->get("rol") == 2)
            {
            	$medicos = $em->getRepository("AdministradorBundle:Medico")->findOneBy(array("idUsuario" => $usuario->getId()));
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }
            else
            {
            	$asistente = $em->getRepository("AdministradorBundle::Asistente")->findOneBy(array("idUsuario" => $usuario->getId()));
            	$medicos = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $asistente->getId()));
            }

			return $this->render("@Agenda/Documentos/consentimiento.html.twig", array(
				"usuario" => $usuario,
				"noticias" => $noticias,
				"medicos" => $medicos
			));
		}
	}

	/**
     * @Route("/documentos/referencia/", name="documReferencia")
     */
    public function referenciaAction(Request $request)
    {
        if (
            !$request->getSession()->has('rol') ||
            !$request->getSession()->has('usuario') ||
            $request->getSession()->get('rol') == 1
        ) {
            return $this->redirectToRoute('logout');
        } else {
            $em = $this->getDoctrine()->getManager();
            $usuario = $em
                ->getRepository('LoginBundle:Usuario')
                ->find($request->getSession()->get('usuario'));
            $noticias = '';
            $formularios = null;
            if ($request->getSession()->get('rol') == 2) {
                $medicos = $em
                    ->getRepository('AdministradorBundle:Medico')
                    ->findOneBy(['idUsuario' => $usuario->getId()]);
                $queryNot =
                    'select n from AdministradorBundle:Noticas n order by n.id desc';
                $noticias = $em
                    ->createQuery($queryNot)
                    ->setMaxResults(1)
                    ->getResult();
            } else {
                $asistente = $em
                    ->getRepository('AdministradorBundle::Asistente')
                    ->findOneBy(['idUsuario' => $usuario->getId()]);
                $medicos = $em
                    ->getRepository('AdministradorBundle:AsistenteMedico')
                    ->findBy(['idAsistente' => $asistente->getId()]);
            }

            return $this->render('@Agenda/Documentos/referencia.html.twig', [
                'usuario' => $usuario,
                'noticias' => $noticias,
                'medicos' => $medicos,
            ]);
        }
    }
    
    /**
     * @Route("/documentos/nutricion/", name="documNutricion")
     */
    public function nutricionalAction(Request $request){
        if (
            !$request->getSession()->has('rol') ||
            !$request->getSession()->has('usuario') ||
            $request->getSession()->get('rol') == 1
        ) {
            return $this->redirectToRoute('logout');
        } else {
            $em = $this->getDoctrine()->getManager();
            $usuario = $em
                ->getRepository('LoginBundle:Usuario')
                ->find($request->getSession()->get('usuario'));
            $noticias = '';
            $formularios = null;
            if($request->getSession()->get('rol') == 2){
                $medicos = $em
                    ->getRepository('AdministradorBundle:Medico')
                    ->findOneBy(['idUsuario' => $usuario->getId()]);
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em
                    ->createQuery($queryNot)
                    ->setMaxResults(1)
                    ->getResult();
            }else{
                $asistente = $em
                    ->getRepository('AdministradorBundle:Asistente')
                    ->findOneBy(['idUsuario' => $usuario->getId()]);
                $medicos = $em
                    ->getRepository('AdministradorBundle:AsistenteMedico')
                    ->findBy(['idAsistente' => $asistente->getId()]);
            }

            return $this->render('@Agenda/Documentos/nutricion.html.twig', [
                'usuario' => $usuario,
                'noticias' => $noticias,
                'medicos' => $medicos,
            ]);
        }
    }

	/**
	 * @Route("/documentos/consentimiento/formulario024/{idMedico}/{idForm}", name="formulario024")
	 */
	public function formulario024Action(Request $request, $idMedico = 0, $idForm = 0)
	{
		if(!$request->getSession()->has("rol") || !$request->getSession()->has("usuario") || $request->getSession()->get("rol") == 1)
			return $this->redirectToRoute("logout");
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
            $noticias = "";
            $fecha = date("Y-m-d");
            $hora = date("H:i:s");
            $medico = $em->getRepository("AdministradorBundle:Medico")->find(base64_decode($idMedico));
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }

            if(base64_decode($idForm) != 0)
            {
            	$formulario = $em->getRepository("AgendaBundle:Formulario024")->find(base64_decode($idForm));
            	$edad = "No definida";
                if($formulario->getIdPaciente()->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($formulario->getIdPaciente()->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format("%y")." años";
                }

            	return $this->render("@Agenda/Documentos/form024.html.twig", array(
					"usuario" => $usuario,
					"noticias" => $noticias,
					"medico" => $medico,
					"fecha" => $fecha,
					"hora" => $hora,
					"edad" => $edad,
					"formulario" => $formulario
				));
            }
            else
            {
            	return $this->render("@Agenda/Documentos/form024.html.twig", array(
					"usuario" => $usuario,
					"noticias" => $noticias,
					"medico" => $medico,
					"fecha" => $fecha,
					"hora" => $hora
				));
            }
		}
	}

	/**
     * @Route("/documentos/referencia/formulario053/{idMedico}/{idForm}", name="formulario053")
     */
    public function formulario053Action(
        Request $request,
        $idMedico = 0,
        $idForm = 0
    ) {
        if (
            !$request->getSession()->has('rol') ||
            !$request->getSession()->has('usuario') ||
            $request->getSession()->get('rol') == 1) 
            {
            return $this->redirectToRoute('logout');
        } else {
            $em = $this->getDoctrine()->getManager();
            $usuario = $em
                ->getRepository('LoginBundle:Usuario')
                ->find($request->getSession()->get('usuario'));
            $noticias = '';
            $fecha = date('Y-m-d');
            $hora = date('H:i:s');
            $medico = $em
                ->getRepository('AdministradorBundle:Medico')
                ->find(base64_decode($idMedico));
            if ($request->getSession()->get('rol') == 2) {
                $queryNot =
                    'select n from AdministradorBundle:Noticas n order by n.id desc';
                $noticias = $em
                    ->createQuery($queryNot)
                    ->setMaxResults(1)
                    ->getResult();
            }

            if (base64_decode($idForm) != 0) {
                
                $formulario = $em
                    ->getRepository('AgendaBundle:Formulario053')
                    ->find(base64_decode($idForm));
                $edad = 'No definida';
                if (
                    $formulario->getIdPaciente() != null
                ) {
                    $fechaHoy = date_create(date('Y-m-d'));
                    $fechaNac = date_create(
                        $formulario->getIdPaciente()->getFechaNacimiento()
                    );
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y') . ' años';
                }
                return $this->render('@Agenda/Documentos/form053.html.twig', [
                    'usuario' => $usuario,
                    'noticias' => $noticias,
                    'medico' => $medico,
                    'fecha' => $fecha,
                    'hora' => $hora,
                    'edad' => $edad,
                    'formulario' => $formulario,
                ]);
            } else {
                return $this->render('@Agenda/Documentos/form053.html.twig', [
                    'usuario' => $usuario,
                    'noticias' => $noticias,
                    'medico' => $medico,
                    'fecha' => $fecha,
                    'hora' => $hora,
                ]);
            }
        }
    }
    
    /**
     * @Route("/documentos/informe/nutricional/{idMedico}/{idForm}", name="informeNutricional")
     */
    public function informeNutricionalAction(
        Request $request,
        $idMedico = 0,
        $idForm = 0
    ){
        if (
            !$request->getSession()->has('rol') ||
            !$request->getSession()->has('usuario') ||
            $request->getSession()->get('rol') == 1)
            {
            return $this->redirectToRoute('logout');
        } else {
            $em = $this->getDoctrine()->getManager();
            $usuario = $em
                ->getRepository('LoginBundle:Usuario')
                ->find($request->getSession()->get('usuario'));
            $noticias = '';
            $fecha = date('Y-m-d');
            $hora = date('H:i:s');
            $medico = $em
                ->getRepository('AdministradorBundle:Medico')
                ->find(base64_decode($idMedico));
            if ($request->getSession()->get('rol') == 2) {
                $queryNot =
                    'select n from AdministradorBundle:Noticas n order by n.id desc';
                $noticias = $em
                    ->createQuery($queryNot)
                    ->setMaxResults(1)
                    ->getResult();
            }

            if (base64_decode($idForm) != 0) {

                $formulario = $em
                    ->getRepository('AgendaBundle:NutricionFormulario')
                    ->find(base64_decode($idForm));
                $edad = 'No definida';
                return $this->render('@Agenda/Documentos/infoNutricion.html.twig', [
                    'usuario' => $usuario,
                    'noticias' => $noticias,
                    'medico' => $medico,
                    'formulario' => $formulario,
                ]);
            } else {
                return $this->render('@Agenda/Documentos/infoNutricion.html.twig', [
                    'usuario' => $usuario,
                    'noticias' => $noticias,
                    'medico' => $medico,
                ]);
            }
        }
    }

	/**
	 * @Route("/certificado/update/", name="updateCertificado")
	 */
	public function updateCertificadoAction(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$medico = $em->getRepository("AdministradorBundle:Medico")->find($request->get("medico"));
		$documento = $em->getRepository("AgendaBundle:Documentos")->findOneBy(array("idMedico" => $medico->getId(), "codigo" => $request->get("codigo")));
		$documento->setTexto($request->get("texto"));
		$em->flush();
		return new Response("ok");
	}

	/**
	 * @Route("/certificado/medico/", name="getCertificado")
	 */
	public function getCertificadoAction(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$medico = $em->getRepository("AdministradorBundle:Medico")->find($request->get("medico"));
		$documento = $em->getRepository("AgendaBundle:Documentos")->findOneBy(array("idMedico" => $medico->getId(), "codigo" => $request->get("codigo")));

		return new Response($documento->getTexto());
	}

	/**
	 * @Route("/consentimiento/store/", name="storeConsentimiento")
	 */
	public function storeConsentimientoAction(Request $request)
	{
		$em = $this->getDoctrine()->getManager();

		if($request->get("inputForm") != "0")
		{
			$formulario = $em->getRepository("AgendaBundle:Formulario024")->find($request->get("inputForm"));
			$formulario->setRevocatoria(true);
			$formulario->setFechaR(date("Y-m-d"));
			$formulario->setHoraR(date("H:i:s"));
			$formulario->setRpNombreR($request->get("inputRpNomR"));
			$formulario->setRpCedulaR($request->get("inputRpCedR"));
			$formulario->setRpParentescoR($request->get("inputRpParenR"));
		}
		else
		{
			$paciente = $em->getRepository("AdministradorBundle:Paciente")->find($request->get("inputPaciente"));
			$medico = $em->getRepository("AdministradorBundle:Medico")->find($request->get("inputMedico"));
			$cieDiez = $em->getRepository("AgendaBundle:CieDiez")->find($request->get("cmbCieDiez"));

			$formulario = new Formulario024();
			$formulario->setIdPaciente($paciente);
			$formulario->setIdMedico($medico);
			$formulario->setIdCieDiez($cieDiez);
			$formulario->setFecha(date("Y-m-d"));
			$formulario->setHora(date("H:i:s"));
			$formulario->setProcedimiento($request->get("inputProcedimiento"));
			$formulario->setDetalleProc($request->get("inputDetalle"));
			$formulario->setRealizacionProc($request->get("inputRealizacion"));
			$formulario->setGraficoProc($request->get("inputGrafico"));
			$formulario->setDuracionProc($request->get("inputDuracion"));
			$formulario->setBeneficiosProc($request->get("inputBeneficios"));
			$formulario->setRiesgosLeves($request->get("inputRieLeves"));
			$formulario->setRiesgosGraves($request->get("inputRieGraves"));
			$formulario->setOtrosRiesgos($request->get("inputOtroRiesgo"));
			$formulario->setAlternativasProc($request->get("inputAlternativas"));
			$formulario->setDespuesProc($request->get("inputDespues"));
			$formulario->setConsecNoproc($request->get("inputNoProc"));

			if($request->get("chkAcepta"))
				$formulario->setAcepta(true);
			else
				$formulario->setAcepta(false);
			
			$formulario->setAtencion($request->get("rdbAtencion"));
			$formulario->setServicio($request->get("inputServicio"));
			$formulario->setEstadoForm(true);
			$formulario->setRpNombreA($request->get("inputRpNomA"));
			$formulario->setRpCedulaA($request->get("inputRpCedA"));
			$formulario->setRpParentescoA($request->get("inputRpParenA"));
			$formulario->setRpNombreN($request->get("inputRpNomN"));
			$formulario->setRpCedulaN($request->get("inputRpCedN"));
			$formulario->setRpParentescoN($request->get("inputRpParenN"));
			$formulario->setNombreTestigo($request->get("inputNomTestigo"));
			$formulario->setCedulaTestigo($request->get("inputCedTestigo"));

			$em->persist($formulario);
		}

		$em->flush();

		return $this->redirectToRoute("documConsentimiento");
	}

    /**
     * @Route("/form053/store/", name="storeForm053")
     */
    public function storeForm053Action(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        if ($request->get('inputForm') != '0') {
            /* $formulario = $em
                ->getRepository('AgendaBundle:Formulario024')
                ->find($request->get('inputForm'));
            $formulario->setRevocatoria(true);
            $formulario->setFechaR(date('Y-m-d'));
            $formulario->setHoraR(date('H:i:s'));
            $formulario->setRpNombreR($request->get('inputRpNomR'));
            $formulario->setRpCedulaR($request->get('inputRpCedR'));
            $formulario->setRpParentescoR($request->get('inputRpParenR')); */
        } else {
            
            $paciente = $em
                ->getRepository('AdministradorBundle:Paciente')
                ->find($request->get('inputPaciente'));
            $medico = $em
                ->getRepository('AdministradorBundle:Medico')
                ->find($request->get('inputMedico'));

            /* $cieDiez = $em
                ->getRepository('AgendaBundle:CieDiez')
                ->find($request->get('cmbCieDiez')); */

            $formulario = new Formulario053();
            $formulario->setIdPaciente($paciente);
            $formulario->setIdMedico($medico);
            //$formulario->setIdCieDiez($cieDiez);
            $formulario->setapellidoPaterno($request->get('inputApellidoPaterno'));
            $formulario->setapellidoMaterno($request->get('inputApellidoMaterno'));
            $formulario->setnombres($request->get('inputNombrePaciente'));
            $formulario->setdiaPaciente($request->get('inputDiaPaciente'));
            $formulario->setmesPaciente($request->get('inputMesPaciente'));
            $formulario->setanioPaciente($request->get('inputAnioPaciente'));
            $formulario->setedadPaciente($request->get('inputEdadPaciente'));
            $formulario->setgeneroPaciente($request->get('inputSexoPaciente'));
            $formulario->setnacionalidadPaciente($request->get('inputNacionalidadPaciente'));
            $formulario->setpaisPaciente($request->get('inputPaisPaciente'));
            $formulario->setcedulaPaciente($request->get('inputDNIPaciente'));
            $formulario->setprovinciaPaciente($request->get('inputProvinciaPaciente'));
            $formulario->setcantonPaciente($request->get('inputCantonPaciente'));
            $formulario->setparroquiaPaciente($request->get('inputParroquiaPaciente'));
            $formulario->setdireccionPaciente($request->get('inputDireccionPaciente'));
            $formulario->settelefonoPaciente($request->get('inputTelefonoPaciente'));

            if($request->get('radio') == 'Referencia' || $request->get('radio') == 'Derivación'){
                $formulario->settipoDocumento($request->get('radio'));
                $formulario->setentidadInstitucion($request->get('inputEntidadSistema'));
                $formulario->sethistoriaClinica($request->get('inputHistoriaClinica'));
                $formulario->setestablecimientoInstitucion($request->get('inputEstablecimiento'));
                $formulario->settipoInstitucion($request->get('inputTipoInstitucion'));
                $formulario->setdistritoInstitucion($request->get('inputAreaInstitucion'));
                $formulario->setentidadRemitente($request->get('inputEntidadRemitente'));
                $formulario->setestablecimientoRemitente($request->get('inputEstablecimientoRemitente'));
                $formulario->setservicioRemitente($request->get('inputServicioRemitente'));
                $formulario->setespecialidadRemitente($request->get('inputEspecialidadRemitente'));
                $formulario->setdiaRemitente($request->get('inputDiaEmite'));
                $formulario->setmesRemitente($request->get('inputMesEmite'));
                $formulario->setanioRemitente($request->get('inputAnioEmite'));
                if($request->get('check') == 5){
                    $formulario->setmotivoRef($request->get('inputOtroMotivoReferencia'));
                }else{
                    $formulario->setmotivoRef($request->get('check'));
                }
                $formulario->setresumenCuadro($request->get('inputResumenClinico'));
                $formulario->sethallazgosRelevantes($request->get('inputHallazgosRelevantes'));
                $formulario->setdiagnostico($request->get('inputDiagnostico'));
                $formulario->setcie10Form053($request->get('inputCie10'));
                $formulario->setpre($request->get('inputPre'));
                $formulario->setdef($request->get('inputDef'));
                $formulario->setnombreMedico($request->get('inputNombreProfesional'));
                $formulario->setcodigoMSPMedico($request->get('inputMsp'));
            }else if($request->get('radio') == 'Contrareferencia' || $request->get('radio') == 'Referencia inversa'){
                $formulario->settipoDocumento($request->get('radio'));
                $formulario->setentidadInstitucion($request->get('inputEntidadSistema2'));
                $formulario->sethistoriaClinica($request->get('inputHistoriaClinica2'));
                $formulario->setestablecimientoInstitucion($request->get('inputEstablecimiento2'));
                $formulario->settipoInstitucion($request->get('inputTipoInstitucion2'));
                $formulario->setservicioInstitucion($request->get('inputServicioInstitucion2'));
                $formulario->setespecialidadRemitente($request->get('inputEspecialidadInstitucion2'));
                $formulario->setentidadRemitente($request->get('inputEntidadRemitente2'));
                $formulario->setestablecimientoRemitente($request->get('inputEstablecimientoRemitente2'));
                $formulario->settipoRemitente($request->get('inputTipoRemitente2'));
                $formulario->setdistritoRemitente($request->get('inputDistritoRemitente2'));
                $formulario->setdiaRemitente($request->get('inputDiaEmite2'));
                $formulario->setmesRemitente($request->get('inputMesEmite2'));
                $formulario->setanioRemitente($request->get('inputAnioEmite2'));
                $formulario->setresumenCuadro($request->get('inputResumenClinico2'));
                $formulario->sethallazgosRelevantes($request->get('inputHallazgosRelevantes2'));
                $formulario->settratamientoProcedimiento($request->get('inputTratamientos2'));
                $formulario->setdiagnostico($request->get('inputDiagnostico2'));
                $formulario->setcie10Form053($request->get('inputCie102'));
                $formulario->setpre($request->get('inputPre2'));
                $formulario->setdef($request->get('inputDef2'));
                $formulario->settratamientoRecomendado($request->get('inputTratamientos2'));
                $formulario->setnombreMedico($request->get('inputNombreProfesional2'));
                $formulario->setcodigoMSPMedico($request->get('inputMsp2'));
                $formulario->setreferenciaJustificada($request->get('inputReferencia2'));
            }
            $em->persist($formulario);
        }

        $em->flush();

        return $this->redirectToRoute('documReferencia');
    }
    
    /**
     * @Route("/nutricion/store/", name="storeInformeNutricion")
     */
    public function storeNutricionAction(Request $request){
        $em = $this->getDoctrine()->getManager();

        if($request->get("inputForm") != "0"){

        }else{
            $paciente = $em->getRepository("AdministradorBundle:Paciente")->find($request->get("inputPaciente"));
			$medico = $em->getRepository("AdministradorBundle:Medico")->find($request->get("inputMedico"));
            $formulario = new NutricionFormulario();
            /* $formulario->setIdPaciente($paciente);
            $formulario->setIdMedico($medico); */
            /* $formulario->setfechaEmision('15/10/2021');
            $formulario->setnombrePaciente('al');
            $formulario->setedadPaciente('al');
            $formulario->setcedulaPaciente('al');
            $formulario->setcelularPaciente('al');
            $formulario->setidentificacionPaciente('al');
            $formulario->setappClinicos('al');
            $formulario->setappAlergias('al');
            $formulario->setappQuirurgicos('al');
            $formulario->setappIppeso('al');
            $formulario->setappGastrointestinales('al');
            $formulario->sethaafApetito('al');
            $formulario->sethaafConsumo('al');
            $formulario->sethaafIntolerancia('al');
            $formulario->sethaafAgua('al');
            $formulario->sethaafSal('al');
            $formulario->sethaafAzucar('al');
            $formulario->sethaafAversiones('al');
            $formulario->sethaafAlcohol('al');
            $formulario->sethaafTabaco('al');
            $formulario->sethaafDrogas('al');
            $formulario->sethaafCafe('al');
            $formulario->sethaafActividad('al');
            $formulario->setdaPeso('al');
            $formulario->setdaTalla('al');
            $formulario->setdaANutricionales('al');
            $formulario->setdaPesoAcumulado('al');
            $formulario->setdaImc('al');
            $formulario->setdaMusculo('al');
            $formulario->setdaGUAnio('al');
            $formulario->setihaDesayuno('al');
            $formulario->setihaMm('al');
            $formulario->setihaAlmuerzo('al');
            $formulario->setihaMt('al');
            $formulario->setihaCena('al');
            $formulario->setihaDiagnosticoN('al');
            $formulario->setihaRecomendacionN('al');
            $formulario->setihaPlanN('al');
            $formulario->setnombreMedico('al');
            $formulario->setespecialidadMedico('al');
            $formulario->settelefonoMedico('al'); */

            $sqlNativo = "insert into nutricion_formulario 
            (id_paciente, id_medico, fecha_emision, nombre_paciente, edad_paciente, cedula_paciente, celular_paciente, identificacion_paciente, app_clinicos,
            app_alergias, app_quirurgicos, app_ippeso, app_gastrointestinales, haaf_apetito, haaf_consumo, haaf_intolerancia, haaf_agua, haaf_sal, haaf_azucar,
            haaf_aversiones, haaf_alcohol, haaf_tabaco, haaf_drogas, haaf_cafe, haaf_actividad, da_peso, da_talla, da_a_nutricionales, da_peso_acumulado,
            da_imc, da_musculo, da_g_u_anio, iha_desayuno, iha_mm, iha_almuerzo, iha_mt, iha_cena, iha_diagnostico_n, iha_recomendacion_n, iha_plan_n,
            nombre_medico, especialidad_medico, telefono_medico) 
            values 
            (".$request->get("inputPaciente").", ".$request->get("inputMedico").", '".$request->get("inputFechaEmision")."',
            '".$request->get("inputNombrePaciente")."', '".$request->get("inputEdadPaciente")."', '".$request->get("inputCedulaPaciente")."',
            '".$request->get("inputCelularPaciente")."', '".$request->get("inputIdentificacionPaciente")."', '".$request->get("inputAppClinicos")."',
            '".$request->get("inputAppAlergias")."', '".$request->get("inputAppQuirurgico")."', '".$request->get("inputAppPerdidaPeso")."',
            '".$request->get("inputSintomasGastro")."', '".$request->get("inputHaafApetito")."', '".$request->get("inputHaafCHAlimentos")."',
            '".$request->get("inputHaafIntoAlimentaria")."', '".$request->get("inputHaafConsumoAgua")."', '".$request->get("inputHaafConsumoSal")."',
            '".$request->get("inputHaafConsumoAzucar")."', '".$request->get("inputHaafAversiones")."', '".$request->get("inputHaafAlcohol")."',
            '".$request->get("inputHaafTabaco")."', '".$request->get("inputHaafDrogas")."', '".$request->get("inputHaafCafe")."',
            '".$request->get("inputHaafActividadFisica")."', '".$request->get("inputDaPeso")."', '".$request->get("inputDaTalla")."',
            '".$request->get("inputDaNutricionales")."', '".$request->get("inputDaPesoAjustado")."', '".$request->get("inputDaImc")."',
            '".$request->get("inputDaMusculo")."', '".$request->get("inputDaGananciaUltimoAnio")."', '".$request->get("inputIhaDesayuno")."',
            '".$request->get("inputIhaMm")."', '".$request->get("inputIhaAlmuerzo")."', '".$request->get("inputIhaMt")."',
            '".$request->get("inputIhaCena")."', '".$request->get("inputDiagnosticoNutri")."', '".$request->get("inputRecomenNutricionales")."',
            '".$request->get("inputPlanNutricional")."', '".$request->get("inputNombreMedico")."', '".$request->get("inputEspecialidadMedico")."',
            '".$request->get("inputTelefonoMedico")."');";
            $stmtUpdate = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtUpdate->execute();
            $resultUpdate = $stmtUpdate->fetchAll();
            return $this->redirectToRoute('documNutricion');
        }
    }

	/**
	 * @Route("/consentimiento/subir/imagen/", name="consentimientoImagen")
	 */
	public function consentimientoImagenAction(Request $request)
	{
		$idMedico = $request->get("inputMedico");
		$idPaciente = $request->get("inputPaciente");

		$imagen = $_FILES["flGrafico"];
		$array = explode(".", $imagen["name"]);
		$extension = end($array);

		$nombreImage = md5($idMedico.$idPaciente.date("YmdHis")).".".$extension;
		$rutaImagen = "6973e3e05f3cea01fbdedd4/consentimiento/".$nombreImage;
		$subir = move_uploaded_file($imagen["tmp_name"], $rutaImagen);

		if($subir)
		{
			chmod($rutaImagen, 0777);
			return new Response($rutaImagen);
		}
		else
			return new Response("nok");
	}

	/**
	 * @Route("/consentimiento/form024/", name="form024Med")
	 */
	public function form024MedAction(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$pag = $request->get("cantidad") * $request->get("pagina");

		$query = "select f from AgendaBundle:Formulario024 f where f.idMedico = ".$request->get("idMedico")." order by f.id desc";
		$queryPag = "select count(f.id) from AgendaBundle:Formulario024 f where f.idMedico = ".$request->get("idMedico");
		$formularios = $em->createQuery($query)->setMaxResults($request->get("cantidad"))->setFirstResult($pag)->getResult();
		$total = $em->createQuery($queryPag)->getSingleScalarResult();

		$html = '<table class="table table-bordered table-striped">
			<thead>
				<tr>
					<th class="text-center align-middle">Fecha</th>
					<th class="text-center align-middle">Paciente</th>
					<th class="text-center align-middle">Diagnostico</th>
					<th class="text-center align-middle">Servicio</th>
					<th class="text-center align-middle">Estado</th>
					<th class="text-center align-middle"></th>
				</tr>
			</thead><tbody>';
			if ($formularios)
			{
				foreach($formularios as $formulario)
				{
					$html .= '<tr>
						<td class="align-middle">'.$formulario->getFecha().'</td>
						<td class="align-middle">'.$formulario->getIdPaciente()->getIdUsuario()->getApellido().' '.$formulario->getIdPaciente()->getIdUsuario()->getNombre().'</td>
						<td class="align-middle">'.$formulario->getIdCieDiez()->getNombre().'</td>
						<td class="align-middle">'.$formulario->getServicio().'</td>
						<td class="align-middle">'.(($formulario->getAcepta()) ? (($formulario->getRevocatoria()) ? 'Revocado' : 'Aceptado') : 'Negado').'</td>
						<td class="align-middle"><a href="'.$request->get("url").'/'.base64_encode($request->get("idMedico")).'/'.base64_encode($formulario->getId()).'" class="btn btn-info">'.(($formulario->getAcepta()) ? (($formulario->getRevocatoria()) ? 'Ver' : 'Ver/Revocar') : 'Ver').'</a></th>
					</tr>';
				}
			}
		$html .= '</tbody></table>';

        $paginas = ceil($total / $request->get("cantidad"));
        $start = (($request->get("pagina") - 5) > 0 ) ? $request->get("pagina") - 5 : 0;
        $end = (($request->get("pagina") + 5) < $paginas) ? $request->get("pagina") + 5 : ($paginas-1);

        $html .= '<div class="d100 paginacion"><nav aria-label="">
        <ul class="pagination">
            <li class="page-item '.(($request->get("pagina") == 0) ? "disabled" : "").'">
                <a id="'.($request->get("pagina") - 1).'" class="page-link" href="#" aria-label="Previous">
                    <span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
                </a>
            </li>';
        if($start > 1)
        {
            $html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
        }

        for($i = $start; $i <= $end; $i++)
        {
            $html .= '<li class="page-item '.(($request->get("pagina") == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
        }

        if($end < ($paginas-1))
        {
            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
            $html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
        }
        $html .= '<li class="page-item '.(($request->get("pagina") == ($paginas - 1) ) ? "disabled" : "").'">
            <a id="'.($request->get("pagina") + 1).'" class="page-link" href="#" aria-label="Next">
                <span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
            </a>
        </li>
        </ul></nav></div>';

		return new Response($html);
	}

	 /**
     * @Route("/referencia/form053/", name="form053Med")
     */
    public function form053MedAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $pag = $request->get('cantidad') * $request->get('pagina');

        $query =
            'select f from AgendaBundle:Formulario053 f where f.idMedico = ' .
            $request->get('idMedico') .
            ' order by f.id desc';
        $queryPag =
            'select count(f.id) from AgendaBundle:Formulario053 f where f.idMedico = ' .
            $request->get('idMedico');
        $formularios = $em
            ->createQuery($query)
            ->setMaxResults($request->get('cantidad'))
            ->setFirstResult($pag)
            ->getResult();
        $total = $em->createQuery($queryPag)->getSingleScalarResult();

        $html = '<table class="table table-bordered table-striped">
			<thead>
				<tr>
                    <th class="text-center align-middle">Paciente</th>
                    <th class="text-center align-middle">Tipo</th>
                    <th class="text-center align-middle"></th>
				</tr>
			</thead><tbody>';
        if ($formularios) {
            foreach ($formularios as $formulario) {
                $html .=
                    '<tr>
						<td class="align-middle">' .
                        $formulario->getapellidoPaterno().' '.$formulario->getapellidoMaterno().' '.$formulario->getnombres().
                        '</td>
                        <td class="align-middle">' .
                            $formulario->gettipoDocumento().
                        '</td>
                        <td class="align-middle"><a href="' .
                    $request->get('url') .
                    '/' .
                    base64_encode($request->get('idMedico')) .
                    '/' .
                    base64_encode($formulario->getId()) .
                    '" class="btn btn-info">' .
                    'Ver' .
                    '</a></th>
					</tr>';
            }
        }
        $html .= '</tbody></table>';

        $paginas = ceil($total / $request->get('cantidad'));
        $start =
            $request->get('pagina') - 5 > 0 ? $request->get('pagina') - 5 : 0;
        $end =
            $request->get('pagina') + 5 < $paginas
                ? $request->get('pagina') + 5
                : $paginas - 1;

        $html .=
            '<div class="d100 paginacion"><nav aria-label="">
        <ul class="pagination">
            <li class="page-item ' .
            ($request->get('pagina') == 0 ? 'disabled' : '') .
            '">
                <a id="' .
            ($request->get('pagina') - 1) .
            '" class="page-link" href="#" aria-label="Previous">
                    <span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
                </a>
            </li>';
        if ($start > 1) {
            $html .=
                '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
            $html .=
                '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
        }

        for ($i = $start; $i <= $end; $i++) {
            $html .=
                '<li class="page-item ' .
                ($request->get('pagina') == $i ? 'active' : '') .
                '"><a id="' .
                $i .
                '" class="page-link text-center" href="#">' .
                ($i + 1) .
                '</a></li>';
        }

        if ($end < $paginas - 1) {
            $html .=
                '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
            $html .=
                '<li class="page-item"><a id="' .
                ($paginas - 1) .
                '" class="page-link" href="#">' .
                $paginas .
                '</a></li>';
        }
        $html .=
            '<li class="page-item ' .
            ($request->get('pagina') == $paginas - 1 ? 'disabled' : '') .
            '">
            <a id="' .
            ($request->get('pagina') + 1) .
            '" class="page-link" href="#" aria-label="Next">
                <span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
            </a>
        </li>
        </ul></nav></div>';

        return new Response($html);
    }
    
    /**
     * @Route("/informe/nutricion/", name="informeNutricionMed")
     */
    public function formNutricionAction(Request $request){
        $em = $this->getDoctrine()->getManager();
        $pag = $request->get('cantidad') * $request->get('pagina');

        $query =
            'select f from AgendaBundle:NutricionFormulario f where f.idMedico = ' .
            $request->get('idMedico') .
            ' order by f.id desc';

        $queryPag =
            'select count(f.id) from AgendaBundle:NutricionFormulario f where f.idMedico = ' .
            $request->get('idMedico');

        $formularios = $em
            ->createQuery($query)
            ->setMaxResults($request->get('cantidad'))
            ->setFirstResult($pag)
            ->getResult();
        $total = $em->createQuery($queryPag)->getSingleScalarResult();

        $html = '<table class="table table-bordered table-striped">
			<thead>
				<tr>
                    <th class="text-center align-middle">Fecha</th>
                    <th class="text-center align-middle">Paciente</th>
                    <th class="text-center align-middle"></th>
				</tr>
			</thead><tbody>';
        if ($formularios) {
            foreach ($formularios as $formulario) {
                $html .=
                    '<tr>
						<td class="align-middle">' .
                        $formulario->getfechaEmision().
                        '</td>
                        <td class="align-middle">' .
                            $formulario->getnombrePaciente().
                        '</td>
                        <td class="align-middle"><a href="' .
                    $request->get('url') .
                    '/' .
                    base64_encode($request->get('idMedico')) .
                    '/' .
                    base64_encode($formulario->getId()) .
                    '" class="btn btn-info">' .
                    'Ver' .
                    '</a></th>
					</tr>';
            }
        }
        $html .= '</tbody></table>';

        $paginas = ceil($total / $request->get('cantidad'));
        $start =
            $request->get('pagina') - 5 > 0 ? $request->get('pagina') - 5 : 0;
        $end =
            $request->get('pagina') + 5 < $paginas
                ? $request->get('pagina') + 5
                : $paginas - 1;

        $html .=
            '<div class="d100 paginacion"><nav aria-label="">
        <ul class="pagination">
            <li class="page-item ' .
            ($request->get('pagina') == 0 ? 'disabled' : '') .
            '">
                <a id="' .
            ($request->get('pagina') - 1) .
            '" class="page-link" href="#" aria-label="Previous">
                    <span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
                </a>
            </li>';
        if ($start > 1) {
            $html .=
                '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
            $html .=
                '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
        }

        for ($i = $start; $i <= $end; $i++) {
            $html .=
                '<li class="page-item ' .
                ($request->get('pagina') == $i ? 'active' : '') .
                '"><a id="' .
                $i .
                '" class="page-link text-center" href="#">' .
                ($i + 1) .
                '</a></li>';
        }

        if ($end < $paginas - 1) {
            $html .=
                '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
            $html .=
                '<li class="page-item"><a id="' .
                ($paginas - 1) .
                '" class="page-link" href="#">' .
                $paginas .
                '</a></li>';
        }
        $html .=
            '<li class="page-item ' .
            ($request->get('pagina') == $paginas - 1 ? 'disabled' : '') .
            '">
            <a id="' .
            ($request->get('pagina') + 1) .
            '" class="page-link" href="#" aria-label="Next">
                <span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
            </a>
        </li>
        </ul></nav></div>';

        return new Response($html);

    }
    
    //************************PSICOLOGIA******************************
    /**
     * @Route("/documentos/psicologia/", name="documPsicologia")
     */
    public function psicologiaAction(Request $request){
        if (
            !$request->getSession()->has('rol') ||
            !$request->getSession()->has('usuario') ||
            $request->getSession()->get('rol') == 1
        ) {
            return $this->redirectToRoute('logout');
        } else {
            $em = $this->getDoctrine()->getManager();
            $usuario = $em
                ->getRepository('LoginBundle:Usuario')
                ->find($request->getSession()->get('usuario'));
            $noticias = '';
            $formularios = null;
            if ($request->getSession()->get('rol') == 2) {
                $medicos = $em
                    ->getRepository('AdministradorBundle:Medico')
                    ->findOneBy(['idUsuario' => $usuario->getId()]);
                $queryNot =
                    'select n from AdministradorBundle:Noticas n order by n.id desc';
                $noticias = $em
                    ->createQuery($queryNot)
                    ->setMaxResults(1)
                    ->getResult();
            } else {
                $asistente = $em
                    ->getRepository('AdministradorBundle::Asistente')
                    ->findOneBy(['idUsuario' => $usuario->getId()]);
                $medicos = $em
                    ->getRepository('AdministradorBundle:AsistenteMedico')
                    ->findBy(['idAsistente' => $asistente->getId()]);
            }

            return $this->render('@Agenda/Documentos/psicologia.html.twig', [
                'usuario' => $usuario,
                'noticias' => $noticias,
                'medicos' => $medicos,
            ]);
        }
    }

    /**
     * @Route("/informe/psicologia/", name="informePsicologiaMed")
     */
    public function formPsicologiaAction(Request $request){
        $em = $this->getDoctrine()->getManager();
        $pag = $request->get('cantidad') * $request->get('pagina');

        $query =
            'select f from AgendaBundle:FormularioPsicologia f where f.idMedico = ' .
            $request->get('idMedico') .
            ' order by f.id desc';

        $queryPag =
            'select count(f.id) from AgendaBundle:FormularioPsicologia f where f.idMedico = ' .
            $request->get('idMedico');

        $formularios = $em
            ->createQuery($query)
            ->setMaxResults($request->get('cantidad'))
            ->setFirstResult($pag)
            ->getResult();
        $total = $em->createQuery($queryPag)->getSingleScalarResult();

        $html = '<table class="table table-bordered table-striped">
			<thead>
				<tr>
                    <th class="text-center align-middle">Fecha</th>
                    <th class="text-center align-middle">Paciente</th>
                    <th class="text-center align-middle"></th>
				</tr>
			</thead><tbody>';
        if ($formularios) {
            foreach ($formularios as $formulario) {
                $html .=
                    '<tr>
						<td class="align-middle">' .
                        $formulario->getfechaEmision().
                        '</td>
                        <td class="align-middle">' .
                            $formulario->getnombrePaciente().
                        '</td>
                        <td class="align-middle"><a href="' .
                    $request->get('url') .
                    '/' .
                    base64_encode($request->get('idMedico')) .
                    '/' .
                    base64_encode($formulario->getId()) .
                    '" class="btn btn-info">' .
                    'Ver' .
                    '</a></th>
					</tr>';
            }
        }
        $html .= '</tbody></table>';

        $paginas = ceil($total / $request->get('cantidad'));
        $start =
            $request->get('pagina') - 5 > 0 ? $request->get('pagina') - 5 : 0;
        $end =
            $request->get('pagina') + 5 < $paginas
                ? $request->get('pagina') + 5
                : $paginas - 1;

        $html .=
            '<div class="d100 paginacion"><nav aria-label="">
        <ul class="pagination">
            <li class="page-item ' .
            ($request->get('pagina') == 0 ? 'disabled' : '') .
            '">
                <a id="' .
            ($request->get('pagina') - 1) .
            '" class="page-link" href="#" aria-label="Previous">
                    <span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
                </a>
            </li>';
        if ($start > 1) {
            $html .=
                '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
            $html .=
                '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
        }

        for ($i = $start; $i <= $end; $i++) {
            $html .=
                '<li class="page-item ' .
                ($request->get('pagina') == $i ? 'active' : '') .
                '"><a id="' .
                $i .
                '" class="page-link text-center" href="#">' .
                ($i + 1) .
                '</a></li>';
        }

        if ($end < $paginas - 1) {
            $html .=
                '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
            $html .=
                '<li class="page-item"><a id="' .
                ($paginas - 1) .
                '" class="page-link" href="#">' .
                $paginas .
                '</a></li>';
        }
        $html .=
            '<li class="page-item ' .
            ($request->get('pagina') == $paginas - 1 ? 'disabled' : '') .
            '">
            <a id="' .
            ($request->get('pagina') + 1) .
            '" class="page-link" href="#" aria-label="Next">
                <span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
            </a>
        </li>
        </ul></nav></div>';

        return new Response($html);
    }

    /**
     * @Route("documentos/informe/psicologia/{idMedico}/{idForm}", name="informePsicologia")
     */
    public function informePsicologiaAction(
        Request $request,
        $idMedico = 0,
        $idForm = 0)
        {
            if (
                !$request->getSession()->has('rol') ||
                !$request->getSession()->has('usuario') ||
                $request->getSession()->get('rol') == 1)
                {
                return $this->redirectToRoute('logout');
            } else {
                $em = $this->getDoctrine()->getManager();
                $usuario = $em
                    ->getRepository('LoginBundle:Usuario')
                    ->find($request->getSession()->get('usuario'));
                $noticias = '';
                $fecha = date('Y-m-d');
                $hora = date('H:i:s');
                $medico = $em
                    ->getRepository('AdministradorBundle:Medico')
                    ->find(base64_decode($idMedico));
                if ($request->getSession()->get('rol') == 2) {
                    $queryNot =
                        'select n from AdministradorBundle:Noticas n order by n.id desc';
                    $noticias = $em
                        ->createQuery($queryNot)
                        ->setMaxResults(1)
                        ->getResult();
                }

                if (base64_decode($idForm) != 0) {

                    $formulario = $em
                        ->getRepository('AgendaBundle:FormularioPsicologia')
                        ->find(base64_decode($idForm));
                    $edad = 'No definida';
                    return $this->render('@Agenda/Documentos/infoPsicologia.html.twig', [
                        'usuario' => $usuario,
                        'noticias' => $noticias,
                        'medico' => $medico,
                        'formulario' => $formulario,
                    ]);
                } else {
                    return $this->render('@Agenda/Documentos/infoPsicologia.html.twig', [
                        'usuario' => $usuario,
                        'noticias' => $noticias,
                        'medico' => $medico,
                    ]);
                }
            }
    }

    /**
     * @Route("/psicologia/store/", name="storeInformePsicologia")
     */
    public function storePsicologiaAction(Request $request){
        $em = $this->getDoctrine()->getManager();

        if($request->get("inputForm") != "0"){

        }else{
            $paciente = $em->getRepository("AdministradorBundle:Paciente")->find($request->get("inputPaciente"));
            $medico = $em->getRepository("AdministradorBundle:Medico")->find($request->get("inputMedico"));
            $sqlNativo = "insert into formulario_psicologia
            (id_paciente, id_medico, fecha_emision,  nombre_paciente, edad_paciente, cedula_paciente, celular_paciente, identificacion_paciente, app_clinicos,
            app_alergias, app_quirurgicos, app_psiquiatricos, haaf_alcohol, haaf_tabaco, haaf_drogas, apf_clinicos, apf_psiquiatricos, psicobiografia,
            bio_ninez, bio_adolescencia, bio_adultez, bio_etapa_escolar, bio_etapa_laboral, bio_etapa_sentimental, bio_rasgos_personalidad, bio_motivo_consulta,
            bio_enfermedad_actual, bio_examen_psicopatologico, bio_test_aplicado, bio_imprension_diagnostica, bio_analisis, bio_plan, nombre_medico,
            especialidad_medico, telefono_medico)
            values
            (".$request->get("inputPaciente").", ".$request->get("inputMedico").", '".$request->get("inputFechaEmision")."',
            '".$request->get("inputNombrePaciente")."', '".$request->get("inputEdadPaciente")."', '".$request->get("inputCedulaPaciente")."',
            '".$request->get("inputCelularPaciente")."', '".$request->get("inputIdentificacionPaciente")."', '".$request->get("inputAppClinicos")."',
            '".$request->get("inputAppAlergias")."', '".$request->get("inputAppQuirurgico")."', '".$request->get("inputAppPsiquiatrico")."',
            '".$request->get("inputHaafAlcohol")."', '".$request->get("inputHaafTabaco")."', '".$request->get("inputHaafDrogas")."',
            '".$request->get("inputApfClinicos")."', '".$request->get("inputApfPsiquiatricos")."', '".$request->get("inputPsicobiografia")."',
            '".$request->get("inputBioNinez")."', '".$request->get("inputBioAdolescencia")."', '".$request->get("inputBioAdultez")."',
            '".$request->get("inputBioEscolar")."', '".$request->get("inputBioLaboral")."', '".$request->get("inputBioSentimental")."',
            '".$request->get("inputBioPersonalidad")."', '".$request->get("inputBioMotivoConsulta")."', '".$request->get("inputBioEnfermedadActual")."',
            '".$request->get("inputBioExPsicopatologico")."', '".$request->get("inputBioTestAplicados")."', '".$request->get("inputBioImpDiagnostica")."',
            '".$request->get("inputBioAnalisis")."', '".$request->get("inputBioPlan")."', '".$request->get("inputNombreMedico")."',
            '".$request->get("inputEspecialidadMedico")."', '".$request->get("inputCedulaMedico")."'
            )";
            $stmtUpdate = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtUpdate->execute();
            $resultUpdate = $stmtUpdate->fetchAll();
            return $this->redirectToRoute('documPsicologia');
        }
    }

    /**
     * @Route("/formPsicologia/pdf/{id}", name="formPsicologia_1Pdf")
     */
    public function formPsicologia_1PdfAction(Request $request, $id = 0){
        $em =$this->getDoctrine()->getManager();
        $formulario = $em
            /* ->getRepository('AgendaBundle:NutricionFormulario') */
            ->getRepository('AgendaBundle:FormularioPsicologia')
            ->find($id);

            $html = $this->renderView('@Agenda/PDF/psicologia.html.twig', [
                'formulario' => $formulario
            ]);
            $nombreDocumento =
            'FormPsicologia' .
            $formulario
                ->getIdPaciente()
                ->getIdMedico()
                ->getId() .
            date('YmdHis') .
            '.pdf';
        return new PdfResponse(
            $this->get('knp_snappy.pdf')->getOutputFromHtml($html),
            $nombreDocumento
        );
    }

	/**
	 * @Route("/certificado/medico/pdf/{codigo}/{medicoId}/{pacienteId}/{especialidadId}/{causa}/{desde}/{hasta}/{fecha}", name="certificadoPdf")
	 */
	public function certificadoPdfAction(Request $request, $codigo="", $medicoId=0, $pacienteId=0, $especialidadId=0, $causa="", $desde="", $hasta="", $fecha="")
	{
		$em = $this->getDoctrine()->getManager();
		$medico = $em->getRepository("AdministradorBundle:Medico")->find($medicoId);
		$paciente = $em->getRepository("AdministradorBundle:Paciente")->find($pacienteId);
		$especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find($especialidadId);
		$documento = $em->getRepository("AgendaBundle:Documentos")->findOneBy(array("idMedico" => $medico->getId(), "codigo" => $codigo));

		$nombreComercial = $medico->getIdUsuario()->getApellido()." ".$medico->getIdUsuario()->getNombre();
		if($medico->getNombreComercial() != null && $medico->getNombreComercial() != "")
			$nombreComercial = $medico->getNombreComercial();

		$msg1 = str_replace("PROMDOCTOR", $medico->getIdUsuario()->getApellido()." ".$medico->getIdUsuario()->getNombre(), $documento->getTexto());
		$msg2 = str_replace("PROMESPECIALIDAD", $especialidad->getNombre(), $msg1);
		$msg3 = str_replace("PROMCONSULTORIO", $nombreComercial, $msg2);
		$msg4 = str_replace("PROMPACIENTE", $paciente->getIdUsuario()->getApellido()." ".$paciente->getIdUsuario()->getNombre(), $msg3);
		$msg5 = str_replace("PROMCEDPACIENTE", $paciente->getIdUsuario()->getCedula(), $msg4);
		$msg6 = str_replace("PROMCAUSA", base64_decode($causa), $msg5);
		$msg7 = str_replace("PROMDESDE", base64_decode($desde), $msg6);
		$msg8 = str_replace("PROMHASTA", base64_decode($hasta), $msg7);
		$msg9 = str_replace("PROMFECHA", base64_decode($fecha), $msg8);

		$texto = $msg9;

		$html = $this->renderView("@Agenda/PDF/certificado.html.twig", array(
			"documento" => $documento,
			"texto" => $texto
		));

		$nombreDocumento = "Certificado".$paciente->getIdUsuario()->getCedula().date("YmdHis").".pdf";
		return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html), $nombreDocumento);
	}

	/**
     * @Route("/certificado/ocupacional/pdf/{codigo}/{medicoId}/{pacienteId}/{especialidadId}/{diagnostico}/{actividad}/{edad}/{nacionalidad}/{fecha}", name="certificadoOcupacionalPdf")
     */
    public function certificadoOcupacionalPdfAction(
        Request $request,
        $codigo = '',
        $medicoId = 0,
        $pacienteId = 0,
        $especialidadId = 0,
        $diagnostico = '',
        $actividad = '',
        $edad = 0,
        $nacionalidad = '',
        $fecha = ''
    ) {
        $em = $this->getDoctrine()->getManager();
        $medico = $em
            ->getRepository('AdministradorBundle:Medico')
            ->find($medicoId);
        $paciente = $em
            ->getRepository('AdministradorBundle:Paciente')
            ->find($pacienteId);
        $especialidad = $em
            ->getRepository('AdministradorBundle:Especialidades')
            ->find($especialidadId);
        $documento = $em
            ->getRepository('AgendaBundle:Documentos')
            ->findOneBy(['idMedico' => $medico->getId(), 'codigo' => $codigo]);

        $nombreComercial =
            $medico->getIdUsuario()->getApellido() .
            ' ' .
            $medico->getIdUsuario()->getNombre();
        if (
            $medico->getNombreComercial() != null &&
            $medico->getNombreComercial() != ''
        ) {
            $nombreComercial = $medico->getNombreComercial();
        }

        $msg1 = str_replace(
            'PROMDOCTOR',
            $medico->getIdUsuario()->getApellido() .
                ' ' .
                $medico->getIdUsuario()->getNombre(),
            $documento->getTexto()
        );
        $msg2 = str_replace(
            'PROMESPECIALIDAD',
            $especialidad->getNombre(),
            $msg1
        );
        $msg3 = str_replace('PROMCONSULTORIO', $nombreComercial, $msg2);
        $msg4 = str_replace(
            'PROMPACIENTE',
            $paciente->getIdUsuario()->getApellido() .
                ' ' .
                $paciente->getIdUsuario()->getNombre(),
            $msg3
        );
        $msg5 = str_replace(
            'PROMCEDPACIENTE',
            $paciente->getIdUsuario()->getCedula(),
            $msg4
        );
        $msg6 = str_replace('PROMEDAD', base64_decode($edad), $msg5);
        $msg7 = str_replace('PROMNACIONALIDAD', base64_decode($nacionalidad), $msg6);
        $msg8 = str_replace('PROMDIAGNOSTICO', base64_decode($diagnostico), $msg7);
        $msg9 = str_replace('PROMACTIVIDADES', base64_decode($actividad), $msg8);
        $msg10 = str_replace('PROMFECHA', base64_decode($fecha), $msg9);

        $texto = $msg10;

        $html = $this->renderView('@Agenda/PDF/certificado.html.twig', [
            'documento' => $documento,
            'texto' => $texto,
        ]);

        $nombreDocumento =
            'Certificado' .
            $paciente->getIdUsuario()->getCedula() .
            date('YmdHis') .
            '.pdf';
        return new PdfResponse(
            $this->get('knp_snappy.pdf')->getOutputFromHtml($html),
            $nombreDocumento
        );
    }

	/**
     * @Route("/certificado/general/pdf/{codigo}/{medicoId}/{pacienteId}/{especialidadId}/{diagnostico}/{edad}/{nacionalidad}/{fecha}", name="certificadoGeneralPdf")
     */
    public function certificadoGeneralPdfAction(
        Request $request,
        $codigo = '',
        $medicoId = 0,
        $pacienteId = 0,
        $especialidadId = 0,
        $diagnostico = '',
        $edad = 0,
        $nacionalidad = '',
        $fecha = ''
    ) {
        $em = $this->getDoctrine()->getManager();
        $medico = $em
            ->getRepository('AdministradorBundle:Medico')
            ->find($medicoId);
        $paciente = $em
            ->getRepository('AdministradorBundle:Paciente')
            ->find($pacienteId);
        $especialidad = $em
            ->getRepository('AdministradorBundle:Especialidades')
            ->find($especialidadId);
        $documento = $em
            ->getRepository('AgendaBundle:Documentos')
            ->findOneBy(['idMedico' => $medico->getId(), 'codigo' => $codigo]);

        $nombreComercial =
            $medico->getIdUsuario()->getApellido() .
            ' ' .
            $medico->getIdUsuario()->getNombre();
        if (
            $medico->getNombreComercial() != null &&
            $medico->getNombreComercial() != ''
        ) {
            $nombreComercial = $medico->getNombreComercial();
        }

        $msg1 = str_replace(
            'PROMDOCTOR',
            $medico->getIdUsuario()->getApellido() .
                ' ' .
                $medico->getIdUsuario()->getNombre(),
            $documento->getTexto()
        );
        $msg2 = str_replace(
            'PROMESPECIALIDAD',
            $especialidad->getNombre(),
            $msg1
        );
        $msg3 = str_replace('PROMCONSULTORIO', $nombreComercial, $msg2);
        $msg4 = str_replace(
            'PROMPACIENTE',
            $paciente->getIdUsuario()->getApellido() .
                ' ' .
                $paciente->getIdUsuario()->getNombre(),
            $msg3
        );
        $msg5 = str_replace(
            'PROMCEDPACIENTE',
            $paciente->getIdUsuario()->getCedula(),
            $msg4
        );
        $msg6 = str_replace('PROMEDAD', base64_decode($edad), $msg5);
        $msg7 = str_replace('PROMNACIONALIDAD', base64_decode($nacionalidad), $msg6);
        $msg8 = str_replace('PROMDIAGNOSTICO', base64_decode($diagnostico), $msg7);
        $msg9 = str_replace('PROMFECHA', base64_decode($fecha), $msg8);

        $texto = $msg9;

        $html = $this->renderView('@Agenda/PDF/certificado.html.twig', [
            'documento' => $documento,
            'texto' => $texto,
        ]);

        $nombreDocumento =
            'Certificado' .
            $paciente->getIdUsuario()->getCedula() .
            date('YmdHis') .
            '.pdf';
        return new PdfResponse(
            $this->get('knp_snappy.pdf')->getOutputFromHtml($html),
            $nombreDocumento
        );
    }
    
    /**
     * @Route("/certificado/movilidad/pdf/{codigo}/{medicoId}/{paciente}/{especialidadId}/{cedulaPaciente}/{fechaEmision}/{examen}/{acompanante}/{cedacompanante}/{destino}/{destinatario}/{fechaMovilidad}/{motivo}/{placa}", name="certificadoMovilidadPdf")
     */
    public function certificadoMovilidadPdfAction(
        Request $request,
        $codigo = '',
        $medicoId = 0,
        $paciente = '',
        $especialidadId = 0,
        $cedulaPaciente = '',
        $fechaEmision = '',
        $examen = '',
        $acompanante = '',
        $cedacompanante = '',
        $destino = '',
        $destinatario = '',
        $fechaMovilidad = '',
        $motivo = '',
        $placa = ''
    ){
        $em = $this->getDoctrine()->getManager();
        $medico = $em
            ->getRepository('AdministradorBundle:Medico')
            ->find($medicoId);
        $especialidad = $em
            ->getRepository('AdministradorBundle:Especialidades')
            ->find($especialidadId);
        $documento = $em
            ->getRepository('AgendaBundle:Documentos')
            ->findOneBy(['idMedico' => $medico->getId(), 'codigo' => $codigo]);
        $nombreComercial =
            $medico->getIdUsuario()->getApellido() .
            ' ' .
            $medico->getIdUsuario()->getNombre();
        if (
            $medico->getNombreComercial() != null &&
            $medico->getNombreComercial() != ''
        ) {
            $nombreComercial = $medico->getNombreComercial();
        }
        $msg1 = str_replace('PROMPACIENTE', base64_decode($paciente), $documento->getTexto());
        $msg2 = str_replace('PROMCEDPACIENTE', base64_decode($cedulaPaciente), $msg1);
        $msg3 = str_replace('PROMFECHA', base64_decode($fechaEmision), $msg2);
        $msg4 = str_replace('PROMEXAMEN', base64_decode($examen), $msg3);
        $msg5 = str_replace('PROMACOMPA', base64_decode($acompanante), $msg4);
        $msg6 = str_replace('PROMCEDACOMPA', base64_decode($cedacompanante), $msg5);
        $msg7 = str_replace('PROMDESTINO', base64_decode($destino), $msg6);
        $msg8 = str_replace('PROMDESTINATARIO', base64_decode($destinatario), $msg7);
        $msg9 = str_replace('PROMOVILF', base64_decode($fechaMovilidad), $msg8);
        $msg10 = str_replace('PROMOTIVO', base64_decode($motivo), $msg9);
        $msg11 = str_replace('PROMPLACA', base64_decode($placa), $msg10);

        $texto = $msg11;

        $html = $this->renderView('@Agenda/PDF/certificado.html.twig', [
            'documento' => $documento,
            'texto' => $texto,
        ]);

        $nombreDocumento = 'CertificadoMovilidad'.$medico->getIdUsuario()->getId().date("YmdHis").'.pdf';
        return new PdfResponse(
            $this->get('knp_snappy.pdf')->getOutputFromHtml($html),
            $nombreDocumento
        );
    }

    /**
     * @Route("/orden/ingreso/pdf/{codigo}/{medicoId}/{paciente}/{especialidadId}/{destinatario}/{fechaEmision}/{diagnostico}/{examen}/{fechaIngreso}/{horaIngreso}/{fechaCirugia}/{horaCirugia}", name="ordenIngresoPdf")
     */
    public function ordenIngresoPdfAction(
        Request $request,
        $codigo = '',
        $medicoId = 0,
        $paciente = '',
        $especialidadId = 0,
        $destinatario = '',
        $fechaEmision = '',
        $diagnostico = '',
        $examen = '',
        $fechaIngreso = '',
        $horaIngreso = '',
        $fechaCirugia = '',
        $horaCirugia = ''
    ){
        $em = $this->getDoctrine()->getManager();
        $medico = $em
            ->getRepository('AdministradorBundle:Medico')
            ->find($medicoId);
        $especialidad = $em
            ->getRepository('AdministradorBundle:Especialidades')
            ->find($especialidadId);
        $documento = $em
            ->getRepository('AgendaBundle:Documentos')
            ->findOneBy(['idMedico' => $medico->getId(), 'codigo' => $codigo]);
        $nombreComercial =
            $medico->getIdUsuario()->getApellido() .
            ' ' .
            $medico->getIdUsuario()->getNombre();
        if (
            $medico->getNombreComercial() != null &&
            $medico->getNombreComercial() != ''
        ) {
            $nombreComercial = $medico->getNombreComercial();
        }

        $msg1 = str_replace('PROMPACIENTE', base64_decode($paciente), $documento->getTexto());
        $msg2 = str_replace('PROMDESTINATARIO', base64_decode($destinatario), $msg1);
        $msg3 = str_replace('PROMFECHA', base64_decode($fechaEmision), $msg2);
        $msg4 = str_replace('PROMDIAGNOSTICO', base64_decode($diagnostico), $msg3);
        $msg5 = str_replace('PROMEXAMEN', base64_decode($examen), $msg4);
        $msg6 = str_replace('PROMINGRESOF', base64_decode($fechaIngreso), $msg5);
        $msg7 = str_replace('PROMHORAI', base64_decode($horaIngreso), $msg6);
        $msg8 = str_replace('PROMCIRFECHA', base64_decode($fechaCirugia), $msg7);
        $msg9 = str_replace('PROMCIRUGIAH', base64_decode($horaCirugia), $msg8);

        $texto = $msg9;

        $html = $this->renderView('@Agenda/PDF/certificado.html.twig', [
            'documento' => $documento,
            'texto' => $texto,
        ]);
        $nombreDocumento = 'OrdenIngreso'.$medico->getIdUsuario()->getId().date("YmdHis").'.pdf';
        return new PdfResponse(
            $this->get('knp_snappy.pdf')->getOutputFromHtml($html),
            $nombreDocumento
        );
    }

	/**
	 * @Route("/consentimiento/formulario/pdf/{id}", name="consentimientoPdf")
	 */
	public function consentimientoPdfAction(Request $request, $id = 0)
	{
		$em = $this->getDoctrine()->getManager();
		$formulario = $em->getRepository("AgendaBundle:Formulario024")->find($id);
		$grafico = "";
		if($formulario->getGraficoProc() != "" && $formulario->getGraficoProc() != null)
			$grafico = base64_encode(file_get_contents($formulario->getGraficoProc()));
		$edad = "No definida";
        if($formulario->getIdPaciente()->getFechaNacimiento() != null)
        {
            $fechaHoy = date_create(date("Y-m-d"));
            $fechaNac = date_create($formulario->getIdPaciente()->getFechaNacimiento());
            $resultado = date_diff($fechaNac, $fechaHoy);
            $edad = $resultado->format("%y")." años";
        }

		$html = $this->renderView("@Agenda/PDF/consentimiento.html.twig", array(
			"formulario" => $formulario,
			"grafico" => $grafico,
			"edad" => $edad
		));

		$nombreDocumento = "Consentimiento".$formulario->getIdPaciente()->getIdUsuario()->getCedula().date("YmdHis").".pdf";
		return new PdfResponse($this->get("knp_snappy.pdf")->getOutputFromHtml($html), $nombreDocumento);
	}

    /**
     * @Route("/form053/pdf/{id}/{tipo}", name="form053_1Pdf")
     */
    public function form053_1PdfAction(Request $request, $id = 0, $tipo ='null')
    {
        $em = $this->getDoctrine()->getManager();
        $formulario = $em
            ->getRepository('AgendaBundle:Formulario053')
            ->find($id);

        if($tipo == 'R'){
            $html = $this->renderView('@Agenda/PDF/form053R.html.twig', [
                'formulario' => $formulario
            ]);
        } else if($tipo == 'C'){
            $html = $this->renderView('@Agenda/PDF/form053C.html.twig', [
                'formulario' => $formulario
            ]);
        }
        

        $nombreDocumento =
            'Form053' .
            $formulario
                ->getIdPaciente()
                ->getIdMedico()
                ->getId() .
            date('YmdHis') .
            '.pdf';
        return new PdfResponse(
            $this->get('knp_snappy.pdf')->getOutputFromHtml($html),
            $nombreDocumento
        );
    }
    
    /**
     * @Route("/formNutricion/pdf/{id}", name="formNutricion_1Pdf")
     */
    public function formNutricion_1PdfAction(Request $request, $id = 0){
        $em = $this->getDoctrine()->getManager();
        $formulario = $em
            ->getRepository('AgendaBundle:NutricionFormulario')
            ->find($id);

            $html = $this->renderView('@Agenda/PDF/nutricion.html.twig', [
                'formulario' => $formulario
            ]);

        /* if($tipo == 'R'){
            
        } else if($tipo == 'C'){
            $html = $this->renderView('@Agenda/PDF/form053C.html.twig', [
                'formulario' => $formulario
            ]);
        } */


        $nombreDocumento =
            'FormNutricion' .
            $formulario
                ->getIdPaciente()
                ->getIdMedico()
                ->getId() .
            date('YmdHis') .
            '.pdf';
        return new PdfResponse(
            $this->get('knp_snappy.pdf')->getOutputFromHtml($html),
            $nombreDocumento
        );
    }
    
}
