<?php

namespace AgendaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\XmlEncoder;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;

use AgendaBundle\Entity\ResumenHistoriaDiagnostico;
use AgendaBundle\Entity\ResumenHistoriaMedicamento;
use AgendaBundle\Entity\ResumenHistoriaImagen;
use AgendaBundle\Entity\ResumenHistoriaLab;
use AgendaBundle\Entity\ResumenExamenComp;
use AgendaBundle\Entity\PedidoImagen;
use AgendaBundle\Entity\PedidoExaComplemt;
use AgendaBundle\Entity\EvolucionMedica;
use AgendaBundle\Entity\Medicamento;

class ConsultaController extends Controller
{
	/**
	 * @Route("/consulta/diagnostico/create/", name="createDiagnosticoConsulta")
	 */
	public function createDiagnosticoConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenDiagnostico = new ResumenHistoriaDiagnostico();

		$cieDiez = $em->getRepository("AgendaBundle:CieDiez")->find($_POST["idCieDiez"]);
		$tipoDiagnostico = $em->getRepository("AgendaBundle:TipoDiagnostico")->find($_POST["idTipoDiagnostico"]);
		$resumenHistoria =  $em->getRepository("AgendaBundle:ResumenHistoriaClinica")->find($_POST["resumen"]);

		$resumenDiagnostico->setIdCieDiez($cieDiez);
		$resumenDiagnostico->setIdResumenHc($resumenHistoria);
		$resumenDiagnostico->setIdTipoDiagnostico($tipoDiagnostico);
		$resumenDiagnostico->setDiagnostico($_POST["diagnostico"]);

		$em->persist($resumenDiagnostico);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/consulta/diagnostico/delete/", name="deleteDiagnosticoConsulta")
	 */
	public function deleteDiagnosticoConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenDiagnostico = $em->getRepository("AgendaBundle:ResumenHistoriaDiagnostico")->find($_POST["id"]);

		$em->remove($resumenDiagnostico);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/consulta/diagnostico/read/", name="readDiagnosticoConsulta")
	 */
	public function readDiagnosticoConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenDiagnostico = $em->getRepository("AgendaBundle:ResumenHistoriaDiagnostico")->findBy(array("idResumenHc" => $_POST["resumenHc"]));

		$html = '';
		if($resumenDiagnostico)
		{
			foreach ($resumenDiagnostico as $row) 
			{
				$html .= '<tr>
					<td>'.$row->getDiagnostico().'</td>
					<td>'.$row->getIdCieDiez()->getNombre().'</td>
					<td>'.$row->getIdTipoDiagnostico()->getNombre().'</td>
					<td><button class="btn btn-link text-dark btnEliminarCie10" id="'.base64_encode($row->getId()).'">Eliminar</button></td>
				</tr>';
			}
		}

		return new Response($html);
	}
	/**
	 * @Route("/consulta/medicamento/create/", name="createMedicamentoConsulta")
	 */
	public function createMedicamentoConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenMedicamento = new ResumenHistoriaMedicamento();

		if(is_numeric($_POST["medicamento"]))
			$medicamento = $em->getRepository("AgendaBundle:Medicamento")->find($_POST["medicamento"]);
		else
		{
			$medicamentoNew = new Medicamento();
			$medicamentoNew->setNombre($_POST["medicamento"]);
			$medicamentoNew->setCodigo("");
			$medicamentoNew->setEstado(true);
			$em->persist($medicamentoNew);

			$medicamento = $em->getRepository("AgendaBundle:Medicamento")->find($medicamentoNew->getId());
		}

		$resumenHistoria =  $em->getRepository("AgendaBundle:ResumenHistoriaClinica")->find($_POST["resumen"]);

		$resumenMedicamento->setIdMedicamento($medicamento);
		$resumenMedicamento->setIdResumenHc($resumenHistoria);
		$resumenMedicamento->setCantidadMedicamento($_POST["cantidad"]);
		$resumenMedicamento->setIndicacionesMedicamento($_POST["indicaciones"]);
		$resumenMedicamento->setTipoPedido($_POST["tipoPedido"]);

		$em->persist($resumenMedicamento);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/consulta/medicamento/delete/", name="deleteMedicamentoConsulta")
	 */
	public function deleteMedicamentoConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenMedicamento = $em->getRepository("AgendaBundle:ResumenHistoriaMedicamento")->find($_POST["id"]);

		$em->remove($resumenMedicamento);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/consulta/medicamento/read/", name="readMedicamentoConsulta")
	 */
	public function readMedicamentoConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenMedicamento = $em->getRepository("AgendaBundle:ResumenHistoriaMedicamento")->findBy(array("idResumenHc" => $_POST["resumenHc"], "tipoPedido" => $_POST["tipoPedido"]));

		$html = '';
		if($resumenMedicamento)
		{
			foreach ($resumenMedicamento as $row) 
			{
				$html .= '<tr>
					<td>'.$row->getIdMedicamento()->getNombre().'</td>
					<td>'.$row->getCantidadMedicamento().'</td>
					<td>'.$row->getIndicacionesMedicamento().'</td>
					<td><button class="btn btn-link text-dark btnEliminarMedicamento" id="'.base64_encode($row->getId()).'">Eliminar</button></td>
				</tr>';
			}
		}
		return new Response($html);
	}

	/**
	 * @Route("/consulta/imagen/consulta/", name="createImagenConsulta")
	 */
	public function createImagenConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenImagen = new ResumenHistoriaImagen();

		if(is_numeric($_POST["imagen"]))
			$imagen = $em->getRepository("AgendaBundle:PedidoImagen")->find($_POST["imagen"]);
		else
		{
			$examenImagen = new PedidoImagen();
			$examenImagen->setNombre($_POST["imagen"]);
			$examenImagen->setCodigo("");
			$examenImagen->setEstado(true);
			$em->persist($examenImagen);

			$imagen = $em->getRepository("AgendaBundle:PedidoImagen")->find($examenImagen->getId());
		}
		
		$resumenHistoria =  $em->getRepository("AgendaBundle:ResumenHistoriaClinica")->find($_POST["resumen"]);

		$resumenImagen->setIdPedidoImagen($imagen);
		$resumenImagen->setIdResumenHc($resumenHistoria);
		$resumenImagen->setFecha(date("Y-m-d"));
		$resumenImagen->setTipoPedido($_POST["tipoPedido"]);
		$em->persist($resumenImagen);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/consulta/imagen/delete/", name="deleteImagenConsulta")
	 */
	public function deleteImagenConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenImagen = $em->getRepository("AgendaBundle:ResumenHistoriaImagen")->find($_POST["id"]);

		$em->remove($resumenImagen);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/consulta/imagen/read/", name="readImagenConsulta")
	 */
	public function readImagenConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenImagen = $em->getRepository("AgendaBundle:ResumenHistoriaImagen")->findBy(array("idResumenHc" => $_POST["resumenHc"], "tipoPedido" => $_POST["tipoPedido"]));
		$html = '';

		if($resumenImagen)
		{
			foreach($resumenImagen as $row)
			{
				$html .= '<tr>
					<td>'.$row->getIdPedidoImagen()->getNombre().'</td>
					<td><button class="btn btn-link text-dark btnEliminarImagen" id="'.base64_encode($row->getId()).'">Eliminar</button></td>
				</tr>';
			}
		}

		return new Response($html);
	}

	/**
	 * @Route("/consulta/laboratorio/create/", name="createLaboratorioConsulta")
	 */
	public function createLaboratorioConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenLaboratorio = new ResumenHistoriaLab();

		$laboratorio = $em->getRepository("AgendaBundle:PedidoExaComplemt")->find($_POST["laboratorio"]);
		$resumenHistoria =  $em->getRepository("AgendaBundle:ResumenHistoriaClinica")->find($_POST["resumen"]);

		$resumenLaboratorio->setIdExaComple($laboratorio);
		$resumenLaboratorio->setIdResumenHc($resumenHistoria);
		$resumenLaboratorio->setFecha(date("Y-m-d"));
		$resumenLaboratorio->setTipoPedido($_POST["tipoPedido"]);

		$em->persist($resumenLaboratorio);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/consulta/laboratorio/delete/", name="deleteLaboratorioConsulta")
	 */
	public function deleteLaboratorioConsulta()
	{
		$em = $this->getDoctrine()->getManager();

		$idResumenHc = $_POST["resumenHc"];
		$idExaComple = $_POST["idExaComple"];
		$tipoPedido = $_POST["tipoPedido"];

		if($_POST["id"] != 0)
			$resumenLaboratorio = $em->getRepository("AgendaBundle:ResumenHistoriaLab")->find($_POST["id"]);
		else
			$resumenLaboratorio = $em->getRepository("AgendaBundle:ResumenHistoriaLab")->findOneBy(array("idResumenHc" => $idResumenHc, "idExaComple" => $idExaComple, "tipoPedido" => $tipoPedido));

		$em->remove($resumenLaboratorio);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/consulta/laboratorio/read/", name="readLaboratorioConsulta")
	 */
	public function readLaboratorioConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenLaboratorio = $em->getRepository("AgendaBundle:ResumenHistoriaLab")->findBy(array("idResumenHc" => $_POST["resumenHc"], "tipoPedido" => $_POST["tipoPedido"]));

		$html = '';
		if($resumenLaboratorio)
		{
			foreach($resumenLaboratorio as $row)
			{
				$html .= '<tr>
					<td>'.$row->getIdExaComple()->getNombre().'</td>
					<td><button class="btn btn-link text-dark btnEliminarLaboratorio" id="'.base64_encode($row->getId()).'">Eliminar</button></td>
				</tr>';
			}
		}

		return new Response($html);
	}

	/**
	 * @Route("/consulta/complement/create/", name="createComplementarioConsulta")
	 */	
	public function createComplementarioConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenCompl = new ResumenExamenComp();

		$resumenHc = $em->getRepository("AgendaBundle:ResumenHistoriaClinica")->find($_POST["resumen"]);

		$resumenCompl->setNombre($_POST["examen_compl"]);
		$resumenCompl->setIdResumenHc($resumenHc);
		$resumenCompl->setFecha(date("Y-m-d"));
		$resumenCompl->setTipoPedido($_POST["tipoPedido"]);

		$em->persist($resumenCompl);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/consulta/complement/delete/", name="deleteComplementarioConsulta")
	 */
	public function deleteComplementarioConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenCompl = $em->getRepository("AgendaBundle:ResumenExamenComp")->find($_POST["id"]);

		$em->remove($resumenCompl);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/consulta/complement/read/", name="readComplementarioConsulta")
	 */
	public function readComplementarioConsulta()
	{
		$em = $this->getDoctrine()->getManager();
		$resumenCompl = $em->getRepository("AgendaBundle:ResumenExamenComp")->findBy(array("idResumenHc" => $_POST["resumenHc"], "tipoPedido" => $_POST["tipoPedido"]));

		$html = '';
		if($resumenCompl)
		{
			foreach($resumenCompl as $row)
			{
				$html .= '<tr>
					<td>'.$row->getNombre().'</td>
					<td><button class="btn btn-link text-dark btnEliminarComplem" id="'.base64_encode($row->getId()).'">Eliminar</button></td>
				</tr>';
			}
		}

		return new Response($html);
	}

	/**
	 * @Route("/consulta/examenes/laboratorio/", name="examenesLaboratorioCita")
	 */
	public function examenesLaboratorioCita()
    {
        $em = $this->getDoctrine()->getManager();
        $examenesLaboratorio = $em->getRepository("AgendaBundle:PedidoExaComplemt")->findAll();
        $pedidoLaboratorio = $em->getRepository("AgendaBundle:ResumenHistoriaLab")->findBy(array("idResumenHc" => $_POST["idResumenHC"], "tipoPedido" => $_POST["tipoPedido"]));
        $contador = 0;
        $html = '';
        if($examenesLaboratorio)
        {
            foreach($examenesLaboratorio as $row)
            {
                $contador++;
                if($contador == 1)
                    $html .= '<div class="w-100 d-flex align-item-center">';

                $html .= '<div class="col-md-4"><label><input type="checkbox" value="'.$row->getId().'" class="chkLab" id="chkLab'.$row->getId().'" ';
                if($pedidoLaboratorio)
                {
                    foreach($pedidoLaboratorio as $fila)
                    {
                        if($row->getId() == $fila->getIdExaComple()->getId())
                            $html .= 'checked';
                    }
                }
                $html .= '>'.$row->getNombre().'</label></div>';

                if($contador == 3)
                {
                    $html .= '</div>';
                    $contador = 0;
                }
            }
        }
        return new Response($html);
    }

    /**
     * @Route("/create/pedido/imagen/", name="createPedidoImagen")
     */
    public function createPedidoImagen()
    {
    	$em = $this->getDoctrine()->getManager();
    	$pedidoImagen = new PedidoImagen();

    	$pedidoImagen->setNombre($_POST["nombreExamen"]);
    	$pedidoImagen->setCodigo("");
    	$pedidoImagen->setEstado(true);

    	$em->persist($pedidoImagen);
    	$em->flush();

    	return new Response("ok");
    }

    /**
     * @Route("/create/pedido/laboratorio/", name="createPedidoLaboratorio")
     */
    public function createPedidoLaboratorio()
    {
    	$em = $this->getDoctrine()->getManager();
    	$pedidoLab = new PedidoExaComplemt();

    	$pedidoLab->setNombre($_POST["nombreExamen"]);
    	$pedidoLab->setCodigo("");
    	$pedidoLab->setEstado(true);

    	$em->persist($pedidoLab);
    	$em->flush();

    	return new Response("ok"); 
    }

    /**
     * @Route("/get/puntos/especialidad/", name="getPuntoCampoEspecialidad") 
     */
    public function getPuntoCampoEspecialidad()
    {
    	$em = $this->getDoctrine()->getManager();
    	$puntos = $em->getRepository("AgendaBundle:PuntosEspecialidad")->findOneBy(array("idPaciente" => $_POST["paciente"], "idEspecialidad" => $_POST["especialidad"], "idMedico" => $_POST["medico"]));
    	$campos = "";
    	if($puntos)
    		$campos = $puntos->getCamposAdicional();

        return new Response($campos);
    }

    /**
     * @Route("/update/campo/adicional/", name="updateCampoAdicional")
     */
    public function updateCampoAdicional()
    {
    	$em = $this->getDoctrine()->getManager();
    	//$puntos = $em->getRepository("AgendaBundle:PuntosEspecialidad")->findOneBy(array("idPaciente" => $_POST["paciente"], "idEspecialidad" => $_POST["especialidad"], "idMedico" => $_POST["medico"]));
    	$puntos = $em->getRepository("AgendaBundle:PuntosEspecialidad")->findOneBy(array("idPaciente" => $_POST["paciente"], "idEspecialidad" => $_POST["especialidad"]));
    	if($_POST["campo"] != "no")
    		$puntos->setCamposAdicional(json_encode($_POST["campo"]));
    	else
    		$puntos->setCamposAdicional(null);

    	$em->flush();
    	return new Response("ok");
    }

    /**
     * @Route("/read/puntos/pediatria/", name="getPuntosPediatria")
     */
    public function getPuntosPediatria()
    {
    	$em = $this->getDoctrine()->getManager();
    	$puntos = $em->getRepository("AgendaBundle:PuntosEspecialidad")->findOneBy(array("idPaciente" => $_POST["paciente"], "idEspecialidad" => $_POST["especialidad"], "idMedico" => $_POST["medico"]));
    	
    	if($puntos->getPuntos() == "")
    	{
    		$datos = array();
    		$arrayTalla = array();
    		$arrayPeso = array();

    		for($i = 0; $i < 61; $i++)
    		{
    			$arrayTalla[$i] = "null";
    			$arrayPeso[$i] = "null";
    		}

    		$datos[0] = array(
    			"tipo" => "talla",
    			"valores" => $arrayTalla
    		);
    		$datos[1] = array(
    			"tipo" => "peso",
    			"valores" => $arrayPeso
    		);

    		$puntos->setPuntos(json_encode($datos));
    		$em->flush();
    	}
    	return new Response($puntos->getPuntos());
    }

    /**
     * @Route("/update/punto/pediatria/", name="updatePuntoPediatria")
     */
    public function updatePuntoPediatria()
    {
    	$em = $this->getDoctrine()->getManager();
    	$puntos = $em->getRepository("AgendaBundle:PuntosEspecialidad")->findOneBy(array("idPaciente" => $_POST["paciente"], "idEspecialidad" => $_POST["especialidad"], "idMedico" => $_POST["medico"]));

    	$puntos->setPuntos(json_encode($_POST["puntos"]));
    	$em->flush();

    	return new Response("ok");
    }

}
