<?php

namespace AgendaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AgendaBundle\Entity\CitaMedica;
use FacturacionBundle\Entity\Factura;

class CitaMedicaController extends Controller
{
	/**
	 * @Route("/cita/medica/create/", name="createCitaMedica")
	 */
	public function createCitaMedicaAction()
	{
		$em = $this->getDoctrine()->getManager();

		$paciente = $em->getRepository("AdministradorBundle:Paciente")->find($_POST["idPaciente"]);
		$especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find($_POST["idEspecialidad"]);
		$estadoCita = $em->getRepository("AgendaBundle:EstadoCitaMedica")->find(1);
		$agenda = $em->getRepository("AgendaBundle:Agenda")->find($_POST["idAgenda"]);
		$hora = $em->getRepository("AgendaBundle:AgendaHL")->find($_POST["hora"]);

		$citaMedica = new CitaMedica();
		$citaMedica->setIdPaciente($paciente);
		$citaMedica->setIdEspecialidad($especialidad);
		$citaMedica->setIdEstadoCita($estadoCita);
		$citaMedica->setIdAgenda($agenda);
		$citaMedica->setFecha($_POST["fecha"]);
		$citaMedica->setHora($hora->getHora());
		$citaMedica->setFactura(false);

		$em->persist($citaMedica);
		$em->flush();

		if($paciente->getIdUsuario()->getEmail() != null && $paciente->getIdUsuario()->getEmail() != "")
		{
			$message = (new \Swift_Message("Recordatorio Cita Médica"))
			->setFrom($citaMedica->getIdAgenda()->getIdMedico()->getIdUsuario()->getEmail())
			// Nacional
			->setTo($citaMedica->getIdPaciente()->getIdUsuario()->getEmail())
			// Axiss
			->setTo([$citaMedica->getIdPaciente()->getIdUsuario()->getEmail(), "mafer023028@gmail.com"])
			->setBody($this->renderView("@Agenda/Notificaciones/index.html.twig", array(
			// MHC
			//->setBody($this->renderView("@Agenda/Notificaciones/mhc.html.twig", array(
				"cita" => $citaMedica,
				'idPaciente' => base64_encode($paciente->getId()),
				'sala' => base64_encode($citaMedica->getIdAgenda()->getIdMedico()->getId().'_'.$paciente->getId())
			)), 'text/html');

			$this->get("mailer")->send($message);
		}

		$json = [
			"id" => $citaMedica->getId(),
			"paciente" => [
				"id" => $citaMedica->getIdPaciente()->getId(),
				"nombre" => $citaMedica->getIdPaciente()->getIdUsuario()->getApellido()." ".$citaMedica->getIdPaciente()->getIdUsuario()->getNombre(),
				"telefono" => $citaMedica->getIdPaciente()->getTelefono(),
				"celular" => $citaMedica->getIdPaciente()->getIdUsuario()->getTelefono(),
				"email" => $citaMedica->getIdPaciente()->getIdUsuario()->getEmail()
			]
		];

		return new Response(json_encode($json));
	}

	/**
	 * @Route("/cita/medica/update/")
	 */
	public function updateCitaMedicaAction()
	{
		$em = $this->getDoctrine()->getManager();

		$especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find($_POST["idEspecialidad"]);
		$hora = $em->getRepository("AgendaBundle:AgendaHL")->find($_POST["hora"]);

		$citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->find($_POST["idCitaMedica"]);
		$citaMedica->setIdEspecialidad($especialidad);
		$citaMedica->setHora($hora->getHora());
		
		$em->flush();
		return new Response($citaMedica->getId());
	}

	/**
	 * @Route("/cita/medica/delete/")
	 */
	public function deleteCitaMedicaAction()
	{
		$em = $this->getDoctrine()->getManager();
		$citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->find($_POST["id"]);
		$em->remove($citaMedica);
		$em->flush();

		return new Response("ok");
	}
}
