<?php

namespace AgendaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AdministradorBundle\Entity\Noticas;

class BlogNoticiasController extends Controller
{
	/**
	 * @Route("/noticias/", name="blogNoticias")
	 */
	public function indexAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
            $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
            $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
			$noticiasTot = $em->getRepository("AdministradorBundle:Noticas")->findBy(array("estado" => true), array("id" => "DESC"));
			$paginator = $this->get("knp_paginator");
			$pagination = $paginator->paginate(
				$noticiasTot,
				$request->query->getInt("page", 1),
				5
			);
			
			return $this->render("@Agenda/Noticias/index.html.twig", array('usuario' => $usuario, "noticias" => $noticias, "noticiasTot" => $pagination));
		}
	}

	/**
	 * @Route("/noticias/{not}/", name="noticiaCompl")
	 */
	public function noticiaAction(Request $request, $not)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
			$noticia = $em->getRepository("AdministradorBundle:Noticas")->find($not);
            
            $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
            $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
			
			return $this->render("@Agenda/Noticias/noticia.html.twig", array('usuario' => $usuario, "noticia" => $noticia, "noticias" => $noticias));
		}
	}
}
