<?php

namespace AgendaBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use LoginBundle\Entity\Usuario;
use AdministradorBundle\Entity\Medico;
use LoginBundle\Entity\Rol;
use AdministradorBundle\Entity\Paciente;
use AgendaBundle\Entity\HistoriaClinica;
use AgendaBundle\Entity\Agenda;
use AgendaBundle\Entity\HorariosLaborables;
use AgendaBundle\Entity\AgendaHL;
use AgendaBundle\Entity\AntecedentesFamiliares;
use AgendaBundle\Entity\AntecedentesPersonales;
use AgendaBundle\Entity\AntecedentesGinecobstetricos;
use Knp\Bundle\SnappyBundle\Snappy\Response\PdfResponse;

class AgendaController extends Controller
{
	/**
     * @Route("/", name="homeUsuario")
     */
    public function indexAction(Request $request)
    {
    	if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2 && $request->getSession()->get("rol") != 3)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
            $noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }
			return $this->render('@Agenda/Default/index.html.twig', array("usuario" => $usuario, "noticias" => $noticias));
		}
    }

    /**
     * @Route("/citas/", name="Agenda")
     */
    public function agendaAction(Request $request)
    {
    	if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2 && $request->getSession()->get("rol") != 3)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
            $provincias = $em->getRepository("AdministradorBundle:Provincias")->findAll();
            $mes = date("m");
            $anio = date("Y");
            $noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }

            if($usuario->getRolUsuario()->getId() == 2)
            {
                $medico = $em->getRepository("AdministradorBundle:Medico")->findOneBy(array("idUsuario" => $usuario->getId()));
            }
            else
            {
                //$queryMed = "select a from AdministradorBundle:AsistenteMedico a where a.idAsistente = :asistente";
                $medico = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $usuario->getIdAsistente()->getId()));
            }

			return $this->render("@Agenda/Default/agenda.html.twig", array("usuario" => $usuario, "medico" => $medico, "provincias" => $provincias, "noticias" => $noticias, "mes" => $mes, "anio" => $anio));
		}
    }

    /**
     * @Route("/paciente/", name="agendaPaciente")
     */
    public function listPacienteAction(Request $request)
    {
    	if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2 && $request->getSession()->get("rol") != 3)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
            $provincias = $em->getRepository("AdministradorBundle:Provincias")->findAll();
            $noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }
            if($usuario->getRolUsuario()->getId() == 2)
                $medico = $em->getRepository("AdministradorBundle:Medico")->findOneBy(array("idUsuario" => $usuario->getId()));
            else
                $medico = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $usuario->getIdAsistente()->getId()));

			return $this->render("@Agenda/Default/pacientes.html.twig", array("usuario" => $usuario, "medico" => $medico, "provincias" => $provincias, "noticias" => $noticias));
		}
    }

    /**
     * @Route("/paciente/crear/", name="crearPaciente")
     */
    public function createPacienteAction()
    {
    	$em = $this->getDoctrine()->getManager();
    	$usuario = new Usuario();
    	$rol = new Rol();
        $medico = new Medico();
    	$paciente = new Paciente();

        $rol = $em->getRepository("LoginBundle:Rol")->find(4);
        $usuario->setRolUsuario($rol);
        $usuario->setCedula($_POST["cedula"]);
        $usuario->setNombre($_POST["nombre"]);
        $usuario->setApellido($_POST["apellido"]);
        $usuario->setTelefono($_POST["celular"]);
        $usuario->setEmail($_POST["email"]);
        $usuario->setEstado(true);
        $usuario->setTipoIdentificacion($_POST["tipo_iden"]);

        $em->persist($usuario);
        $em->flush();

        $fecNac = $_POST["fechaNacimiento"];
        if($_POST["fechaNacimiento"] == "")
            $fecNac = null;

        $medico = $em->getRepository("AdministradorBundle:Medico")->find($_POST["medico"]);
        $parroquia = $em->getRepository("AdministradorBundle:Parroquias")->find($_POST["parroquia"]);
        $paciente->setIdUsuario($usuario);
    	$paciente->setFechaNacimiento($fecNac);
    	$paciente->setGenero($_POST["genero"]);
    	$paciente->setEstadoCivil($_POST["estadoCivil"]);
    	$paciente->setDireccion($_POST["direccion"]);
    	$paciente->setSector($_POST["sector"]);
    	$paciente->setContacto($_POST["contacto"]);
    	$paciente->setOcupacion($_POST["ocupacion"]);
        $paciente->setIdMedico($medico);
        $paciente->setAseguradora($_POST["seguro"]);
        $paciente->setTelefono($_POST["telefono"]);
        $paciente->setIdParroquia($parroquia);
        $paciente->setFechaRegistro(date("Y-m-d"));

        $usuario->setIdPaciente($paciente);

    	$em->persist($paciente);

        $codigoHc = "";
        if($paciente->getId() < 10)
            $codigoHc = "00000".$paciente->getId();
        elseif($paciente->getId() < 100)
            $codigoHc = "0000".$paciente->getId();
        elseif($paciente->getId() < 1000)
            $codigoHc = "000".$paciente->getId();
        elseif($paciente->getId() < 10000)
            $codigoHc = "00".$paciente->getId();
        elseif($paciente->getId() < 100000)
            $codigoHc = "0".$paciente->getId();
        elseif($paciente->getId() < 1000000)
            $codigoHc = $paciente->getId();

        $historiaClinica = new HistoriaClinica();
        $historiaClinica->setIdPaciente($paciente);
        $historiaClinica->setNumeroHc($codigoHc);
        $historiaClinica->setFechaCreacion(date("Y-m-d"));
        $em->persist($historiaClinica);

        $antecedentesPersonales = new AntecedentesPersonales();
        $antecedentesPersonales->setIdPaciente($paciente);
        $em->persist($antecedentesPersonales);

        $antecedentesFamiliares = new AntecedentesFamiliares();
        $antecedentesFamiliares->setIdPaciente($paciente);
        $em->persist($antecedentesFamiliares);

        if($_POST["genero"] == "Femenino")
        {
            $antecedentesGine = new AntecedentesGinecobstetricos();
            $antecedentesGine->setIdPaciente($paciente);
            $em->persist($antecedentesGine);
        }

        $em->flush();

    	
    	return new Response("ok");
    }

    /**
     * @Route("/paciente/update/{idPaciente}", name="updatePaciente")
     */
    public function updatePacienteAction($idPaciente)
    {
    	$em = $this->getDoctrine()->getManager();

        $paciente = $em->getRepository("AdministradorBundle:Paciente")->find($idPaciente);
    	$usuario = $em->getRepository("LoginBundle:Usuario")->find($paciente->getIdUsuario()->getId());
        $parroquia = $em->getRepository("AdministradorBundle:Parroquias")->find($_POST["parroquia"]);
    	
    	$paciente->setFechaNacimiento($_POST["fechaNacimiento"]);
    	$paciente->setGenero($_POST["genero"]);
    	$paciente->setEstadoCivil($_POST["estadoCivil"]);
    	$paciente->setDireccion($_POST["direccion"]);
    	$paciente->setSector($_POST["sector"]);
    	$paciente->setContacto($_POST["contacto"]);
    	$paciente->setOcupacion($_POST["ocupacion"]);
        $paciente->setAseguradora($_POST["seguro"]);
        $paciente->setTelefono($_POST["telefono"]);
        $paciente->setIdParroquia($parroquia);

    	$usuario->setCedula($_POST["cedula"]);
    	$usuario->setNombre($_POST["nombre"]);
    	$usuario->setApellido($_POST["apellido"]);
    	$usuario->setTelefono($_POST["celular"]);
    	$usuario->setEmail($_POST["email"]);
        $usuario->setTipoIdentificacion($_POST["tipo_iden"]);

        if($_POST["genero"] == "Femenino")
        {
            $antecedentesGine = $em->getRepository("AgendaBundle:AntecedentesGinecobstetricos")->findOneBy(array("idPaciente" => $idPaciente));

            if(!$antecedentesGine)
            {
                $antecedentesGine = new AntecedentesGinecobstetricos();
                $antecedentesGine->setIdPaciente($paciente);
                $em->persist($antecedentesGine);
            }
        }

    	$em->flush();
    	return new Response("ok");
    }

    /**
     * @Route("/horario/laborable/create/")
     */
    public function createHorarioLaborable()
    {
    	$em = $this->getDoctrine()->getManager();
        $agenda = $em->getRepository("AgendaBundle:Agenda")->findOneBy(array("idMedico" => $_POST["idMedico"]));
        $dia = $em->getRepository("AgendaBundle:DiasLaborables")->find($_POST["idDia"]);

        $query = "select count(h.id) from AgendaBundle:HorariosLaborables h where h.idDiasLaborables = ".$dia->getId()." and h.idAgenda = ".$agenda->getId();
        $total = $em->createQuery($query)->getSingleScalarResult();

        if($total < 2)
        {
            $horariosLaborables = new HorariosLaborables();

            $horariosLaborables->setIdDiasLaborables($dia);
            $horariosLaborables->setIdAgenda($agenda);
            $horariosLaborables->setHoraInicio($_POST["hinicio"]);
            $horariosLaborables->setHoraFin($_POST["hfin"]);
            $horariosLaborables->setMinutos($_POST["minutos"]);
            $horariosLaborables->setEstado(true);
            $horariosLaborables->setOrden($_POST["orden"]);

            $em->persist($horariosLaborables);

            $inicio = explode(":", $_POST["hinicio"]);
            $fin = explode(":", $_POST["hfin"]);

            $tiempo = 60 / $_POST["minutos"];

            if($inicio[1] == "00")
            {
                for ($i = $inicio[0]; $i < $fin[0]; $i++)
                {
                    $agendaHL = new AgendaHL();
                    $agendaHL->setIdHorarioLaborable($horariosLaborables);
                    $agendaHL->setHora($i.":00");
                    $em->persist($agendaHL);

                    if($_POST["minutos"] != 60)
                    {
                        for($j = 0; $j < $tiempo; $j++)
                        {
                            if($j > 0)
                            {
                                $horarioAtencion2 = new AgendaHL();
                                $horarioAtencion2->setIdHorarioLaborable($horariosLaborables);
                                $horarioAtencion2->setHora($i.":".($_POST["minutos"] * $j));

                                $em->persist($horarioAtencion2);
                            }       
                        }
                    }
                }

                if($fin[1] == "30")
                {
                    if($_POST["minutos"] != 60)
                    {
                        for($i = 0; $i < ($tiempo/2); $i++)
                        {
                            $horarioAtencion2 = new AgendaHL();
                            $horarioAtencion2->setIdHorarioLaborable($horariosLaborables);
                            $min = ($_POST["minutos"] * $i);
                            if($min == 0)
                                $min = "00";
                            $horarioAtencion2->setHora($fin[0].":".$min);
                            $em->persist($horarioAtencion2);
                        }
                    }
                }
            }
            else
            {
                $agendaHL = new AgendaHL();
                $agendaHL->setIdHorarioLaborable($horariosLaborables);
                $agendaHL->setHora($_POST["hinicio"]);
                $em->persist($agendaHL);

                if($_POST["minutos"] != 30)
                {
                    for($j = 0; $j < ($tiempo/2); $j++)
                    {
                        if($j > 0)
                        {
                            $horarioAtencion2 = new AgendaHL();
                            $horarioAtencion2->setIdHorarioLaborable($horariosLaborables);
                            $horarioAtencion2->setHora($inicio[0].":".(($_POST["minutos"] * $j) + 30));
                            $em->persist($horarioAtencion2);
                        }
                    }
                }

                for ($i = $inicio[0] + 1; $i < $fin[0]; $i++)
                {
                    if($_POST["minutos"] != 60)
                    {
                        $agendaHL = new AgendaHL();
                        $agendaHL->setIdHorarioLaborable($horariosLaborables);
                        $agendaHL->setHora($i.":00");
                        $em->persist($agendaHL);

                        for($j = 0; $j < $tiempo; $j++)
                        {
                            if($j > 0)
                            {
                                $horarioAtencion2 = new AgendaHL();
                                $horarioAtencion2->setIdHorarioLaborable($horariosLaborables);
                                $horarioAtencion2->setHora($i.":".($_POST["minutos"] * $j));

                                $em->persist($horarioAtencion2);
                            }       
                        }
                    }
                }

                if($fin[1] == "30")
                {
                    if($_POST["minutos"] != 60)
                    {
                        for($i = 0; $i < ($tiempo/2); $i++)
                        {
                            $horarioAtencion2 = new AgendaHL();
                            $horarioAtencion2->setIdHorarioLaborable($horariosLaborables);
                            $min = ($_POST["minutos"] * $i);
                            if($min == 0)
                                $min = "00";
                            $horarioAtencion2->setHora($fin[0].":".$min);
                            $em->persist($horarioAtencion2);
                        }
                    }
                }
            }
            $em->flush();
        }
    	return new Response("ok");
    }

    /**
     * @Route("/horario/laborable/update/")
     */
    public function updateHorarioLaborable()
    {
        $em = $this->getDoctrine()->getManager();

        $horarioLaborable = $em->getRepository("AgendaBundle:HorariosLaborables")->find($_POST["idHorario"]);
        $horarioLaborable->setHoraInicio($_POST["hinicio"]);
        $horarioLaborable->setHoraFin($_POST["hfin"]);
        $horarioLaborable->setMinutos($_POST["minutos"]);

        $inicio = explode(":", $_POST["hinicio"]);
        $fin = explode(":", $_POST["hfin"]);

        $tiempo = 60 / $_POST["minutos"];

        if($inicio[1] == "00")
        {
            for ($i = $inicio[0]; $i < $fin[0]; $i++)
            {
                $agendaHL = new AgendaHL();
                $agendaHL->setIdHorarioLaborable($horarioLaborable);
                $agendaHL->setHora($i.":00");

                $em->persist($agendaHL);

                if($_POST["minutos"] != 60)
                {
                    for($j = 0; $j < $tiempo; $j++)
                    {
                        if($j > 0)
                        {
                            $horarioAtencion2 = new AgendaHL();
                            $horarioAtencion2->setIdHorarioLaborable($horarioLaborable);
                            $horarioAtencion2->setHora($i.":".($_POST["minutos"] * $j));

                            $em->persist($horarioAtencion2);
                        }       
                    }
                }
            }

            if($fin[1] == "30")
            {
                if($_POST["minutos"] != 60)
                {
                    for($i = 0; $i < ($tiempo/2); $i++)
                    {
                        $horarioAtencion2 = new AgendaHL();
                        $horarioAtencion2->setIdHorarioLaborable($horarioLaborable);
                        $min = ($_POST["minutos"] * $i);
                        if($min == 0)
                            $min = "00";
                        $horarioAtencion2->setHora($fin[0].":".$min);
                        $em->persist($horarioAtencion2);
                    }
                }
            }
        }
        else
        {
            $agendaHL = new AgendaHL();
            $agendaHL->setIdHorarioLaborable($horarioLaborable);
            $agendaHL->setHora($_POST["hinicio"]);
            $em->persist($agendaHL);

            if($_POST["minutos"] != 30)
            {
                for($j = 0; $j < ($tiempo/2); $j++)
                {
                    if($j > 0)
                    {
                        $horarioAtencion2 = new AgendaHL();
                        $horarioAtencion2->setIdHorarioLaborable($horarioLaborable);
                        $horarioAtencion2->setHora($inicio[0].":".(($_POST["minutos"] * $j) + 30));
                        $em->persist($horarioAtencion2);
                    }
                }
            }

            for ($i = $inicio[0] + 1; $i < $fin[0]; $i++)
            {
                if($_POST["minutos"] != 60)
                {
                    $agendaHL = new AgendaHL();
                    $agendaHL->setIdHorarioLaborable($horarioLaborable);
                    $agendaHL->setHora($i.":00");
                    $em->persist($agendaHL);

                    for($j = 0; $j < $tiempo; $j++)
                    {
                        if($j > 0)
                        {
                            $horarioAtencion2 = new AgendaHL();
                            $horarioAtencion2->setIdHorarioLaborable($horarioLaborable);
                            $horarioAtencion2->setHora($i.":".($_POST["minutos"] * $j));

                            $em->persist($horarioAtencion2);
                        }       
                    }
                }
            }

            if($fin[1] == "30")
            {
                if($_POST["minutos"] != 60)
                {
                    for($i = 0; $i < ($tiempo/2); $i++)
                    {
                        $horarioAtencion2 = new AgendaHL();
                        $horarioAtencion2->setIdHorarioLaborable($horarioLaborable);
                        $min = ($_POST["minutos"] * $i);
                        if($min == 0)
                            $min = "00";
                        $horarioAtencion2->setHora($fin[0].":".$min);
                        $em->persist($horarioAtencion2);
                    }
                }
            }
        }
        $em->flush();
            
        return new Response("ok");
    }

    /**
     * @Route("/horario/laborable/delete/")
     */
    public function deleteHorarioLaborable()
    {
        $em = $this->getDoctrine()->getManager();
        $horariosLaborables = $em->getRepository("AgendaBundle:HorariosLaborables")->findBy(array("idAgenda" => $_POST["idAgenda"]));
        foreach($horariosLaborables as $row)
        {
            $agendaHL = $em->getRepository("AgendaBundle:AgendaHL")->findBy(array("idHorarioLaborable" => $row->getId()));

            foreach($agendaHL as $fila)
            {
                $agendaAnt = $em->getRepository("AgendaBundle:AgendaHL")->find($fila->getId());
                $em->remove($agendaAnt);
                $em->flush();
            }
        }
        return new Response("ok");
    }

    /**
     * @Route("/paciente/catalogo/", name="catalogoPacientes")
     */
    public function catalogPacientesAction()
    {
    	$em = $this->getDoctrine()->getManager();
        $pag = $_POST["pagina"] * $_POST["cantidad"];
        
        //----------
        $medicoRepository = $em->getRepository("AdministradorBundle:Medico");
        $primer_medico = $medicoRepository->find($_POST["medico"]);
        $ids = "";
        if($primer_medico->getTipoHistorial() == true)
        {
            if($primer_medico->getTipoHistorial())
            {
                $institucion = $em->getRepository("AdministradorBundle:Institucion")->find($primer_medico->getIdInstitucion()->getId());
                $medicos = $medicoRepository->findBy(array("idInstitucion" => $institucion->getId()));
                if($medicos)
                {
                    foreach($medicos as $row)
                    {
                        //$ids .= ", ".$row->getId();
                $ids .= $row->getId().",";
                    }
            $ids = rtrim($ids, ",");
                }
            }
            else
               { $ids = $primer_medico->getId();}
            $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico in (".$ids.") order by u.apellido asc";
            $queryPag = "select count(p.id) from AdministradorBundle:Paciente p where p.idMedico in (".$ids.")";
            if($_POST["buscar"] != "")
            {
                $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico in (".$ids.") and (p.genero like '%".$_POST["buscar"]."%' or u.nombre like '%".$_POST["buscar"]."%' or u.apellido like '%".$_POST["buscar"]."%' or u.cedula like '%".$_POST["buscar"]."%' or p.ocupacion like '%".$_POST["buscar"]."%') order by u.apellido asc";
                $queryPag = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico in (".$ids.") and (p.genero like '%".$_POST["buscar"]."%' or u.nombre like '%".$_POST["buscar"]."%' or u.apellido like '%".$_POST["buscar"]."%' or u.cedula like '%".$_POST["buscar"]."%' or p.ocupacion like '%".$_POST["buscar"]."%' )";
            }
        }
        else{
            $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." order by u.apellido asc";
            $queryPag = "select count(p.id) from AdministradorBundle:Paciente p where p.idMedico = ".$_POST["medico"];
            if($_POST["buscar"] != "")
            {
                $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and p.genero like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.nombre like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.apellido like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.cedula like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and p.ocupacion like '%".$_POST["buscar"]."%' order by u.apellido asc";
                $queryPag = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and p.genero like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.nombre like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.apellido like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.cedula like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and p.ocupacion like '%".$_POST["buscar"]."%'";
            }
        }
        //--------

        /*$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." order by u.apellido asc";
        $queryPag = "select count(p.id) from AdministradorBundle:Paciente p where p.idMedico = ".$_POST["medico"];
        if($_POST["buscar"] != "")
        {
            $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and p.genero like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.nombre like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.apellido like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.cedula like '%".$_POST["buscar"]."%' order by u.apellido asc";
            $queryPag = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and p.genero like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.nombre like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.apellido like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.cedula like '%".$_POST["buscar"]."%'";
        }*/

        $pacientes = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
        $total = $em->createQuery($queryPag)->getSingleScalarResult();

    	/* $html = '<table class="table table-sm table-bordered" id="table_pacientes">
        <thead>
            <tr>
                <th width="15%"><label>Nombre</label></th>
                <th width="15%"><label>Cédula</label></th>
                <th width="15%"><label>Genero</label></th>
                <th width="20%"><label>Edad</label></th>
                <th width="15%"><label>Perfil</label></th>
                <th width="20%"><label>Opciones</label></th>
            </tr>
        </thead>
        <tbody>'; */
        $html = '<table class="table table-sm table-bordered" id="table_pacientes">
        <thead>
            <tr>
                <th width="20%"><label>Nombre</label></th>
                <th width="10%"><label>Cédula</label></th>
                <th width="10%"><label>Genero</label></th>
                <th width="10%"><label>Edad</label></th>
                <th width="15%"><label>Perfil</label></th>
                <th width="15%"><label>Ocupación</label></th>
                <th width="20%"><label>Opciones</label></th>
            </tr>
        </thead>
        <tbody>';

        if($pacientes)
        {
            foreach($pacientes as $row)
            {
                $perfil = "Completo";
                if($row->getIdUsuario()->getTelefono() == "" || $row->getIdUsuario()->getEmail() == "" || $row->getFechaNacimiento() == null || $row->getAseguradora() == "" ||  $row->getEstadoCivil() == "" ||  $row->getDireccion() == "" ||  $row->getSector() == "" ||  $row->getContacto() == "" ||  $row->getOcupacion() == "" ||  $row->getTelefono() == "")
                {
                    $perfil = "Incompleto";
                }

                $edad = "";
                if($row->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($row->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y')." años";
                }

                $html .= '<tr">
                    <td>'.$row->getIdUsuario()->getApellido().' '.$row->getIdUsuario()->getNombre().'</td>
                    <td>'.$row->getIdUsuario()->getCedula().'</td>
                    <td>'.$row->getGenero().'</td>
                    <td>'.$edad.'</td>
                    <td>'.$perfil.'</td>
                    <td>'.$row->getOcupacion().'</td>
                    <td>
                        <a href="#" name="'.base64_encode($row->getId()).'" class="btnEditar btn btn-sm btn-warning pad5">Editar</a>
                        <a class="btn btn-sm btn-info btnHc" href="./../historia/clinica/'.base64_encode($row->getId()).'/">Historia Clínica</a>
                    </td>
                </tr>';
            }
        }
        $html .= '</tbody></table>';

        $paginas = ceil($total / $_POST["cantidad"]);
        $start = (($_POST["pagina"] - 5) > 0 ) ? $_POST["pagina"] - 5 : 0;
        $end = (($_POST["pagina"] + 5) < $paginas) ? $_POST["pagina"] + 5 : ($paginas-1);

        $html .= '<div class="d100 paginacion"><nav aria-label="">
        <ul class="pagination">
            <li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
                <a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
                    <span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
                </a>
            </li>';
        if($start > 1)
        {
            $html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
        }

        for($i = $start; $i <= $end; $i++)
        {
            $html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
        }

        if($end < ($paginas-1))
        {
            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
            $html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
        }
        $html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
            <a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
                <span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
            </a>
        </li>
        </ul></nav></div>';

    	return new Response($html);
    }

    /**
     * @Route("/paciente/catalogo/responsive/", name="catalogoPacientesRes")
     */
    public function catalogPacientesResAction()
    {
    	$em = $this->getDoctrine()->getManager();

    	$pag = $_POST["pagina"] * $_POST["cantidad"];
    	
    	$medicoRepository = $em->getRepository("AdministradorBundle:Medico");
        $primer_medico = $medicoRepository->find($_POST["medico"]);
        $ids = "";
        if($primer_medico->getTipoHistorial() == true)
        {
            if($primer_medico->getTipoHistorial())
            {
                $institucion = $em->getRepository("AdministradorBundle:Institucion")->find($primer_medico->getIdInstitucion()->getId());
                $medicos = $medicoRepository->findBy(array("idInstitucion" => $institucion->getId()));
                if($medicos)
                {
                    foreach($medicos as $row)
                    {
                        //$ids .= ", ".$row->getId();
                $ids .= $row->getId().",";
                    }
            $ids = rtrim($ids, ",");
                }
            }
            else
               { $ids = $primer_medico->getId();}
            $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico in (".$ids.") order by u.apellido asc";
            $queryPag = "select count(p.id) from AdministradorBundle:Paciente p where p.idMedico in (".$ids.")";
            if($_POST["buscar"] != "")
            {
                $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico in (".$ids.") and (p.genero like '%".$_POST["buscar"]."%' or u.nombre like '%".$_POST["buscar"]."%' or u.apellido like '%".$_POST["buscar"]."%' or u.cedula like '%".$_POST["buscar"]."%') order by u.apellido asc";
                $queryPag = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico in (".$ids.") and (p.genero like '%".$_POST["buscar"]."%' or u.nombre like '%".$_POST["buscar"]."%' or u.apellido like '%".$_POST["buscar"]."%' or u.cedula like '%".$_POST["buscar"]."%')";
            }
        }
        else{
            $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." order by u.apellido asc";
            $queryPag = "select count(p.id) from AdministradorBundle:Paciente p where p.idMedico = ".$_POST["medico"];
            if($_POST["buscar"] != "")
            {
                $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and p.genero like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.nombre like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.apellido like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.cedula like '%".$_POST["buscar"]."%' order by u.apellido asc";
                $queryPag = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and p.genero like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.nombre like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.apellido like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.cedula like '%".$_POST["buscar"]."%'";
            }
        }
        
        /*$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." order by u.apellido asc";
        $queryPag = "select count(p.id) from AdministradorBundle:Paciente p where p.idMedico = ".$_POST["medico"];
        if($_POST["buscar"] != "")
        {
            $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and p.genero like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.nombre like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.apellido like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.cedula like '%".$_POST["buscar"]."%' order by u.apellido asc";
            $queryPag = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and p.genero like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.nombre like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.apellido like '%".$_POST["buscar"]."%' or p.idUsuario = u.id and p.idMedico = ".$_POST["medico"]." and u.cedula like '%".$_POST["buscar"]."%'";
        }*/

        $pacientes = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
        $total = $em->createQuery($queryPag)->getSingleScalarResult();

    	$html = '<table class="table table-sm table-bordered" id="table_pacientes_responsive">';

        if($pacientes)
        {
            foreach($pacientes as $row)
            {
                $perfil = "Completo";
                if($row->getIdUsuario()->getTelefono() == "" || $row->getIdUsuario()->getEmail() == "" || $row->getFechaNacimiento() == null || $row->getAseguradora() == "" ||  $row->getEstadoCivil() == "" ||  $row->getDireccion() == "" ||  $row->getSector() == "" ||  $row->getContacto() == "" ||  $row->getOcupacion() == "" ||  $row->getTelefono() == "")
                {
                    $perfil = "Incompleto";
                }

                $edad = "";
                if($row->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($row->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y')." años";
                }

                $html .= '<tbody>
                        <tr>
                            <th width="30%"><label>Nombre</label></th>
                            <td width="70%">'.$row->getIdUsuario()->getApellido().' '.$row->getIdUsuario()->getNombre().'</td>
                        </tr>
                        <tr>
                            <th width="30%"><label>Cédula</label></th>
                            <td width="70%">'.$row->getIdUsuario()->getCedula().'</td>
                        </tr>
                        <tr>
                            <th width="30%"><label>Género</label></th>
                            <td width="70%">'.$row->getGenero().'</td>
                        </tr>
                        <tr>
                            <th width="30%"><label>Edad</label></th>
                            <td width="70%">'.$edad.'</td>
                        </tr>
                        <tr>
                            <th width="30%"><label>Perfil</label></th>
                            <td width="70%">'.$perfil.'</td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <a href="#" name="'.base64_encode($row->getId()).'" class="btnEditar btn btn-warning">Editar</a>
                                <a class="btn btn-sm btn-info btnHc" href="./../historia/clinica/'.base64_encode($row->getId()).'/">Historia Clínica</a>
                            </td>
                        </tr>
                        </tbody>';
            }
        }
        $html .= '</table>';

        $paginas = ceil($total / $_POST["cantidad"]);
        $start = (($_POST["pagina"] - 3) > 0 ) ? $_POST["pagina"] - 3 : 0;
        $end = (($_POST["pagina"] + 3) < $paginas) ? $_POST["pagina"] + 3 : ($paginas-1);

        $html .= '<div class="d100 paginacion_responsive"><nav aria-label="">
        <ul class="pagination">
            <li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
                <a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
                    <span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
                </a>
            </li>';
        if($start > 1)
        {
            $html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
        }

        for($i = $start; $i <= $end; $i++)
        {
            $html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
        }

        if($end < ($paginas-1))
        {
            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
            $html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
        }
        $html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
            <a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
                <span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
            </a>
        </li></ul></nav></div>';

    	return new Response($html);
    }

    /**
     * @Route("/dias/laborables/")
     */
    public function readDiasLaborablesAction()
    {
    	$em = $this->getDoctrine()->getManager();
    	$dias = $em->getRepository("AgendaBundle:DiasLaborables")->findAll();
    	$html = "";

        foreach($dias as $row)
        {
            $html .= '<div class="d100" id="'.$row->getId().'">
                        <div class="d25 pad5 text-right">
                            <label>'.$row->getNombre().'</label>
                        </div>
                        <div class="d75 pad5">
                            <div class="d100">
                                <input type="hidden" id="inputHorario'.$row->getId().'">
                                <select disabled class="cmbHoraInicio" id="cmbHoraInicio'.$row->getId().'">';
                    for($i = 0; $i < 24; $i++)
                    {
                        for ($j = 0; $j < 2; $j++)
                        {
                            if($j == 0)
                                $html .= '<option value="'.$i.':00">'.$i.':00</option>';
                            else
                                $html .= '<option value="'.$i.':30">'.$i.':30</option>';
                        }
                    }
                $html .=        '</select>
                                &nbsp;
                                <label>a</label>
                                &nbsp;
                                <select disabled class="cmbHoraFin" id="cmbHoraFin'.$row->getId().'">';
                    for($i = 0; $i < 24; $i++)
                    {
                        for ($j = 0; $j < 2; $j++)
                        {
                            if($j == 0)
                                $html .= '<option value="'.$i.':00">'.$i.':00</option>';
                            else
                                $html .= '<option value="'.$i.':30">'.$i.':30</option>';
                        }
                    }
                $html .=        '</select>
                                &nbsp;
                                <input type="checkbox" class="chkHorario" id="chkHorario'.$row->getId().'">
                                <label class="btn btn-link pad0 icon-plus btnNHorario" title="Agregar Segundo Horario"></label>
                            </div>
                            <div class="d100 d0 divSegundoHorario">
                                <input type="hidden" id="input2Horario'.$row->getId().'">
                                <select disabled class="cmbHoraInicio" id="cmb2HoraInicio'.$row->getId().'">';
                for($i = 0; $i < 24; $i++)
                {
                    for ($j = 0; $j < 2; $j++)
                    {
                        if($j == 0)
                            $html .= '<option value="'.$i.':00">'.$i.':00</option>';
                        else
                            $html .= '<option value="'.$i.':30">'.$i.':30</option>';
                    }
                }
                $html .=        '</select>
                            &nbsp;
                            <label>a</label>
                            &nbsp;
                            <select disabled class="cmbHoraFin" id="cmb2HoraFin'.$row->getId().'">';
                for($i = 0; $i < 24; $i++)
                {
                    for ($j = 0; $j < 2; $j++)
                    {
                        if($j == 0)
                            $html .= '<option value="'.$i.':00">'.$i.':00</option>';
                        else
                            $html .= '<option value="'.$i.':30">'.$i.':30</option>';
                    }
                }
                $html .=    '</select>
                            &nbsp;
                            <input type="checkbox" class="chkHorario" id="chk2Horario'.$row->getId().'">
                            </div>
                        </div>
                    </div>';
        }
    	$html .= '<div class="d100 pad5">
					<div class="d30 pad5 text-right"><label>Tiempo entre consultas</label></div>
                    <div class="d70 pad5">
                        <select id="cmbMinutos" class="pad5">
                            <option value="5">5 minutos</option>
                            <option value="10">10 minutos</option>
                            <option value="15">15 minutos</option>
                            <option value="20">20 minutos</option>
                            <option value="30">30 minutos</option>
                            <option value="60">60 minutos</option>
                        </select>
                    </div>
				</div>';
    	return new Response($html);
    }

    /**
     * @Route("/horario/medico/")
     */
    public function readHorarioMedicoAction()
    {
    	$em = $this->getDoctrine()->getManager();
    	$horario = $em->getRepository("AgendaBundle:HorariosLaborables")->findBy(array("idAgenda" => $_POST["agenda"], "estado" => true), array("idDiasLaborables" => "ASC", "orden" => "ASC"));

    	$html = '<table class="table table-bordered"><tbody>';
    	if($horario)
    	{
    		foreach($horario as $row)
    		{
    			$html .= '
                        <tr>
                            <td>'.$row->getIdDiasLaborables()->getNombre().'</td>
                            <td>'.$row->getHoraInicio().'</td>
                            <td>'.$row->getHoraFin().'</td>
                        </tr>';
    		}
            $html .= '</tbody></table>';
            $html .= '<input type="hidden" id="inputExisteHorario" value="1">';
    	}
        else
        {
            $html .= '<input type="hidden" id="inputExisteHorario" value="0">';
        }

    	return new Response($html);
    }

    /**
     * @Route("/horario/medico/dia/")
     */
    public function readHorarioMedicoDiaAction()
    {
    	$em = $this->getDoctrine()->getManager();
        $pfecha = date("Y-m-d");
        if($_POST["fecha"] != "")
            $pfecha = $_POST["fecha"];

        $dia = date("N", strtotime($pfecha));
    	$horario = $em->getRepository("AgendaBundle:HorariosLaborables")->findBy(array("idAgenda" => $_POST["agenda"], "idDiasLaborables" => $dia, "estado" => true), array("orden" => "ASC"));

    	$html = "";
    	if(!$horario)
    	{
    		$html .= '<div class="d100 dcentro pad20">
                        <button class="btn btn-primary" id="btnAgregarHorario">Agregar días y horarios de atención del médico</button>
                    </div>';
    	}
    	else
    	{
            foreach($horario as $row)
            {
                $atencion = $em->getRepository("AgendaBundle:AgendaHL")->findBy(array("idHorarioLaborable" => $row->getId()), array("idHorarioLaborable" => "ASC", "id" => "ASC"));

                foreach($atencion as $fila)
                {
                    $citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->findOneBy(array("idAgenda" => $_POST["agenda"], "fecha" => $pfecha, "hora" => $fila->getHora()));
                    if($citaMedica)
                    {
                        if($citaMedica->getIdEstadoCita()->getId() != 4){
                            $tooltip = "Teléfono: ".$citaMedica->getIdPaciente()->getTelefono()." Celular: ".$citaMedica->getIdPaciente()->getIdUsuario()->getTelefono()." Observación: ".$citaMedica->getObservacion() ." Email: ".$citaMedica->getIdPaciente()->getIdUsuario()->getEmail();

                            $asignado = '<div class="d100 dcentro asignado" title="'.$tooltip.'" id="'.base64_encode($citaMedica->getIdPaciente()->getId()).'" accesskey="'.base64_encode($citaMedica->getId()).'" data-tel="'.base64_encode($citaMedica->getIdPaciente()->getTelefono()).'" data-cel="'.base64_encode($citaMedica->getIdPaciente()->getIdUsuario()->getTelefono()).'" data-obs="'.base64_encode($citaMedica->getObservacion()).'" data-mail="'.base64_encode($citaMedica->getIdPaciente()->getIdUsuario()->getEmail()).'">'.$citaMedica->getIdPaciente()->getIdUsuario()->getApellido().' '.$citaMedica->getIdPaciente()->getIdUsuario()->getNombre().' - '.$citaMedica->getIdEspecialidad()->getNombre().'</div>';
                        } 
                    }
                    else
                    {
                        $asignado = "";
                    }

                    $html .= '<div class="d50 pad5-v dcentro">
                                <div class="d20 pad5 text-right"><label>'.$fila->getHora().'</label></div>
                                <div class="d80 pad5"><div class="d100 mar0 pad5 '.(($asignado == "" ? "horario" : "ocupado")).'" id="'.$fila->getId().'">'.$asignado.'</div></div>
                            </div>';
                }
            }
    	}
    	return new Response($html);
    }

    /**
     * @Route("/horario/estado/", name="estadoHorarioL")
     */
    public function updateEstadoHorarioL()
    {
        $em = $this->getDoctrine()->getManager();
        $horarioL = $em->getRepository("AgendaBundle:HorariosLaborables")->find($_POST["idHorario"]);
        if($horarioL)
        {
            if($_POST["estado"] == 1)
                $horarioL->setEstado(true);
            else
                $horarioL->setEstado(false);

            $em->flush();
            return new Response("ok");
        }
        else
        {
            return new Response("nok");
        }
    }

    /**
     * @Route("/citamedica/pdf/{idMedico}/{fecha}", name="agendaPDF")
     */
    public function agendaPdfAction(Request $request, $idMedico="", $fecha="")
    {
        $em = $this->getDoctrine()->getManager();

        if($fecha == "hoy")
            $fecha = date("Y-m-d");

        $agenda = $em->getRepository("AgendaBundle:Agenda")->findOneBy(array("idMedico" => $idMedico));
        $citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->findBy(array("idAgenda" => $agenda->getId(), "fecha" => $fecha), array("hora" => "ASC"));

        $html = $this->renderView("@Agenda/PDF/agenda.html.twig", array(
            "agenda" => $agenda,
            "citaMedica" => $citaMedica
        ));

        return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html), $fecha.'-'.md5($agenda->getId()).'-agenda-medica.pdf');
    }

    /**
     * @Route("/paciente/buscar/", name="buscarPacienteAgenda")
     */
    public function agendaBuscarPaciente()
    {
        $em = $this->getDoctrine()->getManager();

       /* $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where u.id = p.idUsuario and p.idMedico = :medico and (u.cedula like :cedula or lower(u.apellido) like :apellido)";
        $paciente = $em->createQuery($query)->setParameter("medico", $_POST["idMedico"])->setParameter("cedula", "%".$_POST["buscar"]."%")->setParameter("apellido", strtolower("%".$_POST["buscar"]."%"))->getResult(); */

        /* ******** */
        $medicoRepository = $em->getRepository("AdministradorBundle:Medico");
        $primer_medico = $medicoRepository->find($_POST["idMedico"]);
        $ids = "0";
        if($primer_medico->getTipoHistorial() == true){ 
            if($primer_medico->getTipoHistorial())
            {
                $institucion = $em->getRepository("AdministradorBundle:Institucion")->find($primer_medico->getIdInstitucion()->getId());
                $medicos = $medicoRepository->findBy(array("idInstitucion" => $institucion->getId()));
                if($medicos)
                {
                    foreach($medicos as $row)
                    {
                        $ids .= ", ".$row->getId();
                    }
                }
            }
            else
                $ids = $primer_medico->getId();
            $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where u.id = p.idUsuario and p.idMedico in (".$ids.") and (u.cedula like :cedula or lower(u.apellido) like :apellido)";
            $paciente = $em->createQuery($query)->setParameter("cedula", "%".$_POST["buscar"]."%")->setParameter("apellido", strtolower("%".$_POST["buscar"]."%"))->getResult();
            //$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where u.id = p.idUsuario and p.idMedico in (".$ids.") and (u.cedula like :cedula or u.apellido like :apellido)";
            //$paciente = $em->createQuery($query)->setParameter("cedula", "%".$_POST["buscar"]."%")->setParameter("apellido", "%".$_POST["buscar"]."%")->getResult();
            
        }
        else{
            $query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where u.id = p.idUsuario and p.idMedico = :medico and (u.cedula like :cedula or lower(u.apellido) like :apellido)";
            $paciente = $em->createQuery($query)->setParameter("medico", $_POST["idMedico"])->setParameter("cedula", "%".$_POST["buscar"]."%")->setParameter("apellido", strtolower("%".$_POST["buscar"]."%"))->getResult();
            //$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where u.id = p.idUsuario and p.idMedico = :medico and (u.cedula like :cedula or u.apellido like :apellido)";
            //$paciente = $em->createQuery($query)->setParameter("medico", $_POST["idMedico"])->setParameter("cedula", "%".$_POST["buscar"]."%")->setParameter("apellido", "%".$_POST["buscar"]."%")->getResult();
        }/* ******** */

        $html = '';
        if($paciente)
        {
            $html .= '<table class="table">
            <thead>
                <tr><th>Paciente</th><th>Identificación</th><th>Genero</th><th>Edad</th><th></th></tr>
            </thead><tbody>';
            foreach($paciente as $row)
            {
                $edad = "";
                if($row->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($row->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y')." años";
                }
                $html .= '<tr>
                    <td>'.$row->getIdUsuario()->getApellido().' '.$row->getIdUsuario()->getNombre().'</td>
                    <td>'.$row->getIdUsuario()->getCedula().'</td>
                    <td>'.$row->getGenero().'</td>
                    <td>'.$edad.'</td>
                    <td><button id="'.base64_encode($row->getId()).'" name="'.$row->getIdUsuario()->getApellido().' '.$row->getIdUsuario()->getNombre().'" class="btn btn-link btn-sm btnSelectPaciente">Seleccionar</button></td>
                </tr>';
            }
            $html .= '</tbody></table>';
        }
        else
        {
            $html .= '<div class="row">
                <div class="col-sm-12 text-center">No existe paciente con los datos ingresados</div>
            </div>';
        }

        return new Response($html);
    }
}
