<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PeriodoLicencia
 *
 * @ORM\Table(name="periodo_licencia")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\PeriodoLicenciaRepository")
 */
class PeriodoLicencia
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_periodo_licencia", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="Medico", mappedBy="mesesLicencia")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="numero_dias_licencia_medico", type="integer")
     */
    private $numeroDias;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_periodo_licencia", type="string", length=50)
     */
    private $nombre;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_periodo_licencia", type="boolean")
     */
    private $estado;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set numeroDias
     *
     * @param integer $numeroDias
     *
     * @return PeriodoLicencia
     */
    public function setNumeroDias($numeroDias)
    {
        $this->numeroDias = $numeroDias;

        return $this;
    }

    /**
     * Get numeroDias
     *
     * @return int
     */
    public function getNumeroDias()
    {
        return $this->numeroDias;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return PeriodoLicencia
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return PeriodoLicencia
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }
}

