<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Parroquias
 *
 * @ORM\Table(name="parroquias")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\ParroquiasRepository")
 */
class Parroquias
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_parroquia", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="Paciente", mappedBy="idParroquia")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Cantones")
     * @ORM\JoinColumn(name="id_canton", referencedColumnName="id_canton")
     */
    private $idCanton;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_parroquia", type="string", length=10, unique=true)
     */
    private $codigo;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_parroquia", type="string", length=50)
     */
    private $nombre;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_parroquia", type="boolean")
     */
    private $estado;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idCanton
     *
     * @param integer $idCanton
     *
     * @return Parroquias
     */
    public function setIdCanton($idCanton)
    {
        $this->idCanton = $idCanton;

        return $this;
    }

    /**
     * Get idCanton
     *
     * @return int
     */
    public function getIdCanton()
    {
        return $this->idCanton;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return Parroquias
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return Parroquias
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return Parroquias
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }
}

