<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Paciente
 *
 * @ORM\Table(name="paciente")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\PacienteRepository")
 */
class Paciente
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_paciente", type="integer")
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="LoginBundle\Entity\Usuario", mappedBy="idPaciente")
     * @ORM\OneToMany(targetEntity="AgendaBundle\Entity\CitaMedica", mappedBy="idPaciente")
     * @ORM\OneToOne(targetEntity="AgendaBundle\Entity\HistoriaClinica", mappedBy="idPaciente")
     * @ORM\OneToOne(targetEntity="AgendaBundle\Entity\AntecedentesPersonales", mappedBy="idPaciente")
     * @ORM\OneToOne(targetEntity="AgendaBundle\Entity\AntecedentesFamiliares", mappedBy="idPaciente")
     * @ORM\OneToMany(targetEntity="AgendaBundle\Entity\ImagenVideoEspecialidad", mappedBy="idPaciente")
     * @ORM\OneToMany(targetEntity="AgendaBundle\Entity\Formulario024", mappedBy="idPaciente")
     * @ORM\OneToOne(targetEntity="AgendaBundle\Entity\AntecedentesGinecobstetricos", mappedBy="idPaciente")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \int
     *
     * @ORM\OneToOne(targetEntity="LoginBundle\Entity\Usuario")
     * @ORM\JoinColumn(name="id_usuario", referencedColumnName="id_usuario")
     */
    private $idUsuario;

    /**
     * @var \string
     *
     * @ORM\Column(name="fecha_nacimiento_paciente", type="string", length=20)
     */
    private $fechaNacimiento;

    /**
     * @var string
     *
     * @ORM\Column(name="genero_paciente", type="string", length=20)
     */
    private $genero;

    /**
     * @var string
     *
     * @ORM\Column(name="estado_civil_paciente", type="string", length=20)
     */
    private $estadoCivil;

    /**
     * @var string
     *
     * @ORM\Column(name="direccion_paciente", type="string", length=80)
     */
    private $direccion;

    /**
     * @var string
     *
     * @ORM\Column(name="sector_vivienda_paciente", type="string", length=40)
     */
    private $sector;

    /**
     * @var string
     *
     * @ORM\Column(name="contacto_paciente", type="string", length=60)
     */
    private $contacto;

    /**
     * @var string
     *
     * @ORM\Column(name="ocupacion_paciente", type="string", length=40)
     */
    private $ocupacion;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico")
     */
    private $idMedico;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Parroquias")
     * @ORM\JoinColumn(name="id_parroquia", referencedColumnName="id_parroquia")
     */
    private $idParroquia;

    /**
     * @var string
     *
     * @ORM\Column(name="aseguradora_paciente", type="string", length=20)
     */
    private $aseguradora;

    /**
     * @var string
     *
     * @ORM\Column(name="telefono_paciente", type="string", length=20)
     */
    private $telefono;

    /**
     * @var \string
     *
     * @ORM\Column(name="fecha_registro", type="string", length=20)
     */
    private $fechaRegistro;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idUsuario
     *
     * @param \int $idUsuario
     *
     * @return Paciente
     */
    public function setIdUsuario($idUsuario)
    {
        $this->idUsuario = $idUsuario;

        return $this;
    }

    /**
     * Get idUsuario
     *
     * @return \int
     */
    public function getIdUsuario()
    {
        return $this->idUsuario;
    }

    /**
     * Set fechaNacimiento
     *
     * @param \string $fechaNacimiento
     *
     * @return Paciente
     */
    public function setFechaNacimiento($fechaNacimiento)
    {
        $this->fechaNacimiento = $fechaNacimiento;

        return $this;
    }

    /**
     * Get fechaNacimiento
     *
     * @return \string
     */
    public function getFechaNacimiento()
    {
        return $this->fechaNacimiento;
    }

    /**
     * Set genero
     *
     * @param string $genero
     *
     * @return Paciente
     */
    public function setGenero($genero)
    {
        $this->genero = $genero;

        return $this;
    }

    /**
     * Get genero
     *
     * @return string
     */
    public function getGenero()
    {
        return $this->genero;
    }

    /**
     * Set estadoCivil
     *
     * @param string $estadoCivil
     *
     * @return Paciente
     */
    public function setEstadoCivil($estadoCivil)
    {
        $this->estadoCivil = $estadoCivil;

        return $this;
    }

    /**
     * Get estadoCivil
     *
     * @return string
     */
    public function getEstadoCivil()
    {
        return $this->estadoCivil;
    }

    /**
     * Set direccion
     *
     * @param string $direccion
     *
     * @return Paciente
     */
    public function setDireccion($direccion)
    {
        $this->direccion = $direccion;

        return $this;
    }

    /**
     * Get direccion
     *
     * @return string
     */
    public function getDireccion()
    {
        return $this->direccion;
    }

    /**
     * Set sector
     *
     * @param string $sector
     *
     * @return Paciente
     */
    public function setSector($sector)
    {
        $this->sector = $sector;

        return $this;
    }

    /**
     * Get sector
     *
     * @return string
     */
    public function getSector()
    {
        return $this->sector;
    }

    /**
     * Set contacto
     *
     * @param string $contacto
     *
     * @return Paciente
     */
    public function setContacto($contacto)
    {
        $this->contacto = $contacto;

        return $this;
    }

    /**
     * Get contacto
     *
     * @return string
     */
    public function getContacto()
    {
        return $this->contacto;
    }

    /**
     * Set ocupacion
     *
     * @param string $ocupacion
     *
     * @return Paciente
     */
    public function setOcupacion($ocupacion)
    {
        $this->ocupacion = $ocupacion;

        return $this;
    }

    /**
     * Get ocupacion
     *
     * @return string
     */
    public function getOcupacion()
    {
        return $this->ocupacion;
    }

    /**
     * Set idMedico
     *
     * @param \int $idMedico
     *
     * @return Paciente
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;

        return $this;
    }

    /**
     * Get idMedico
     *
     * @return \int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    /**
     * Set idParroquia
     *
     * @param \int $idParroquia
     *
     * @return Paciente
     */
    public function setIdParroquia($idParroquia)
    {
        $this->idParroquia = $idParroquia;

        return $this;
    }

    /**
     * Get idParroquia
     *
     * @return \int
     */
    public function getIdParroquia()
    {
        return $this->idParroquia;
    }

    /**
     * Set aseguradora
     *
     * @param string $aseguradora
     *
     * @return Paciente
     */
    public function setAseguradora($aseguradora)
    {
        $this->aseguradora = $aseguradora;

        return $this;
    }

    /**
     * Get aseguradora
     *
     * @return string
     */
    public function getAseguradora()
    {
        return $this->aseguradora;
    }

    /**
     * Set telefono
     *
     * @param string $telefono
     *
     * @return Paciente
     */
    public function setTelefono($telefono)
    {
        $this->telefono = $telefono;

        return $this;
    }

    /**
     * Get telefono
     *
     * @return string
     */
    public function getTelefono()
    {
        return $this->telefono;
    }

    /**
     * Set fechaRegistro
     *
     * @param \string $fechaRegistro
     *
     * @return Paciente
     */
    public function setFechaRegistro($fechaRegistro)
    {
        $this->fechaRegistro = $fechaRegistro;

        return $this;
    }

    /**
     * Get fechaRegistro
     *
     * @return \string
     */
    public function getFechaRegistro()
    {
        return $this->fechaRegistro;
    }
}

