<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Noticas
 *
 * @ORM\Table(name="noticias")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\NoticasRepository")
 */
class Noticas
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_noticia", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="titulo_noticia", type="string", length=200)
     */
    private $titulo;

    /**
     * @var string
     *
     * @ORM\Column(name="texto_noticia", type="text")
     */
    private $texto;

    /**
     * @var string
     *
     * @ORM\Column(name="imagen_noticia", type="string", length=200, nullable=true)
     */
    private $imagen;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_noticia", type="string", length=20)
     */
    private $fecha;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Administrador")
     * @ORM\JoinColumn(name="id_administrador", referencedColumnName="id_administrador")
     */
    private $idAdministrador;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_noticia", type="boolean")
     */
    private $estado;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set titulo
     *
     * @param string $titulo
     *
     * @return Noticas
     */
    public function setTitulo($titulo)
    {
        $this->titulo = $titulo;

        return $this;
    }

    /**
     * Get titulo
     *
     * @return string
     */
    public function getTitulo()
    {
        return $this->titulo;
    }

    /**
     * Set texto
     *
     * @param string $texto
     *
     * @return Noticas
     */
    public function setTexto($texto)
    {
        $this->texto = $texto;

        return $this;
    }

    /**
     * Get texto
     *
     * @return string
     */
    public function getTexto()
    {
        return $this->texto;
    }

    /**
     * Set imagen
     *
     * @param string $imagen
     *
     * @return Noticas
     */
    public function setImagen($imagen)
    {
        $this->imagen = $imagen;

        return $this;
    }

    /**
     * Get imagen
     *
     * @return string
     */
    public function getImagen()
    {
        return $this->imagen;
    }

    /**
     * Set fecha
     *
     * @param string $fecha
     *
     * @return Noticas
     */
    public function setFecha($fecha)
    {
        $this->fecha = $fecha;

        return $this;
    }

    /**
     * Get fecha
     *
     * @return string
     */
    public function getFecha()
    {
        return $this->fecha;
    }

    /**
     * Set idAdministrador
     *
     * @param integer $idAdministrador
     *
     * @return Noticas
     */
    public function setIdAdministrador($idAdministrador)
    {
        $this->idAdministrador = $idAdministrador;

        return $this;
    }

    /**
     * Get idAdministrador
     *
     * @return int
     */
    public function getIdAdministrador()
    {
        return $this->idAdministrador;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return Noticas
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }
}

