<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * MedicoEspecialidad
 *
 * @ORM\Table(name="medico_especialidad")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\MedicoEspecialidadRepository")
 */
class MedicoEspecialidad
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_medico_especialidad", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Especialidades")
     * @ORM\JoinColumn(name="id_especialidad", referencedColumnName="id_especialidad")
     */
    private $idEspecialidad;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico")
     */
    private $idMedico;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idEspecialidad
     *
     * @param integer $idEspecialidad
     *
     * @return MedicoEspecialidad
     */
    public function setIdEspecialidad($idEspecialidad)
    {
        $this->idEspecialidad = $idEspecialidad;

        return $this;
    }

    /**
     * Get idEspecialidad
     *
     * @return int
     */
    public function getIdEspecialidad()
    {
        return $this->idEspecialidad;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return MedicoEspecialidad
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;

        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }
}

