<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Medico
 *
 * @ORM\Table(name="medico")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\MedicoRepository")
 */
class Medico
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_medico", type="integer")
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="LoginBundle\Entity\Usuario", mappedBy="idMedico")
     * @ORM\OneToMany(targetEntity="MedicoEspecialidad", mappedBy="idMedico")
     * @ORM\OneToMany(targetEntity="AsistenteMedico", mappedBy="idMedico")
     * @ORM\OneToMany(targetEntity="Paciente", mappedBy="idMedico")
     * @ORM\OneToOne(targetEntity="AgendaBundle\Entity\Agenda", mappedBy="idMedico")
     * @ORM\OneToMany(targetEntity="AgendaBundle\Entity\ResumenHistoriaClinica", mappedBy="idMedico")
     * @ORM\OneToMany(targetEntity="ChatPromocion", mappedBy="idMedico")
     * @ORM\OneToOne(targetEntity="AgendaBundle\Entity\Documentos", mappedBy="idMedico")
     * @ORM\OneToMany(targetEntity="AgendaBundle\Entity\Formulario024", mappedBy="idMedico")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \int
     *
     * @ORM\OneToOne(targetEntity="LoginBundle\Entity\Usuario")
     * @ORM\JoinColumn(name="id_usuario", referencedColumnName="id_usuario")
     */
    private $idUsuario;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_medico", type="string", length=30)
     */
    private $codigo;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_registro_medico", type="string", length=50)
     */
    private $fechaRegistro;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_caducidad_medico", type="string", length=50)
     */
    private $fechaCaducidad;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="PeriodoLicencia")
     * @ORM\JoinColumn(name="id_periodo_licencia", referencedColumnName="id_periodo_licencia")
     */
    private $periodoLicencia;

    /**
     * @var bool
     *
     * @ORM\Column(name="tiene_asistente", type="boolean")
     */
    private $asistente;

    /**
     * @var string
     *
     * @ORM\Column(name="url_logo_medico", type="text", nullable=true)
     */
    private $urlImagen;

    /**
     * @var string
     *
     * @ORM\Column(name="img_base", type="text", nullable=true)
     */
    private $imagen;

    /**
     * @var string
     *
     * @ORM\Column(name="direccion_medico", type="string", length=150, nullable=true)
     */
    private $direccion;

    /**
     * @var bool
     *
     * @ORM\Column(name="factura_medico", type="boolean")
     */
    private $factura;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_comercial", type="string", length=200)
     */
    private $nombreComercial;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Institucion")
     * @ORM\JoinColumn(name="id_institucion", referencedColumnName="id_institucion", nullable=true)
     */
    private $idInstitucion;

    /**
     * @var bool
     *
     * @ORM\Column(name="tipo_historial_medico", type="boolean")
     */
    private $tipoHistorial;
    
    /**
     * @var string
     *
     * @ORM\Column(name="url_imagen_agenda", type="text", nullable=true)
     */
    private $urlImgAgenda;

    /**
     * @var string
     *
     * @ORM\Column(name="provincia_medico", type="string", length=50)
     */
    private $provincia;

     /**
     * @var int
     *
     * @ORM\Column(name="numero_receta", type="integer")
     */
    private $numeroReceta;

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idUsuario
     *
     * @param \int $idUsuario
     *
     * @return Medico
     */
    public function setIdUsuario($idUsuario)
    {
        $this->idUsuario = $idUsuario;

        return $this;
    }

    /**
     * Get idUsuario
     *
     * @return \int
     */
    public function getIdUsuario()
    {
        return $this->idUsuario;
    }


    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return Medico
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set fechaRegistro
     *
     * @param string $fechaRegistro
     *
     * @return Medico
     */
    public function setFechaRegistro($fechaRegistro)
    {
        $this->fechaRegistro = $fechaRegistro;

        return $this;
    }

    /**
     * Get fechaRegistro
     *
     * @return string
     */
    public function getFechaRegistro()
    {
        return $this->fechaRegistro;
    }

    /**
     * Set fechaCaducidad
     *
     * @param string $fechaCaducidad
     *
     * @return Medico
     */
    public function setFechaCaducidad($fechaCaducidad)
    {
        $this->fechaCaducidad = $fechaCaducidad;

        return $this;
    }

    /**
     * Get fechaCaducidad
     *
     * @return string
     */
    public function getFechaCaducidad()
    {
        return $this->fechaCaducidad;
    }

    /**
     * Set periodoLicencia
     *
     * @param integer $periodoLicencia
     *
     * @return Medico
     */
    public function setPeriodoLicencia($periodoLicencia)
    {
        $this->periodoLicencia = $periodoLicencia;

        return $this;
    }

    /**
     * Get periodoLicencia
     *
     * @return int
     */
    public function getPeriodoLicencia()
    {
        return $this->periodoLicencia;
    }

    /**
     * Set asistente
     *
     * @param boolean $asistente
     *
     * @return Medico
     */
    public function setAsistente($asistente)
    {
        $this->asistente = $asistente;

        return $this;
    }

    /**
     * Get asistente
     *
     * @return bool
     */
    public function getAsistente()
    {
        return $this->asistente;
    }

    /**
     * Set urlImagen
     *
     * @param string $urlImagen
     *
     * @return Medico
     */
    public function setUrlImagen($urlImagen)
    {
        $this->urlImagen = $urlImagen;

        return $this;
    }

    /**
     * Get urlImagen
     *
     * @return string
     */
    public function getUrlImagen()
    {
        return $this->urlImagen;
    }
    
    /**
     * Set urlImgAgenda
     *
     * @param string $urlImgAgenda
     *
     * @return Medico
     */
    public function setUrlImgAgenda($urlImgAgenda)
    {
        $this->urlImgAgenda = $urlImgAgenda;

        return $this;
    }

    /**
     * Get urlImgAgenda
     *
     * @return string
     */
    public function getUrlImgAgenda()
    {
        return $this->urlImgAgenda;
    }

    /**
     * Set imagen
     *
     * @param string $imagen
     *
     * @return Medico
     */
    public function setImagen($imagen)
    {
        $this->imagen = $imagen;

        return $this;
    }

    /**
     * Get imagen
     *
     * @return string
     */
    public function getImagen()
    {
        return $this->imagen;
    }

    /**
     * Set direccion
     *
     * @param string $direccion
     *
     * @return Medico
     */
    public function setDireccion($direccion)
    {
        $this->direccion = $direccion;

        return $this;
    }

    /**
     * Get direccion
     *
     * @return string
     */
    public function getDireccion()
    {
        return $this->direccion;
    }

    /**
     * Set factura
     *
     * @param boolean $factura
     *
     * @return Medico
     */
    public function setFactura($factura)
    {
        $this->factura = $factura;

        return $this;
    }

    /**
     * Get factura
     *
     * @return bool
     */
    public function getFactura()
    {
        return $this->factura;
    }

    /**
     * Set nombreComercial
     *
     * @param string $nombreComercial
     *
     * @return Medico
     */
    public function setNombreComercial($nombreComercial)
    {
        $this->nombreComercial = $nombreComercial;

        return $this;
    }

    /**
     * Get nombreComercial
     *
     * @return string
     */
    public function getNombreComercial()
    {
        return $this->nombreComercial;
    }

    /**
     * Set idInstitucion
     *
     * @param integer $idInstitucion
     *
     * @return Medico
     */
    public function setIdInstitucion($idInstitucion)
    {
        $this->idInstitucion = $idInstitucion;

        return $this;
    }

    /**
     * Get idInstitucion
     *
     * @return int
     */
    public function getIdInstitucion()
    {
        return $this->idInstitucion;
    }
    
    /**
     * Set tipoHistorial
     *
     * @param boolean $tipoHistorial
     *
     * @return Medico
     */
    public function setTipoHistorial($tipoHistorial)
    {
        $this->tipoHistorial = $tipoHistorial;
        return $this;
    }
    /**
     * Get tipoHistorial
     *
     * @return bool
     */
    public function getTipoHistorial()
    {
        return $this->tipoHistorial;
    }
    
    /**
     * Set provincia
     *
     * @param string $provincia
     *
     * @return Medico
     */
    public function setProvincia($provincia)
    {
        $this->provincia = $provincia;

        return $this;
    }

    /**
     * Get provincia
     *
     * @return string
     */
    public function getProvincia()
    {
        return $this->provincia;
    }
    
    /**
     * Set numeroReceta
     *
     * @param integer $numeroReceta
     *
     * @return Medico
     */
    public function setNumeroReceta($numeroReceta)
    {
        $this->numeroReceta = $numeroReceta;
        return $this;
    }

    /**
     * Get numeroReceta
     *
     * @return int
     */
    public function getNumeroReceta()
    {
        return $this->numeroReceta;
    }
}

