<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Institucion
 *
 * @ORM\Table(name="institucion")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\InstitucionRepository")
 */
class Institucion
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_institucion", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="Medico", mappedBy="idInstitucion")
     * @ORM\OneToMany(targetEntity="FacturacionBundle\Entity\Factura", mappedBy="idInstitucion")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="razon_social", type="string", length=200)
     */
    private $razonSocial;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_comercial", type="string", length=200)
     */
    private $nombreComercial;

    /**
     * @var string
     *
     * @ORM\Column(name="ruc_institucion", type="string", length=15, nullable=true)
     */
    private $ruc;

    /**
     * @var string
     *
     * @ORM\Column(name="telefono_institucion", type="string", length=15)
     */
    private $telefono;

    /**
     * @var string
     *
     * @ORM\Column(name="celular_institucion", type="string", length=15)
     */
    private $celular;

    /**
     * @var string
     *
     * @ORM\Column(name="email_institucion", type="string", length=200)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="numero_estable", type="string", length=3)
     */
    private $numeroEstabl;

    /**
     * @var string
     *
     * @ORM\Column(name="punto_emision", type="string", length=3)
     */
    private $puntoEmision;

    /**
     * @var string
     *
     * @ORM\Column(name="direccion_matriz", type="string", length=300)
     */
    private $direccionMatriz;

    /**
     * @var string
     *
     * @ORM\Column(name="direccion_establ", type="string", length=300)
     */
    private $direccionEstabl;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_contribuyente", type="string", length=15)
     */
    private $tipoContribuyente;

    /**
     * @var string
     *
     * @ORM\Column(name="nro_contribuyente", type="string", length=10)
     */
    private $nroContribuyente;

    /**
     * @var string
     *
     * @ORM\Column(name="obl_contabilidad", type="string", length=3)
     */
    private $oblContabilidad;

    /**
     * @var string
     *
     * @ORM\Column(name="firma_electronica", type="string", length=250)
     */
    private $firmaElectronica;

    /**
     * @var string
     *
     * @ORM\Column(name="clave_firma", type="string", length=250)
     */
    private $claveFirma;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set razonSocial
     *
     * @param string $razonSocial
     *
     * @return Institucion
     */
    public function setRazonSocial($razonSocial)
    {
        $this->razonSocial = $razonSocial;

        return $this;
    }

    /**
     * Get razonSocial
     *
     * @return string
     */
    public function getRazonSocial()
    {
        return $this->razonSocial;
    }

    /**
     * Set nombreComercial
     *
     * @param string $nombreComercial
     *
     * @return Institucion
     */
    public function setNombreComercial($nombreComercial)
    {
        $this->nombreComercial = $nombreComercial;

        return $this;
    }

    /**
     * Get nombreComercial
     *
     * @return string
     */
    public function getNombreComercial()
    {
        return $this->nombreComercial;
    }

    /**
     * Set ruc
     *
     * @param string $ruc
     *
     * @return Institucion
     */
    public function setRuc($ruc)
    {
        $this->ruc = $ruc;

        return $this;
    }

    /**
     * Get ruc
     *
     * @return string
     */
    public function getRuc()
    {
        return $this->ruc;
    }

    /**
     * Set telefono
     *
     * @param string $telefono
     *
     * @return Institucion
     */
    public function setTelefono($telefono)
    {
        $this->telefono = $telefono;

        return $this;
    }

    /**
     * Get telefono
     *
     * @return string
     */
    public function getTelefono()
    {
        return $this->telefono;
    }

    /**
     * Set celular
     *
     * @param string $celular
     *
     * @return Institucion
     */
    public function setCelular($celular)
    {
        $this->celular = $celular;

        return $this;
    }

    /**
     * Get celular
     *
     * @return string
     */
    public function getCelular()
    {
        return $this->celular;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return Institucion
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set numeroEstabl
     *
     * @param string $numeroEstabl
     *
     * @return Institucion
     */
    public function setNumeroEstabl($numeroEstabl)
    {
        $this->numeroEstabl = $numeroEstabl;

        return $this;
    }

    /**
     * Get numeroEstabl
     *
     * @return string
     */
    public function getNumeroEstabl()
    {
        return $this->numeroEstabl;
    }

    /**
     * Set puntoEmision
     *
     * @param string $puntoEmision
     *
     * @return Institucion
     */
    public function setPuntoEmision($puntoEmision)
    {
        $this->puntoEmision = $puntoEmision;

        return $this;
    }

    /**
     * Get puntoEmision
     *
     * @return string
     */
    public function getPuntoEmision()
    {
        return $this->puntoEmision;
    }

    /**
     * Set direccionMatriz
     *
     * @param string $direccionMatriz
     *
     * @return Institucion
     */
    public function setDireccionMatriz($direccionMatriz)
    {
        $this->direccionMatriz = $direccionMatriz;

        return $this;
    }

    /**
     * Get direccionMatriz
     *
     * @return string
     */
    public function getDireccionMatriz()
    {
        return $this->direccionMatriz;
    }

    /**
     * Set direccionEstabl
     *
     * @param string $direccionEstabl
     *
     * @return Institucion
     */
    public function setDireccionEstabl($direccionEstabl)
    {
        $this->direccionEstabl = $direccionEstabl;

        return $this;
    }

    /**
     * Get direccionEstabl
     *
     * @return string
     */
    public function getDireccionEstabl()
    {
        return $this->direccionEstabl;
    }

    /**
     * Set tipoContribuyente
     *
     * @param string $tipoContribuyente
     *
     * @return Institucion
     */
    public function setTipoContribuyente($tipoContribuyente)
    {
        $this->tipoContribuyente = $tipoContribuyente;

        return $this;
    }

    /**
     * Get tipoContribuyente
     *
     * @return string
     */
    public function getTipoContribuyente()
    {
        return $this->tipoContribuyente;
    }

    /**
     * Set nroContribuyente
     *
     * @param string $nroContribuyente
     *
     * @return Institucion
     */
    public function setNroContribuyente($nroContribuyente)
    {
        $this->nroContribuyente = $nroContribuyente;

        return $this;
    }

    /**
     * Get nroContribuyente
     *
     * @return string
     */
    public function getNroContribuyente()
    {
        return $this->nroContribuyente;
    }

    /**
     * Set oblContabilidad
     *
     * @param string $oblContabilidad
     *
     * @return Institucion
     */
    public function setOblContabilidad($oblContabilidad)
    {
        $this->oblContabilidad = $oblContabilidad;

        return $this;
    }

    /**
     * Get oblContabilidad
     *
     * @return string
     */
    public function getOblContabilidad()
    {
        return $this->oblContabilidad;
    }

    /**
     * Set firmaElectronica
     *
     * @param string $firmaElectronica
     *
     * @return Institucion
     */
    public function setFirmaElectronica($firmaElectronica)
    {
        $this->firmaElectronica = $firmaElectronica;

        return $this;
    }

    /**
     * Get firmaElectronica
     *
     * @return string
     */
    public function getFirmaElectronica()
    {
        return $this->firmaElectronica;
    }

    /**
     * Set claveFirma
     *
     * @param string $claveFirma
     *
     * @return Institucion
     */
    public function setClaveFirma($claveFirma)
    {
        $this->claveFirma = $claveFirma;

        return $this;
    }

    /**
     * Get claveFirma
     *
     * @return string
     */
    public function getClaveFirma()
    {
        return $this->claveFirma;
    }

}

