<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Especialidades
 *
 * @ORM\Table(name="especialidad")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\EspecialidadesRepository")
 */
class Especialidades
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_especialidad", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="MedicoEspecialidad", mappedBy="idEspecialidad")
     * @ORM\OneToOne(targetEntity="AgendaBundle\Entity\CitaMedica", mappedBy="idEspecialidad")
     * @ORM\OneToMany(targetEntity="AgendaBundle\Entity\ImagenVideoEspecialidad", mappedBy="idEspecialidad")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_especialidad", type="string", length=40)
     */
    private $nombre;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_especialidad", type="string", length=10)
     */
    private $codigo;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_especialidad", type="boolean")
     */
    private $estado;
    
    /**
     * @var string
     *
     * @ORM\Column(name="url_imagen_especialidad", type="text", nullable=true)
     */
    private $uriImgEspecialidad;

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return Especialidades
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return Especialidades
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return Especialidades
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }
    
    /**
     * Set uriImgEspecialidad
     *
     * @param string $uriImgEspecialidad
     *
     * @return Especialidades
     */
    public function seturiImgEspecialidad($uriImgEspecialidad)
    {
        $this->uriImgEspecialidad = $uriImgEspecialidad;

        return $this;
    }

    /**
     * Get uriImgEspecialidad
     *
     * @return string
     */
    public function geturiImgEspecialidad()
    {
        return $this->uriImgEspecialidad;
    }
}

