<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ChatPromocion
 *
 * @ORM\Table(name="chat_promocion")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\ChatPromocionRepository")
 */
class ChatPromocion
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_chat_promocion", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Administrador")
     * @ORM\JoinColumn(name="id_administrador", referencedColumnName="id_administrador")
     */
    private $idAdministrador;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico")
     */
    private $idMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="imagen_promocion", type="string", length=200, nullable=true)
     */
    private $imagenPromocion;

    /**
     * @var string
     *
     * @ORM\Column(name="mensaje_promocion", type="text", nullable=true)
     */
    private $mensajePromocion;

    /**
     * @var string
     *
     * @ORM\Column(name="url_redirec_promocion", type="string", length=200, nullable=true)
     */
    private $urlRedireccion;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_chat", type="boolean")
     */
    private $estado;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idAdministrador
     *
     * @param integer $idAdministrador
     *
     * @return ChatPromocion
     */
    public function setIdAdministrador($idAdministrador)
    {
        $this->idAdministrador = $idAdministrador;

        return $this;
    }

    /**
     * Get idAdministrador
     *
     * @return int
     */
    public function getIdAdministrador()
    {
        return $this->idAdministrador;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return ChatPromocion
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;

        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    /**
     * Set imagenPromocion
     *
     * @param string $imagenPromocion
     *
     * @return ChatPromocion
     */
    public function setImagenPromocion($imagenPromocion)
    {
        $this->imagenPromocion = $imagenPromocion;

        return $this;
    }

    /**
     * Get imagenPromocion
     *
     * @return string
     */
    public function getImagenPromocion()
    {
        return $this->imagenPromocion;
    }

    /**
     * Set mensajePromocion
     *
     * @param string $mensajePromocion
     *
     * @return ChatPromocion
     */
    public function setMensajePromocion($mensajePromocion)
    {
        $this->mensajePromocion = $mensajePromocion;

        return $this;
    }

    /**
     * Get mensajePromocion
     *
     * @return string
     */
    public function getMensajePromocion()
    {
        return $this->mensajePromocion;
    }

    /**
     * Set urlRedireccion
     *
     * @param string $urlRedireccion
     *
     * @return ChatPromocion
     */
    public function setUrlRedireccion($urlRedireccion)
    {
        $this->urlRedireccion = $urlRedireccion;

        return $this;
    }

    /**
     * Get urlRedireccion
     *
     * @return string
     */
    public function getUrlRedireccion()
    {
        return $this->urlRedireccion;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return ChatPromocion
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }
}

