<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Cantones
 *
 * @ORM\Table(name="cantones")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\CantonesRepository")
 */
class Cantones
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_canton", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="Parroquias", mappedBy="idParroquia")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Provincias")
     * @ORM\JoinColumn(name="id_provincia", referencedColumnName="id_provincia")
     */
    private $idProvincia;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_canton", type="string", length=10, unique=true)
     */
    private $codigo;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_canton", type="string", length=50)
     */
    private $nombre;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_canton", type="boolean")
     */
    private $estado;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idProvincia
     *
     * @param integer $idProvincia
     *
     * @return Cantones
     */
    public function setIdProvincia($idProvincia)
    {
        $this->idProvincia = $idProvincia;

        return $this;
    }

    /**
     * Get idProvincia
     *
     * @return int
     */
    public function getIdProvincia()
    {
        return $this->idProvincia;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return Cantones
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return Cantones
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return Cantones
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }
}

