<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AsistenteMedico
 *
 * @ORM\Table(name="asistente_medico")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\AsistenteMedicoRepository")
 */
class AsistenteMedico
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_asistente_medico", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Asistente")
     * @ORM\JoinColumn(name="id_asistente", referencedColumnName="id_asistente")
     */
    private $idAsistente;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico")
     */
    private $idMedico;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idAsistente
     *
     * @param integer $idAsistente
     *
     * @return AsistenteMedico
     */
    public function setIdAsistente($idAsistente)
    {
        $this->idAsistente = $idAsistente;

        return $this;
    }

    /**
     * Get idAsistente
     *
     * @return int
     */
    public function getIdAsistente()
    {
        return $this->idAsistente;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return AsistenteMedico
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;

        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }
}

