<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Asistente
 *
 * @ORM\Table(name="asistente")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\AsistenteRepository")
 */
class Asistente
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_asistente", type="integer")
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="LoginBundle\Entity\Usuario", mappedBy="idAsistente")
     * @ORM\OneToMany(targetEntity="AsistenteMedico", mappedBy="idAsistente")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \int
     *
     * @ORM\OneToOne(targetEntity="LoginBundle\Entity\Usuario")
     * @ORM\JoinColumn(name="id_usuario", referencedColumnName="id_usuario")
     */
    private $idUsuario;

    /**
     * @var bool
     *
     * @ORM\Column(name="tiene_medico", type="boolean")
     */
    private $medico;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_registro_asistente", type="string", length=50)
     */
    private $fechaRegistro;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_caducidad_asistente", type="string", length=50)
     */
    private $fechaCaducidad;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="PeriodoLicencia")
     * @ORM\JoinColumn(name="id_periodo_licencia", referencedColumnName="id_periodo_licencia")
     */
    private $periodoLicencia;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idUsuario
     *
     * @param \int $idUsuario
     *
     * @return Asistente
     */
    public function setIdUsuario($idUsuario)
    {
        $this->idUsuario = $idUsuario;

        return $this;
    }

    /**
     * Get idUsuario
     *
     * @return \int
     */
    public function getIdUsuario()
    {
        return $this->idUsuario;
    }

    
    /**
     * Set medico
     *
     * @param boolean $medico
     *
     * @return Asistente
     */
    public function setMedico($medico)
    {
        $this->medico = $medico;

        return $this;
    }

    /**
     * Get medico
     *
     * @return bool
     */
    public function getMedico()
    {
        return $this->medico;
    }

    /**
     * Set fechaRegistro
     *
     * @param string $fechaRegistro
     *
     * @return Asistente
     */
    public function setFechaRegistro($fechaRegistro)
    {
        $this->fechaRegistro = $fechaRegistro;

        return $this;
    }

    /**
     * Get fechaRegistro
     *
     * @return string
     */
    public function getFechaRegistro()
    {
        return $this->fechaRegistro;
    }

    /**
     * Set fechaCaducidad
     *
     * @param string $fechaCaducidad
     *
     * @return Asistente
     */
    public function setFechaCaducidad($fechaCaducidad)
    {
        $this->fechaCaducidad = $fechaCaducidad;

        return $this;
    }

    /**
     * Get fechaCaducidad
     *
     * @return string
     */
    public function getFechaCaducidad()
    {
        return $this->fechaCaducidad;
    }

    /**
     * Set periodoLicencia
     *
     * @param integer $periodoLicencia
     *
     * @return Asistente
     */
    public function setPeriodoLicencia($periodoLicencia)
    {
        $this->periodoLicencia = $periodoLicencia;

        return $this;
    }

    /**
     * Get periodoLicencia
     *
     * @return int
     */
    public function getPeriodoLicencia()
    {
        return $this->periodoLicencia;
    }
}

