<?php

namespace AdministradorBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Administrador
 *
 * @ORM\Table(name="administrador")
 * @ORM\Entity(repositoryClass="AdministradorBundle\Repository\AdministradorRepository")
 */
class Administrador
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_administrador", type="integer")
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="LoginBundle\Entity\Usuario", mappedBy="idAdministrador")
     * @ORM\OneToMany(targetEntity="ChatPromocion", mappedBy="idAdministrador")
     * @ORM\OneToMany(targetEntity="Noticias", mappedBy="idAdministrador")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \int
     *
     * @ORM\OneToOne(targetEntity="LoginBundle\Entity\Usuario")
     * @ORM\JoinColumn(name="id_usuario", referencedColumnName="id_usuario")
     */
    private $idUsuario;

    /**
     * @var \string
     *
     * @ORM\Column(name="correo_recuperacion_admin", type="string", length=20)
     */
    private $correoRecuperacion;

    /**
     * @var string
     *
     * @ORM\Column(name="pass_programamed_admin", type="string", length=50)
     */
    private $passProgramamed;

    /**
     * @var string
     *
     * @ORM\Column(name="pass_db_admin", type="string", length=50)
     */
    private $passDb;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idUsuario
     *
     * @param \int $idUsuario
     *
     * @return Paciente
     */
    public function setIdUsuario($idUsuario)
    {
        $this->idUsuario = $idUsuario;

        return $this;
    }

    /**
     * Get idUsuario
     *
     * @return \int
     */
    public function getIdUsuario()
    {
        return $this->idUsuario;
    }

    /**
     * Set correoRecuperacion
     *
     * @param \string $correoRecuperacion
     *
     * @return Paciente
     */
    public function setCorreoRecuperacion($correoRecuperacion)
    {
        $this->correoRecuperacion = $correoRecuperacion;

        return $this;
    }

    /**
     * Get correoRecuperacion
     *
     * @return \string
     */
    public function getCorreoRecuperacion()
    {
        return $this->correoRecuperacion;
    }

    /**
     * Set passProgramamed
     *
     * @param string $passProgramamed
     *
     * @return Medico
     */
    public function setPassProgramamed($passProgramamed)
    {
        $this->passProgramamed = $passProgramamed;

        return $this;
    }

    /**
     * Get passProgramamed
     *
     * @return string
     */
    public function getPassProgramamed()
    {
        return $this->passProgramamed;
    }

    /**
     * Set passDb
     *
     * @param string $passDb
     *
     * @return Medico
     */
    public function setPassDb($passDb)
    {
        $this->passDb = $passDb;

        return $this;
    }

    /**
     * Get passDb
     *
     * @return string
     */
    public function getPassDb()
    {
        return $this->passDb;
    }
}

