<?php

namespace AdministradorBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Knp\Bundle\SnappyBundle\Snappy\Response\PdfResponse;

class ReportesaAdministradorController extends Controller
{
	/**
	 * @Route("/reportes/", name="homeReporteAdmin")
	 */
	public function indexAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
			$fecha = date("Y-m-d");

			return $this->render("@Administrador/Reportes/index.html.twig", array("usuario" => $usuario, "fecha" => $fecha));
		}
	}

	/**
	 * @Route("/reportes/genero/", name="reportesPacGeneroAdm")
	 */
	public function reportePacienteGenero(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
		$queryMas = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.genero = 'Masculino'";
		$queryFem = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.genero = 'Femenino'";
		$queryOtr = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.genero = 'Otro'";
		$pacienteMas = $em->createQuery($queryMas)->getSingleScalarResult();
		$pacienteFem = $em->createQuery($queryFem)->getSingleScalarResult();
		$pacienteOtr = $em->createQuery($queryOtr)->getSingleScalarResult();

		$reporte = [
			"Masculino" => $pacienteMas,
			"Femenino" => $pacienteFem,
			"Otro" => $pacienteOtr
		];

		return new Response(json_encode($reporte));
	}

	/**
	 * @Route("/reportes/registro/", name="reportesPacRegistroAdm")
	 */
	public function reportePacienteRegistro(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
		$anio = $_POST["anio"];
		$queryEne = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-01-01' and '".$anio."-01-31'";
		$queryFeb = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-02-01' and '".$anio."-02-28'";
		$queryMar = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-03-01' and '".$anio."-03-31'";
		$queryAbr = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-04-01' and '".$anio."-04-30'";
		$queryMay = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-05-01' and '".$anio."-05-31'";
		$queryJun = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-06-01' and '".$anio."-06-30'";
		$queryJul = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-07-01' and '".$anio."-08-31'";
		$queryAgo = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-08-01' and '".$anio."-08-31'";
		$querySep = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-09-01' and '".$anio."-09-30'";
		$queryOct = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-10-01' and '".$anio."-10-31'";
		$queryNov = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-11-01' and '".$anio."-11-30'";
		$queryDic = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true"." and p.fechaRegistro between '".$anio."-12-01' and '".$anio."-12-31'";

		$enero = $em->createQuery($queryEne)->getSingleScalarResult();
		$febrero = $em->createQuery($queryFeb)->getSingleScalarResult();
		$marzo = $em->createQuery($queryMar)->getSingleScalarResult();
		$abril = $em->createQuery($queryAbr)->getSingleScalarResult();
		$mayo = $em->createQuery($queryMay)->getSingleScalarResult();
		$junio = $em->createQuery($queryJun)->getSingleScalarResult();
		$julio = $em->createQuery($queryJul)->getSingleScalarResult();
		$agosto = $em->createQuery($queryAgo)->getSingleScalarResult();
		$septiembre = $em->createQuery($querySep)->getSingleScalarResult();
		$octubre = $em->createQuery($queryOct)->getSingleScalarResult();
		$noviembre = $em->createQuery($queryNov)->getSingleScalarResult();
		$diciembre = $em->createQuery($queryDic)->getSingleScalarResult();

		$reporte = [
			"enero" => $enero,
			"febrero" => $febrero,
			"marzo" => $marzo,
			"abril" => $abril,
			"mayo" => $mayo,
			"junio" => $junio,
			"julio" => $julio,
			"agosto" => $agosto,
			"septiembre" => $septiembre,
			"octubre" => $octubre,
			"noviembre" => $noviembre,
			"diciembre" => $diciembre
		];

		return new Response(json_encode($reporte));
	}

	/**
	 * @Route("/reportes/estadocivil/", name="reporteEstadoCivilAdm")
	 */
	public function reporteEstadoCivil(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));

		$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";
		$pacientes = $em->createQuery($query)->getResult();
		$grupo1 = "0";
		$grupo2 = "0";
		$grupo3 = "0";
		$grupo4 = "0";
		$grupo5 = "0";
		$grupo6 = "0";
		if($pacientes)
		{
			foreach($pacientes as $row)
			{
				if($row->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($row->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y');
                    if($edad >= 0 && $edad < 6)
                    	$grupo1 .= ", ".$row->getId();
                    elseif($edad >= 6 && $edad < 15)
                    	$grupo2 .= ", ".$row->getId();
                    elseif($edad >= 15 && $edad < 20)
                    	$grupo3 .= ", ".$row->getId();
                    elseif($edad >= 20 && $edad < 45)
                    	$grupo4 .= ", ".$row->getId();
                    elseif($edad >= 45 && $edad < 65)
                    	$grupo5 .= ", ".$row->getId();
                    elseif($edad >= 65)
                    	$grupo6 .= ", ".$row->getId();
                }
                else
                	$grupo1 .= ", ".$row->getId();
			}
		}

		$queryCas = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)'";
		$querySol = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)'";
		$queryViu = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)'";
		$queryDiv = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)'";
		$queryUni = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre'";
		$queryOtr = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros'";

		$queryCasG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo1.")";
		$querySolG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo1.")";
		$queryViuG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo1.")";
		$queryDivG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo1.")";
		$queryUniG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo1.")";
		$queryOtrG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo1.")";

		$queryCasG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo2.")";
		$querySolG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo2.")";
		$queryViuG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo2.")";
		$queryDivG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo2.")";
		$queryUniG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo2.")";
		$queryOtrG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo2.")";

		$queryCasG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo3.")";
		$querySolG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo3.")";
		$queryViuG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo3.")";
		$queryDivG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo3.")";
		$queryUniG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo3.")";
		$queryOtrG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo3.")";

		$queryCasG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo4.")";
		$querySolG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo4.")";
		$queryViuG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo4.")";
		$queryDivG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo4.")";
		$queryUniG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo4.")";
		$queryOtrG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo4.")";

		$queryCasG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo5.")";
		$querySolG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo5.")";
		$queryViuG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo5.")";
		$queryDivG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo5.")";
		$queryUniG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo5.")";
		$queryOtrG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo5.")";

		$queryCasG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo6.")";
		$querySolG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo6.")";
		$queryViuG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo6.")";
		$queryDivG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo6.")";
		$queryUniG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo6.")";
		$queryOtrG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo6.")";

		$reporte = [
			"totCas" => $em->createQuery($queryCas)->getSingleScalarResult(),
			"totSol" => $em->createQuery($querySol)->getSingleScalarResult(),
			"totViu" => $em->createQuery($queryViu)->getSingleScalarResult(),
			"totDiv" => $em->createQuery($queryDiv)->getSingleScalarResult(),
			"totUni" => $em->createQuery($queryUni)->getSingleScalarResult(),
			"totOtr" => $em->createQuery($queryOtr)->getSingleScalarResult(),
			"casG1" => $em->createQuery($queryCasG1)->getSingleScalarResult(),
			"casG2" => $em->createQuery($queryCasG2)->getSingleScalarResult(),
			"casG3" => $em->createQuery($queryCasG3)->getSingleScalarResult(),
			"casG4" => $em->createQuery($queryCasG4)->getSingleScalarResult(),
			"casG5" => $em->createQuery($queryCasG5)->getSingleScalarResult(),
			"casG6" => $em->createQuery($queryCasG6)->getSingleScalarResult(),
			"solG1" => $em->createQuery($querySolG1)->getSingleScalarResult(),
			"solG2" => $em->createQuery($querySolG2)->getSingleScalarResult(),
			"solG3" => $em->createQuery($querySolG3)->getSingleScalarResult(),
			"solG4" => $em->createQuery($querySolG4)->getSingleScalarResult(),
			"solG5" => $em->createQuery($querySolG5)->getSingleScalarResult(),
			"solG6" => $em->createQuery($querySolG6)->getSingleScalarResult(),
			"viuG1" => $em->createQuery($queryViuG1)->getSingleScalarResult(),
			"viuG2" => $em->createQuery($queryViuG2)->getSingleScalarResult(),
			"viuG3" => $em->createQuery($queryViuG3)->getSingleScalarResult(),
			"viuG4" => $em->createQuery($queryViuG4)->getSingleScalarResult(),
			"viuG5" => $em->createQuery($queryViuG5)->getSingleScalarResult(),
			"viuG6" => $em->createQuery($queryViuG6)->getSingleScalarResult(),
			"divG1" => $em->createQuery($queryDivG1)->getSingleScalarResult(),
			"divG2" => $em->createQuery($queryDivG2)->getSingleScalarResult(),
			"divG3" => $em->createQuery($queryDivG3)->getSingleScalarResult(),
			"divG4" => $em->createQuery($queryDivG4)->getSingleScalarResult(),
			"divG5" => $em->createQuery($queryDivG5)->getSingleScalarResult(),
			"divG6" => $em->createQuery($queryDivG6)->getSingleScalarResult(),
			"uniG1" => $em->createQuery($queryUniG1)->getSingleScalarResult(),
			"uniG2" => $em->createQuery($queryUniG2)->getSingleScalarResult(),
			"uniG3" => $em->createQuery($queryUniG3)->getSingleScalarResult(),
			"uniG4" => $em->createQuery($queryUniG4)->getSingleScalarResult(),
			"uniG5" => $em->createQuery($queryUniG5)->getSingleScalarResult(),
			"uniG6" => $em->createQuery($queryUniG6)->getSingleScalarResult(),
			"otrG1" => $em->createQuery($queryOtrG1)->getSingleScalarResult(),
			"otrG2" => $em->createQuery($queryOtrG2)->getSingleScalarResult(),
			"otrG3" => $em->createQuery($queryOtrG3)->getSingleScalarResult(),
			"otrG4" => $em->createQuery($queryOtrG4)->getSingleScalarResult(),
			"otrG5" => $em->createQuery($queryOtrG5)->getSingleScalarResult(),
			"otrG6" => $em->createQuery($queryOtrG6)->getSingleScalarResult()
		];

		return new Response(json_encode($reporte));
	}

	/**
	 * @Route("/reportes/pacientes/", name="reportePacientesAdm")
	 */
	public function reportePacientes(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
		$reporte = $_POST["reporte"];

		switch($reporte)
		{
			case "ubicacion":
        			$pag = $_POST["pagina"] * $_POST["cantidad"];
					$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";
					$queryPag = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";

					$pacientes = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
        			$total = $em->createQuery($queryPag)->getSingleScalarResult();
					$html = '<table class="table table-bordered">
					<thead>
						<tr>
							<th>Paciente</th>
							<th>Provincia</th>
							<th>Cantón</th>
							<th>Parroquia</th>
							<th>Dirección</th>
							<th>Médico</th>
						</tr>
					</thead>
					<tbody>';

					if($pacientes)
					{
						foreach($pacientes as $row)
						{
							$html .= '<tr>
								<td>'.$row->getIdUsuario()->getNombre().' '.$row->getIdUsuario()->getApellido().'</td>
								<td>'.$row->getIdParroquia()->getIdCanton()->getIdProvincia()->getNombre().'</td>
								<td>'.$row->getIdParroquia()->getIdCanton()->getNombre().'</td>
								<td>'.$row->getIdParroquia()->getNombre().'</td>
								<td>'.$row->getDireccion().'</td>
								<td>'.$row->getIdMedico()->getIdUsuario()->getNombre().' '.$row->getIdMedico()->getIdUsuario()->getApellido().'</td>
							</tr>';
						}
					}

					$html .= '</tbody></table>';
					
        			$paginas = ceil($total / $_POST["cantidad"]);
			        $start = (($_POST["pagina"] - 5) > 0 ) ? $_POST["pagina"] - 5 : 0;
			        $end = (($_POST["pagina"] + 5) < $paginas) ? $_POST["pagina"] + 5 : ($paginas-1);

			        $html .= '<div class="d100 paginacion"><nav aria-label="">
			        <ul class="pagination">
			            <li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
			                <a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
			                    <span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
			                </a>
			            </li>';
			        if($start > 1)
			        {
			            $html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			        }

			        for($i = $start; $i <= $end; $i++)
			        {
			            $html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
			        }

			        if($end < ($paginas-1))
			        {
			            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			            $html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
			        }
			        $html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
			            <a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
			                <span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
			            </a>
			        </li>
			        </ul></nav></div>';

			        return new Response($html);
				break;

			case "seguro":
        			$pag = $_POST["pagina"] * $_POST["cantidad"];
					$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";
					$queryPag = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";

					$pacientes = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
        			$total = $em->createQuery($queryPag)->getSingleScalarResult();
					$html = '<table class="table table-bordered">
					<thead>
						<tr>
							<th>Paciente</th>
							<th>Cédula</th>
							<th>Edad</th>
							<th>Ocupación</th>
							<th>Aseguradora</th>
							<th>Médico</th>
						</tr>
					</thead>
					<tbody>';

					if($pacientes)
					{
						foreach($pacientes as $row)
						{
							$edad = "";
			                if($row->getFechaNacimiento() != null)
			                {
			                    $fechaHoy = date_create(date("Y-m-d"));
			                    $fechaNac = date_create($row->getFechaNacimiento());
			                    $resultado = date_diff($fechaNac, $fechaHoy);
			                    $edad = $resultado->format('%y')." años";
			                }

							$html .= '<tr>
								<td>'.$row->getIdUsuario()->getNombre().' '.$row->getIdUsuario()->getApellido().'</td>
								<td>'.$row->getIdUsuario()->getCedula().'</td>
								<td>'.$edad.'</td>
								<td>'.$row->getOcupacion().'</td>
								<td>'.$row->getAseguradora().'</td>
								<td>'.$row->getIdMedico()->getIdUsuario()->getNombre().' '.$row->getIdMedico()->getIdUsuario()->getApellido().'</td>
							</tr>';
						}
					}

					$html .= '</tbody></table>';
					
        			$paginas = ceil($total / $_POST["cantidad"]);
			        $start = (($_POST["pagina"] - 5) > 0 ) ? $_POST["pagina"] - 5 : 0;
			        $end = (($_POST["pagina"] + 5) < $paginas) ? $_POST["pagina"] + 5 : ($paginas-1);

			        $html .= '<div class="d100 paginacion"><nav aria-label="">
			        <ul class="pagination">
			            <li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
			                <a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
			                    <span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
			                </a>
			            </li>';
			        if($start > 1)
			        {
			            $html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			        }

			        for($i = $start; $i <= $end; $i++)
			        {
			            $html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
			        }

			        if($end < ($paginas-1))
			        {
			            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			            $html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
			        }
			        $html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
			            <a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
			                <span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
			            </a>
			        </li>
			        </ul></nav></div>';

			        return new Response($html);
				break;

			case "total":
        			$pag = $_POST["pagina"] * $_POST["cantidad"];
					$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";
					$queryPag = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";

					$pacientes = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
        			$total = $em->createQuery($queryPag)->getSingleScalarResult();
					$html = '<table class="table table-bordered">
					<thead>
						<tr>
							<th>Paciente</th>
							<th>Cédula</th>
							<th>Celular</th>
							<th>Teléfono</th>
							<th>Email</th>
							<th>Fecha de Nacimiento</th>
							<th>Edad</th>
							<th>Estado Civil</th>
							<th>Género</th>
							<th>Ocupación</th>
							<th>Aseguradora</th>
							<th>Contacto</th>
							<th>Provincia</th>
							<th>Cantón</th>
							<th>Parroquia</th>
							<th>Sector</th>
							<th>Dirección</th>
							<th>Médico</th>
						</tr>
					</thead>
					<tbody>';

					if($pacientes)
					{
						foreach($pacientes as $row)
						{
							$edad = "";
			                if($row->getFechaNacimiento() != null)
			                {
			                    $fechaHoy = date_create(date("Y-m-d"));
			                    $fechaNac = date_create($row->getFechaNacimiento());
			                    $resultado = date_diff($fechaNac, $fechaHoy);
			                    $edad = $resultado->format('%y')." años";
			                }

							$html .= '<tr>
								<td>'.$row->getIdUsuario()->getNombre().' '.$row->getIdUsuario()->getApellido().'</td>
								<td>'.$row->getIdUsuario()->getCedula().'</td>
								<td>'.$row->getIdUsuario()->getTelefono().'</td>
								<td>'.$row->getTelefono().'</td>
								<td>'.$row->getIdUsuario()->getEmail().'</td>
								<td>'.$row->getFechaNacimiento().'</td>
								<td>'.$edad.'</td>
								<td>'.$row->getEstadoCivil().'</td>
								<td>'.$row->getGenero().'</td>
								<td>'.$row->getOcupacion().'</td>
								<td>'.$row->getAseguradora().'</td>
								<td>'.$row->getContacto().'</td>
								<td>'.$row->getIdParroquia()->getIdCanton()->getIdProvincia()->getNombre().'</td>
								<td>'.$row->getIdParroquia()->getIdCanton()->getNombre().'</td>
								<td>'.$row->getIdParroquia()->getNombre().'</td>
								<td>'.$row->getSector().'</td>
								<td>'.$row->getDireccion().'</td>
								<td>'.$row->getIdMedico()->getIdUsuario()->getNombre().' '.$row->getIdMedico()->getIdUsuario()->getApellido().'</td>
							</tr>';
						}
					}

					$html .= '</tbody></table>';
					
        			$paginas = ceil($total / $_POST["cantidad"]);
			        $start = (($_POST["pagina"] - 5) > 0 ) ? $_POST["pagina"] - 5 : 0;
			        $end = (($_POST["pagina"] + 5) < $paginas) ? $_POST["pagina"] + 5 : ($paginas-1);

			        $html .= '<div class="d100 paginacion"><nav aria-label="">
			        <ul class="pagination">
			            <li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
			                <a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
			                    <span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
			                </a>
			            </li>';
			        if($start > 1)
			        {
			            $html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			        }

			        for($i = $start; $i <= $end; $i++)
			        {
			            $html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
			        }

			        if($end < ($paginas-1))
			        {
			            $html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			            $html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
			        }
			        $html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
			            <a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
			                <span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
			            </a>
			        </li>
			        </ul></nav></div>';

			        return new Response($html);
				break;
		}
	}

	/**
	 * @Route("/reporte/login/medicos/", name="reporteLoginAdm")
	 */
	public function reporteLoginAction(Request $request)
	{
		$em = $this->getDoctrine()->getManager();

		$query = "select r.id_usuario, u.nombre_usuario, u.apellido_usuario, count(r.id_usuario) from registro_login r, usuario u where r.id_usuario = u.id_usuario and r.fecha_registro = ? and u.id_rol_usuario = ? group by r.id_usuario, u.nombre_usuario, u.apellido_usuario";
		$usuario = $em->getConnection()->prepare($query);
        $usuario->bindValue(1, $_POST["fecha"]);
        $usuario->bindValue(2, $_POST["rol"]);
        $usuario->execute();
        $resultado = $usuario->fetchAll();

		$html = '';
		if($resultado)
		{
			if($_POST["rol"] == 2)
			{
				$html .= '<table class="table table-bordered">
				<thead>
					<tr><th>Médico</th><th>Fecha</th></tr>
				</thead><tbody>';
				
				foreach($resultado as $row)
				{
					$html .= '<tr>
						<td>'.$row["apellido_usuario"].' '.$row["nombre_usuario"].'</td>
						<td>'.$_POST["fecha"].'</td>
					</tr>';
				}

				$html .= '</tbody></table>';
			}
			else
			{
				$html .= '<table class="table table-bordered">
				<thead>
					<tr><th>Asistente</th><th>Médicos</th><th>Fecha</th></tr>
				</thead><tbody>';

				foreach($resultado as $row)
				{
					$queryAsi = "select am from AdministradorBundle:AsistenteMedico am, AdministradorBundle:Asistente a, LoginBundle:Usuario u where u.id = a.idUsuario and a.id = am.idAsistente and a.idUsuario = :usuario";
					$medicos = $em->createQuery($queryAsi)->setParameter("usuario", $row["id_usuario"])->getResult();
					
					$html .= '<tr><td>'.$row["apellido_usuario"].' '.$row["nombre_usuario"].'</td><td>';
					if($medicos)
					{
						$html .= '<ul class="list-group list-group-flush">';
						foreach($medicos as $fila)
						{
							$html .= '<li class="list-group-item p-0">'.$fila->getIdMedico()->getIdUsuario()->getApellido().' '.$fila->getIdMedico()->getIdUsuario()->getNombre().'</li>';
						}
						$html.= '</ul>';
					}
					$html .= '</td><td>'.$_POST["fecha"].'</td></tr>';
				}

				$html .= '</tbody></table>';
			}
		}

		return new Response($html);
	}

	/**
	 * @Route("/reportes/estadocivil/export/", name="reporteEstadoCivilAdmExport")
	 */
	public function reporteEstadoCivilExport(Request $request)
	{
		$em = $this->getDoctrine()->getManager();

		$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";
		$pacientes = $em->createQuery($query)->getResult();
		$grupo1 = "0";
		$grupo2 = "0";
		$grupo3 = "0";
		$grupo4 = "0";
		$grupo5 = "0";
		$grupo6 = "0";
		if($pacientes)
		{
			foreach($pacientes as $row)
			{
				if($row->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($row->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y');
                    if($edad >= 0 && $edad < 6)
                    	$grupo1 .= ", ".$row->getId();
                    elseif($edad >= 6 && $edad < 15)
                    	$grupo2 .= ", ".$row->getId();
                    elseif($edad >= 15 && $edad < 20)
                    	$grupo3 .= ", ".$row->getId();
                    elseif($edad >= 20 && $edad < 45)
                    	$grupo4 .= ", ".$row->getId();
                    elseif($edad >= 45 && $edad < 65)
                    	$grupo5 .= ", ".$row->getId();
                    elseif($edad >= 65)
                    	$grupo6 .= ", ".$row->getId();
                }
                else
                	$grupo1 .= ", ".$row->getId();
			}
		}

		$queryCas = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)'";
		$querySol = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)'";
		$queryViu = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)'";
		$queryDiv = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)'";
		$queryUni = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre'";
		$queryOtr = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros'";

		$queryCasG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo1.")";
		$querySolG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo1.")";
		$queryViuG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo1.")";
		$queryDivG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo1.")";
		$queryUniG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo1.")";
		$queryOtrG1 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo1.")";

		$queryCasG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo2.")";
		$querySolG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo2.")";
		$queryViuG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo2.")";
		$queryDivG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo2.")";
		$queryUniG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo2.")";
		$queryOtrG2 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo2.")";

		$queryCasG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo3.")";
		$querySolG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo3.")";
		$queryViuG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo3.")";
		$queryDivG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo3.")";
		$queryUniG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo3.")";
		$queryOtrG3 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo3.")";

		$queryCasG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo4.")";
		$querySolG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo4.")";
		$queryViuG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo4.")";
		$queryDivG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo4.")";
		$queryUniG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo4.")";
		$queryOtrG4 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo4.")";

		$queryCasG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo5.")";
		$querySolG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo5.")";
		$queryViuG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo5.")";
		$queryDivG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo5.")";
		$queryUniG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo5.")";
		$queryOtrG5 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo5.")";

		$queryCasG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Casado(a)' and p.id in (".$grupo6.")";
		$querySolG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Soltero(a)' and p.id in (".$grupo6.")";
		$queryViuG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Viudo(a)' and p.id in (".$grupo6.")";
		$queryDivG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Divorciado(a)' and p.id in (".$grupo6.")";
		$queryUniG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Unión Libre' and p.id in (".$grupo6.")";
		$queryOtrG6 = "select count(p.id) from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true and p.estadoCivil = 'Otros' and p.id in (".$grupo6.")";

		$reporte = [
			"totCas" => $em->createQuery($queryCas)->getSingleScalarResult(),
			"totSol" => $em->createQuery($querySol)->getSingleScalarResult(),
			"totViu" => $em->createQuery($queryViu)->getSingleScalarResult(),
			"totDiv" => $em->createQuery($queryDiv)->getSingleScalarResult(),
			"totUni" => $em->createQuery($queryUni)->getSingleScalarResult(),
			"totOtr" => $em->createQuery($queryOtr)->getSingleScalarResult(),
			"casG1" => $em->createQuery($queryCasG1)->getSingleScalarResult(),
			"casG2" => $em->createQuery($queryCasG2)->getSingleScalarResult(),
			"casG3" => $em->createQuery($queryCasG3)->getSingleScalarResult(),
			"casG4" => $em->createQuery($queryCasG4)->getSingleScalarResult(),
			"casG5" => $em->createQuery($queryCasG5)->getSingleScalarResult(),
			"casG6" => $em->createQuery($queryCasG6)->getSingleScalarResult(),
			"solG1" => $em->createQuery($querySolG1)->getSingleScalarResult(),
			"solG2" => $em->createQuery($querySolG2)->getSingleScalarResult(),
			"solG3" => $em->createQuery($querySolG3)->getSingleScalarResult(),
			"solG4" => $em->createQuery($querySolG4)->getSingleScalarResult(),
			"solG5" => $em->createQuery($querySolG5)->getSingleScalarResult(),
			"solG6" => $em->createQuery($querySolG6)->getSingleScalarResult(),
			"viuG1" => $em->createQuery($queryViuG1)->getSingleScalarResult(),
			"viuG2" => $em->createQuery($queryViuG2)->getSingleScalarResult(),
			"viuG3" => $em->createQuery($queryViuG3)->getSingleScalarResult(),
			"viuG4" => $em->createQuery($queryViuG4)->getSingleScalarResult(),
			"viuG5" => $em->createQuery($queryViuG5)->getSingleScalarResult(),
			"viuG6" => $em->createQuery($queryViuG6)->getSingleScalarResult(),
			"divG1" => $em->createQuery($queryDivG1)->getSingleScalarResult(),
			"divG2" => $em->createQuery($queryDivG2)->getSingleScalarResult(),
			"divG3" => $em->createQuery($queryDivG3)->getSingleScalarResult(),
			"divG4" => $em->createQuery($queryDivG4)->getSingleScalarResult(),
			"divG5" => $em->createQuery($queryDivG5)->getSingleScalarResult(),
			"divG6" => $em->createQuery($queryDivG6)->getSingleScalarResult(),
			"uniG1" => $em->createQuery($queryUniG1)->getSingleScalarResult(),
			"uniG2" => $em->createQuery($queryUniG2)->getSingleScalarResult(),
			"uniG3" => $em->createQuery($queryUniG3)->getSingleScalarResult(),
			"uniG4" => $em->createQuery($queryUniG4)->getSingleScalarResult(),
			"uniG5" => $em->createQuery($queryUniG5)->getSingleScalarResult(),
			"uniG6" => $em->createQuery($queryUniG6)->getSingleScalarResult(),
			"otrG1" => $em->createQuery($queryOtrG1)->getSingleScalarResult(),
			"otrG2" => $em->createQuery($queryOtrG2)->getSingleScalarResult(),
			"otrG3" => $em->createQuery($queryOtrG3)->getSingleScalarResult(),
			"otrG4" => $em->createQuery($queryOtrG4)->getSingleScalarResult(),
			"otrG5" => $em->createQuery($queryOtrG5)->getSingleScalarResult(),
			"otrG6" => $em->createQuery($queryOtrG6)->getSingleScalarResult()
		];

		$html = $this->renderView('@Administrador/Tablas/estciv.pacientes.html.twig', array(
            "pacientes" => $reporte
        ));
        return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html), date("YmdHis").'Pacientes-EstadoCivil.pdf');

		/*$spreadsheet = new Spreadsheet();
        
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->mergeCells("A1:A2");
        $sheet->mergeCells("B1:B2");
        $sheet->setCellValue("B1", "Total");
        $sheet->mergeCells("C1:H1");
        $sheet->setCellValue("C1", "Grupo de Edad");

        $sheet->setCellValue("C2", "0 - 5");
        $sheet->setCellValue("D2", "6 - 14");
        $sheet->setCellValue("E2", "15 - 19");
        $sheet->setCellValue("F2", "20 - 44");
        $sheet->setCellValue("G2", "45 - 64");
        $sheet->setCellValue("H2", "65+");

        $sheet->setCellValue("A3", "Casado(a)");
        $sheet->setCellValue("A4", "Soltero(a)");
        $sheet->setCellValue("A5", "Viudo(a)");
        $sheet->setCellValue("A6", "Divorciado(a)");
        $sheet->setCellValue("A7", "Union Libre");
        $sheet->setCellValue("A8", "Otros");

        $sheet->setCellValue("B3", $reporte["totCas"]);
        $sheet->setCellValue("B4", $reporte["totSol"]);
        $sheet->setCellValue("B5", $reporte["totViu"]);
        $sheet->setCellValue("B6", $reporte["totDiv"]);
        $sheet->setCellValue("B7", $reporte["totUni"]);
        $sheet->setCellValue("B8", $reporte["totOtr"]);

        $sheet->setCellValue("C3", $reporte["casG1"]);
        $sheet->setCellValue("C4", $reporte["solG1"]);
        $sheet->setCellValue("C5", $reporte["viuG1"]);
        $sheet->setCellValue("C6", $reporte["divG1"]);
        $sheet->setCellValue("C7", $reporte["uniG1"]);
        $sheet->setCellValue("C8", $reporte["otrG1"]);

        $sheet->setCellValue("D3", $reporte["casG2"]);
        $sheet->setCellValue("D4", $reporte["solG2"]);
        $sheet->setCellValue("D5", $reporte["viuG2"]);
        $sheet->setCellValue("D6", $reporte["divG2"]);
        $sheet->setCellValue("D7", $reporte["uniG2"]);
        $sheet->setCellValue("D8", $reporte["otrG2"]);

        $sheet->setCellValue("E3", $reporte["casG3"]);
        $sheet->setCellValue("E4", $reporte["solG3"]);
        $sheet->setCellValue("E5", $reporte["viuG3"]);
        $sheet->setCellValue("E6", $reporte["divG3"]);
        $sheet->setCellValue("E7", $reporte["uniG3"]);
        $sheet->setCellValue("E8", $reporte["otrG3"]);

        $sheet->setCellValue("F3", $reporte["casG4"]);
        $sheet->setCellValue("F4", $reporte["solG4"]);
        $sheet->setCellValue("F5", $reporte["viuG4"]);
        $sheet->setCellValue("F6", $reporte["divG4"]);
        $sheet->setCellValue("F7", $reporte["uniG4"]);
        $sheet->setCellValue("F8", $reporte["otrG4"]);

        $sheet->setCellValue("G3", $reporte["casG5"]);
        $sheet->setCellValue("G4", $reporte["solG5"]);
        $sheet->setCellValue("G5", $reporte["viuG5"]);
        $sheet->setCellValue("G6", $reporte["divG5"]);
        $sheet->setCellValue("G7", $reporte["uniG5"]);
        $sheet->setCellValue("G8", $reporte["otrG5"]);

        $sheet->setCellValue("H3", $reporte["casG6"]);
        $sheet->setCellValue("H4", $reporte["solG6"]);
        $sheet->setCellValue("H5", $reporte["viuG6"]);
        $sheet->setCellValue("H6", $reporte["divG6"]);
        $sheet->setCellValue("H7", $reporte["uniG6"]);
        $sheet->setCellValue("H8", $reporte["otrG6"]);

        $sheet->setTitle("Estado Civil Paciente");

        $writer = new Xls($spreadsheet);
        $fileName = 'PacientesEstadoCivil'.date("YmdHis").'.xls';
        
        /*$temp_file = tempnam(sys_get_temp_dir(), $fileName);  
        $writer->save($temp_file);
        return $this->file($temp_file, $fileName, ResponseHeaderBag::DISPOSITION_INLINE);

        $publicDirectory = $this->getParameter('excel_directory');
        $excelFilepath =  $publicDirectory . '/' . $fileName;
        $writer->save($excelFilepath);
        chmod($excelFilepath, 0777);
        return new Response($fileName);*/
	}

	/**
	 * @Route("/reportes/ubicacion/export/", name="reporteUbicacionAdmExport")
	 */
	public function reporteUbicacionExport()
	{
		$em = $this->getDoctrine()->getManager();
		$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";
		$pacientes = $em->createQuery($query)->getResult();

		$html = $this->renderView('@Administrador/Tablas/ubicacionpacientes.html.twig', array(
            "pacientes" => $pacientes
        ));
        return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html), date("YmdHis").'Pacientes-Ubicacion.pdf');

		/*//$spreadsheet = new Spreadsheet();
		$spreadsheet = $this->get('phpspreadsheet')->createSpreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue("A1", "Paciente");
        $sheet->setCellValue("B1", "Medico");
        $sheet->setCellValue("C1", "Provincia");
        $sheet->setCellValue("D1", "Canton");
        $sheet->setCellValue("E1", "Parroquia");
        $sheet->setCellValue("F1", "Direccion");

        if($pacientes)
        {
        	$contador = 2;
        	foreach($pacientes as $row)
        	{
		        $sheet->setCellValue("A".$contador, $row->getIdUsuario()->getNombre().' '.$row->getIdUsuario()->getApellido());
		        $sheet->setCellValue("B".$contador, $row->getIdMedico()->getIdUsuario()->getNombre().' '.$row->getIdMedico()->getIdUsuario()->getApellido());
		        $sheet->setCellValue("C".$contador, $row->getIdParroquia()->getIdCanton()->getIdProvincia()->getNombre());
		        $sheet->setCellValue("D".$contador, $row->getIdParroquia()->getIdCanton()->getNombre());
		        $sheet->setCellValue("E".$contador, $row->getIdParroquia()->getNombre());
		        $sheet->setCellValue("F".$contador, $row->getDireccion());

		        $contador++;
        	}
        }
        $sheet->setTitle("Ubicacion Pacientes");
        $fileName = 'PacientesUbicacion'.date("YmdHis").'.xls';

        /*$writer = new Xls($spreadsheet);
        $temp_file = tempnam(sys_get_temp_dir(), $fileName);
        $writer->save($temp_file);
        return $this->file($temp_file, $fileName, ResponseHeaderBag::DISPOSITION_INLINE);
        
        $publicDirectory = $this->getParameter('excel_directory');
        $excelFilepath =  $publicDirectory . '/' . $fileName;
        $writer->save($excelFilepath);
        chmod($excelFilepath, 0777);
        return new Response($fileName);*/
	}

	/**
	 * @Route("/reportes/seguro/export/", name="reporteSeguroAdmExport")
	 */
	public function reporteSeguroExport()
	{
		$em = $this->getDoctrine()->getManager();
		$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";
		$pacientes = $em->createQuery($query)->getResult();

		if($pacientes)
		{
			foreach($pacientes as $row)
			{
				$edad = "";
                if($row->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($row->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y')." años";
                }
				$arrayEdad[] = $edad;
			}
		}
		else
			$arrayEdad[] = ""; 

		$html = $this->renderView('@Administrador/Tablas/seguro.pacientes.html.twig', array(
            "pacientes" => $pacientes, "edad" => $arrayEdad
        ));
        return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html), date("YmdHis").'Pacientes-Seguro.pdf');

		/*$spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue("A1", "Medico");
        $sheet->setCellValue("B1", "Paciente");
        $sheet->setCellValue("C1", "Cedula");
        $sheet->setCellValue("D1", "Edad");
        $sheet->setCellValue("E1", "Ocupacion");
        $sheet->setCellValue("F1", "Aseguradora");

        if($pacientes)
        {
        	$contador = 2;
        	foreach($pacientes as $row)
        	{
        		$edad = "";
                if($row->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($row->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y')." años";
                }

        		$sheet->setCellValue("A".$contador, $row->getIdMedico()->getIdUsuario()->getNombre().' '.$row->getIdMedico()->getIdUsuario()->getApellido());
		        $sheet->setCellValue("B".$contador, $row->getIdUsuario()->getNombre().' '.$row->getIdUsuario()->getApellido());
		        $sheet->setCellValue("C".$contador, $row->getIdUsuario()->getCedula());
		        $sheet->setCellValue("D".$contador, $edad);
		        $sheet->setCellValue("E".$contador, $row->getOcupacion());
		        $sheet->setCellValue("F".$contador, $row->getAseguradora());

		        $contador++;
        	}
        }
        $sheet->setTitle("Aseguradora Pacientes");

        $writer = new Xls($spreadsheet);
        $fileName = 'PacientesAseguradora'.date("YmdHis").'.xls';
        /*$temp_file = tempnam(sys_get_temp_dir(), $fileName);
        chmod($temp_file, 0777);
        $writer->save($temp_file);
        return $this->file($temp_file, $fileName, ResponseHeaderBag::DISPOSITION_INLINE);

        $publicDirectory = $this->getParameter('excel_directory');
        $excelFilepath =  $publicDirectory . '/' . $fileName;
        $writer->save($excelFilepath);
        chmod($excelFilepath, 0777);
        return new Response($fileName);*/
	}

	/**
	 * @Route("/reportes/total/export/", name="reporteTotalAdmExport")
	 */
	public function reportePacTotalExport()
	{
		$em = $this->getDoctrine()->getManager();
		$query = "select p from AdministradorBundle:Paciente p, LoginBundle:Usuario u where p.idUsuario = u.id and u.estado = true";
		$pacientes = $em->createQuery($query)->getResult();

		if($pacientes)
		{
			foreach($pacientes as $row)
			{
				$edad = "";
                if($row->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($row->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y')." años";
                }
				$arrayEdad[] = $edad;
			}
		}
		else
			$arrayEdad[] = ""; 

		$html = $this->renderView('@Administrador/Tablas/total.pacientes.html.twig', array(
            "pacientes" => $pacientes, "edad" => $arrayEdad
        ));
        return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html, array("orientation" => "Landscape")), date("YmdHis").'Pacientes-ReporteTotal.pdf');

		/*$spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue("A1", "Paciente");
        $sheet->setCellValue("B1", "Cedula");
        $sheet->setCellValue("C1", "Celular");
        $sheet->setCellValue("D1", "Telefono");
        $sheet->setCellValue("E1", "Email");
        $sheet->setCellValue("F1", "Fecha de Nacimiento");
        $sheet->setCellValue("G1", "Edad");
        $sheet->setCellValue("H1", "Estado Civil");
        $sheet->setCellValue("I1", "Genero");
        $sheet->setCellValue("J1", "Ocupacion");
        $sheet->setCellValue("K1", "Aseguradora");
        $sheet->setCellValue("L1", "Contacto");
        $sheet->setCellValue("M1", "Provincia");
        $sheet->setCellValue("N1", "Cantón");
        $sheet->setCellValue("O1", "Parroquia");
        $sheet->setCellValue("P1", "Sector");
        $sheet->setCellValue("Q1", "Direccion");
        $sheet->setCellValue("R1", "Medico");

		if($pacientes)
		{
			$contador = 2;
			foreach($pacientes as $row)
			{
				$edad = "";
                if($row->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($row->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y')." años";
                }

                $sheet->setCellValue("A".$contador, $row->getIdUsuario()->getNombre().' '.$row->getIdUsuario()->getApellido());
		        $sheet->setCellValue("B".$contador, $row->getIdUsuario()->getCedula());
		        $sheet->setCellValue("C".$contador, $row->getIdUsuario()->getTelefono());
		        $sheet->setCellValue("D".$contador, $row->getTelefono());
		        $sheet->setCellValue("E".$contador, $row->getIdUsuario()->getEmail());
		        $sheet->setCellValue("F".$contador, $row->getFechaNacimiento());
		        $sheet->setCellValue("G".$contador, $edad);
		        $sheet->setCellValue("H".$contador, $row->getEstadoCivil());
		        $sheet->setCellValue("I".$contador, $row->getGenero());
		        $sheet->setCellValue("J".$contador, $row->getOcupacion());
		        $sheet->setCellValue("K".$contador, $row->getAseguradora());
		        $sheet->setCellValue("L".$contador, $row->getContacto());
		        $sheet->setCellValue("M".$contador, $row->getIdParroquia()->getIdCanton()->getIdProvincia()->getNombre());
		        $sheet->setCellValue("N".$contador, $row->getIdParroquia()->getIdCanton()->getNombre());
		        $sheet->setCellValue("O".$contador, $row->getIdParroquia()->getNombre());
		        $sheet->setCellValue("P".$contador, $row->getSector());
		        $sheet->setCellValue("Q".$contador, $row->getDireccion());
		        $sheet->setCellValue("R".$contador, $row->getIdMedico()->getIdUsuario()->getNombre().' '.$row->getIdMedico()->getIdUsuario()->getApellido());

		        $contador++;
			}
		}
        $sheet->setTitle("Informacion Total Pacientes");
        $fileName = 'PacientesInfo'.date("YmdHis").'.xls';

        $writer = new Xls($spreadsheet);
        /*$temp_file = tempnam(sys_get_temp_dir(), $fileName);
        chmod($temp_file, 0777);
        $writer->save($temp_file);
        return $this->file($temp_file, $fileName, ResponseHeaderBag::DISPOSITION_INLINE);

        $publicDirectory = $this->getParameter('excel_directory');
        $excelFilepath =  $publicDirectory . '/' . $fileName;
        $writer->save($excelFilepath);
        chmod($excelFilepath, 0777);
        return new Response($fileName);*/
	}
}
