<?php

namespace AdministradorBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;


class ReportesController extends Controller
{
	/**
	 *@Route("/reporte/", name="homeRep")
	 */
	public function indexAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$usuario = $repository->find($request->getSession()->get("usuario"));
			
			return $this->render("@Administrador/Reportes/home.html.twig", array('usuario' => $usuario));
		}
	}

	/**
	 * @Route("/reporte/medicos/", name="repMedicos")
	 */
	public function medicAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$usuario = $repository->find($request->getSession()->get("usuario"));
			
			return $this->render("@Administrador/Reportes/medic.html.twig", array('usuario' => $usuario));
		}
	}

	/**
	 * @Route("/reporte/asistentes/", name="repAsistentes")
	 */
	public function asistentesAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$usuario = $repository->find($request->getSession()->get("usuario"));
			
			return $this->render("@Administrador/Reportes/asist.html.twig", array('usuario' => $usuario));
		}
	}

	/**
	 * @Route("/reporte/catalogos/medico/", name = "reporteCatalogoMedico")
	 */
	public function catalogMedicoAction()
	{
		$em = $this->getDoctrine()->getManager();
		$pag = $_POST["pagina"] * $_POST["cantidad"];

		$query = 'select m from AdministradorBundle:Medico m, LoginBundle:Usuario u where u.id = m.idUsuario order by m.fechaRegistro asc';
		$queryPag = "select count(m.id) from AdministradorBundle:Medico m, LoginBundle:Usuario u where u.id = m.idUsuario";

		if($_POST["buscar"] != "")
		{
			$query = "select m from AdministradorBundle:Medico m, LoginBundle:Usuario u where u.id = m.idUsuario and u.nombre like '%".$_POST["buscar"]."%' or u.id = m.idUsuario and u.apellido like '%".$_POST["buscar"]."%' order by m.fechaRegistro asc";
			$queryPag = "select count(m.id) from AdministradorBundle:Medico m, LoginBundle:Usuario u where u.id = m.idUsuario and u.nombre like '%".$_POST["buscar"]."%' or u.id = m.idUsuario and u.apellido like '%".$_POST["buscar"]."%'";
		}

		$usuario = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
		$total = $em->createQuery($queryPag)->getSingleScalarResult();

		$html = '<table class="table table-sm table-bordered" id="table_usuarios">
					<thead>
						<tr>
							<th><label>Nombre</label></th>
							<th><label>Fecha Registro</label></th>
							<th><label>Fecha Caducidad</label></th>
							<th><label>Días Restantes</label></th>
							<th><label>Licencia</label></th>
							<th><label>Estado</label></th>
							<th><label>Renovar Licencia (1 año)</label></th>
							<th><label>Semáforo</label></th>
						</tr>
					</thead>
					<tbody>';
		if($usuario)
		{
			foreach($usuario as $row)
			{
				$nombre = $row->getIdUsuario()->getNombre().' '.$row->getIdUsuario()->getApellido();
				$fechaRegistro = $row->getFechaRegistro();
				$fechaCaducidad = $row->getFechaCaducidad();
				
				$fecha1 = date_create(date("Y-m-d"));
	    		$fecha2 = date_create($fechaCaducidad);
				$resultado = date_diff($fecha1, $fecha2);
				$dias = explode("+", $resultado->format('%R%a'));
				$semaforo = "btn-warning";
				if($dias[1] <= 0)
					$semaforo = "btn-danger";

				if($row->getIdUsuario()->getEstado())
					$estado = "Activo";
				else
					$estado = "Inactivo";

				$html .= '<tr>
						    <td>'.$nombre.'</td>
							<td>'.$fechaRegistro.'</td>
							<td>'.$fechaCaducidad.'</td>
							<td>'.$dias[1].' días</td>
							<td>'.$row->getPeriodoLicencia()->getNombre().'</td>
							<td><button name="'.base64_encode($row->getIdUsuario()->getId()).'" class="btn '.(($row->getIdUsuario()->getEstado() == true) ? "btn-success" : "btn-danger").' btnEstado '.$estado.' u'.$row->getIdUsuario()->getId().' pad5 " '.(($dias[1] <= 30) ? "disabled" : "").' >'.$estado.'</button></td>
							<td><a href="#" name="'.base64_encode($row->getIdUsuario()->getId()).'" class="btn btn-primary '.(($dias[1] < 31) ? "btnRenovar" : "disabled").'" >Renovar</a></td>
							<td><a href="#" name="" class="btn '.(($dias[1] > 30) ? "btn-success" : $semaforo).' ">Semaforo</a></td>
						<tr>';
			}
		}
		$html .= '</tbody></table>';

		$paginas = ceil($total / $_POST["cantidad"]);
		$start = (($_POST["pagina"] - 5) > 0 ) ? $_POST["pagina"] - 5 : 0;
		$end = (($_POST["pagina"] + 5) < $paginas) ? $_POST["pagina"] + 5 : ($paginas-1);

		$html .= '<div class="d100 paginacion"><nav aria-label="">
		<ul class="pagination">
		  	<li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
		  		<a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
		        	<span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
		      	</a>
		    </li>';
	    if($start > 1)
		{
			$html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
		}

		for($i = $start; $i <= $end; $i++)
		{
			$html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
		}

		if($end < ($paginas-1))
		{
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			$html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
		}
		$html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
	      	<a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
	        	<span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
	      	</a>
	    </li>
		</ul></nav></div>';

		return new Response($html);
	}

	/**
	 * @Route("/reporte/catalogosRes/medico/", name="reporteCatalogosResMedico")
	 */
	public function catalogMedicoResAction()
	{
		$em = $this->getDoctrine()->getManager();
		$pag = $_POST["pagina"] * $_POST["cantidad"];

		$query = 'select m from AdministradorBundle:Medico m, LoginBundle:Usuario u where u.id = m.idUsuario order by m.fechaRegistro asc';
		$queryPag = "select count(m.id) from AdministradorBundle:Medico m, LoginBundle:Usuario u where u.id = m.idUsuario";

		if($_POST["buscar"] != "")
		{
			$query = "select m from AdministradorBundle:Medico m, LoginBundle:Usuario u where u.id = m.idUsuario and u.nombre like '%".$_POST["buscar"]."%' or u.id = m.idUsuario and u.apellido like '%".$_POST["buscar"]."%' order by m.fechaRegistro asc";
			$queryPag = "select count(m.id) from AdministradorBundle:Medico m, LoginBundle:Usuario u where u.id = m.idUsuario and u.nombre like '%".$_POST["buscar"]."%' or u.id = m.idUsuario and u.apellido like '%".$_POST["buscar"]."%'";
		}
		
		$usuario = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
		$total = $em->createQuery($queryPag)->getSingleScalarResult();

		$html = '<table class="table table-sm table-bordered" id="table_usuarios_responsive">';
		if($usuario)
		{
			foreach($usuario as $row)
			{
				$nombre = $row->getIdUsuario()->getNombre().' '.$row->getIdUsuario()->getApellido();
				$fechaRegistro = $row->getFechaRegistro();
				$fechaCaducidad = $row->getFechaCaducidad();
				
				$fecha1 = date_create(date("Y-m-d"));
	    		$fecha2 = date_create($fechaCaducidad);
				$resultado = date_diff($fecha1, $fecha2);
				$dias = explode("+", $resultado->format('%R%a'));
				$semaforo = "btn-warning";
				if($dias[1] <= 0)
					$semaforo = "btn-danger";

				if($row->getIdUsuario()->getEstado())
					$estado = "Activo";
				else
					$estado = "Inactivo";

				$html .= '<tbody>
					<tr>
						<th width="30%"><label>Nombre</label></th>
						<td width="70%">'.$nombre.'</td>
					</tr>
					<tr>
						<th width="30%"><label>Fecha Registro</label></th>
						<td width="70%">'.$fechaRegistro.'</td>
					</tr>
					<tr>
						<th width="30%"><label>Fecha Caducidad</label></th>
						<td width="70%">'.$fechaCaducidad.'</td>
					</tr>
					<tr>
						<th width="30%"><label>Días Restantes</label></th>
						<td width="70%">'.$dias[1].' días</td>
					</tr>
					<tr>
						<th width="30%"><label>Licencia</label></th>
						<td width="70%">'.$row->getPeriodoLicencia()->getNombre().'</td>
					</tr>
					<tr>
						<th width="30%"><label>Estado</label></th>
						<td width="70%"><button name="'.base64_encode($row->getIdUsuario()->getId()).'" class="btn '.(($row->getIdUsuario()->getEstado() == true) ? "btn-success" : "btn-danger").' btnEstado '.$estado.' u'.$row->getId().' " '.(($dias[1] <= 30) ? "disabled" : "").'>'.$estado.'</button></td>
					</tr>
					<tr>
						<th width="30%"><label>Renovar Licencia (1 año)</label></th>
						<td width="70%"><a href="#" name="'.base64_encode($row->getIdUsuario()->getId()).'" class="btn btn-primary '.(($dias[1] < 31) ? "btnRenovar" : "disabled").'" >Renovar</a></td>
					</tr>
					<tr>
						<th width="30%"><label>Semáforo</label></th>
						<td width="70%"><a href="#" name="" class="btn '.(($dias[1] > 30) ? "btn-success" : $semaforo).'">Semaforo</a></td>
					</tr>
				</tbody>';
			}
		}
		$html .= '</table>';

		$paginas = ceil($total / $_POST["cantidad"]);
		$start = (($_POST["pagina"] - 3) > 0 ) ? $_POST["pagina"] - 3 : 0;
		$end = (($_POST["pagina"] + 3) < $paginas) ? $_POST["pagina"] + 3 : ($paginas-1);

		$html .= '<div class="d100 paginacion_responsive"><nav aria-label="">
		<ul class="pagination">
		  	<li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
		  		<a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
		        	<span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
		      	</a>
		    </li>';
	    if($start > 1)
		{
			$html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
		}

		for($i = $start; $i <= $end; $i++)
		{
			$html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
		}

		if($end < ($paginas-1))
		{
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			$html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
		}
		$html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
	      	<a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
	        	<span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
	      	</a>
	    </li></ul></nav></div>';

		return new Response($html);
	}

	/**
	 * @Route("/reporte/catalogos/asistente/", name = "reporteCatalogoAsistente")
	 */
	public function catalogAsistenteAction()
	{
		$em = $this->getDoctrine()->getManager();
		$pag = $_POST["pagina"] * $_POST["cantidad"];

		$query = 'select a from AdministradorBundle:Asistente a, LoginBundle:Usuario u where u.id = a.idUsuario order by a.fechaRegistro asc';
		$queryPag = "select count(a.id) from AdministradorBundle:Asistente a, LoginBundle:Usuario u where u.id = a.idUsuario";

		if($_POST["buscar"] != "")
		{
			$query = "select a from AdministradorBundle:Asistente a, LoginBundle:Usuario u where u.id = a.idUsuario and u.nombre like '%".$_POST["buscar"]."%' or u.id = a.idUsuario and u.apellido like '%".$_POST["buscar"]."%' order by a.fechaRegistro asc";
			$queryPag = "select count(a.id) from AdministradorBundle:Asistente a, LoginBundle:Usuario u where u.id = a.idUsuario and u.nombre like '%".$_POST["buscar"]."%' or u.id = a.idUsuario and u.apellido like '%".$_POST["buscar"]."%'";
		}

		$usuario = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
		$total = $em->createQuery($queryPag)->getSingleScalarResult();

		$html = '<table class="table table-sm table-bordered" id="table_usuarios">
					<thead>
						<tr>
							<th><label>Nombre</label></th>
							<th><label>Fecha Registro</label></th>
							<th><label>Fecha Caducidad</label></th>
							<th><label>Días Restantes</label></th>
							<th><label>Licencia</label></th>
							<th><label>Estado</label></th>
							<th><label>Renovar Licencia (1 año)</label></th>
							<th><label>Semáforo</label></th>
						</tr>
					</thead>
					<tbody>';
		if($usuario)
		{
			foreach($usuario as $row)
			{
				$nombre = $row->getIdUsuario()->getNombre().' '.$row->getIdUsuario()->getApellido();
				$fechaRegistro = $row->getFechaRegistro();
				$fechaCaducidad = $row->getFechaCaducidad();
				
				$fecha1 = date_create(date("Y-m-d"));
	    		$fecha2 = date_create($fechaCaducidad);
				$resultado = date_diff($fecha1, $fecha2);
				$dias = explode("+", $resultado->format('%R%a'));
				$semaforo = "btn-warning";
				if($dias[1] <= 0)
					$semaforo = "btn-danger";

				if($row->getIdUsuario()->getEstado())
					$estado = "Activo";
				else
					$estado = "Inactivo";

				$html .= '<tr>
						    <td><a name="'.$row->getIdUsuario()->getId().'" class="btnAsistente btn btn-link pad0">'.$nombre.'</a></td>
							<td>'.$fechaRegistro.'</td>
							<td>'.$fechaCaducidad.'</td>
							<td>'.$dias[1].' días</td>
							<td>'.$row->getPeriodoLicencia()->getNombre().'</td>
							<td><button name="'.base64_encode($row->getIdUsuario()->getId()).'" class="btn '.(($row->getIdUsuario()->getEstado() == true) ? "btn-success" : "btn-danger").' btnEstado '.$estado.' u'.$row->getIdUsuario()->getId().' pad5 " '.(($dias[1] <= 30) ? "disabled" : "").' >'.$estado.'</button></td>
							<td><a href="#" name="'.base64_encode($row->getIdUsuario()->getId()).'" class="btn btn-primary '.(($dias[1] < 31) ? "btnRenovar" : "disabled").'" >Renovar</a></td>
							<td><a href="#" name="" class="btn '.(($dias[1] > 30) ? "btn-success" : $semaforo).' ">Semaforo</a></td>
						<tr>';
			}
		}
		$html .= '</tbody></table>';

		$paginas = ceil($total / $_POST["cantidad"]);
		$start = (($_POST["pagina"] - 5) > 0 ) ? $_POST["pagina"] - 5 : 0;
		$end = (($_POST["pagina"] + 5) < $paginas) ? $_POST["pagina"] + 5 : ($paginas-1);

		$html .= '<div class="d100 paginacion"><nav aria-label="">
		<ul class="pagination">
		  	<li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
		  		<a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
		        	<span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
		      	</a>
		    </li>';
	    if($start > 1)
		{
			$html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
		}

		for($i = $start; $i <= $end; $i++)
		{
			$html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
		}

		if($end < ($paginas-1))
		{
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			$html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
		}
		$html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
	      	<a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
	        	<span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
	      	</a>
	    </li>
		</ul></nav></div>';

		return new Response($html);
	}

	/**
	 * @Route("/reporte/catalogosRes/asistente/", name="reporteCatalogosResAsistente")
	 */
	public function catalogAsistenteResAction()
	{
		$em = $this->getDoctrine()->getManager();
		$pag = $_POST["pagina"] * $_POST["cantidad"];

		$query = 'select a from AdministradorBundle:Asistente a, LoginBundle:Usuario u where u.id = a.idUsuario order by a.fechaRegistro asc';
		$queryPag = "select count(a.id) from AdministradorBundle:Asistente a, LoginBundle:Usuario u where u.id = a.idUsuario";

		if($_POST["buscar"] != "")
		{
			$query = "select a from AdministradorBundle:Asistente a, LoginBundle:Usuario u where u.id = a.idUsuario and u.nombre like '%".$_POST["buscar"]."%' or u.id = a.idUsuario and u.apellido like '%".$_POST["buscar"]."%' order by a.fechaRegistro asc";
			$queryPag = "select count(a.id) from AdministradorBundle:Asistente a, LoginBundle:Usuario u where u.id = a.idUsuario and u.nombre like '%".$_POST["buscar"]."%' or u.id = a.idUsuario and u.apellido like '%".$_POST["buscar"]."%'";
		}
		
		$usuario = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
		$total = $em->createQuery($queryPag)->getSingleScalarResult();

		$html = '<table class="table table-sm table-bordered" id="table_usuarios_responsive">';
		if($usuario)
		{
			foreach($usuario as $row)
			{
				$nombre = $row->getIdUsuario()->getNombre().' '.$row->getIdUsuario()->getApellido();
				$fechaRegistro = $row->getFechaRegistro();
				$fechaCaducidad = $row->getFechaCaducidad();
				
				$fecha1 = date_create(date("Y-m-d"));
	    		$fecha2 = date_create($fechaCaducidad);
				$resultado = date_diff($fecha1, $fecha2);
				$dias = explode("+", $resultado->format('%R%a'));
				$semaforo = "btn-warning";
				if($dias[1] <= 0)
					$semaforo = "btn-danger";

				if($row->getIdUsuario()->getEstado())
					$estado = "Activo";
				else
					$estado = "Inactivo";

				$html .= '<tbody>
					<tr>
						<th width="30%"><label>Nombre</label></th>
						<td width="70%"><a name="'.$row->getIdUsuario()->getId().'" class="btnAsistente btn btn-link pad0">'.$nombre.'</a></td>
					</tr>
					<tr>
						<th width="30%"><label>Fecha Registro</label></th>
						<td width="70%">'.$fechaRegistro.'</td>
					</tr>
					<tr>
						<th width="30%"><label>Fecha Caducidad</label></th>
						<td width="70%">'.$fechaCaducidad.'</td>
					</tr>
					<tr>
						<th width="30%"><label>Días Restantes</label></th>
						<td width="70%">'.$dias[1].' días</td>
					</tr>
					<tr>
						<th width="30%"><label>Licencia</label></th>
						<td width="70%">'.$row->getPeriodoLicencia()->getNombre().'</td>
					</tr>
					<tr>
						<th width="30%"><label>Estado</label></th>
						<td width="70%"><button name="'.base64_encode($row->getIdUsuario()->getId()).'" class="btn '.(($row->getIdUsuario()->getEstado() == true) ? "btn-success" : "btn-danger").' btnEstado '.$estado.' u'.$row->getIdUsuario()->getId().' " '.(($dias[1] <= 30) ? "disabled" : "").'>'.$estado.'</button></td>
					</tr>
					<tr>
						<th width="30%"><label>Renovar Licencia (1 año)</label></th>
						<td width="70%"><a href="#" name="'.base64_encode($row->getIdUsuario()->getId()).'" class="btn btn-primary '.(($dias[1] < 31) ? "btnRenovar" : "disabled").'" >Renovar</a></td>
					</tr>
					<tr>
						<th width="30%"><label>Semáforo</label></th>
						<td width="70%"><a href="#" name="" class="btn '.(($dias[1] > 30) ? "btn-success" : $semaforo).'">Semaforo</a></td>
					</tr>
				</tbody>';
			}
		}
		$html .= '</table>';

		$paginas = ceil($total / $_POST["cantidad"]);
		$start = (($_POST["pagina"] - 3) > 0 ) ? $_POST["pagina"] - 3 : 0;
		$end = (($_POST["pagina"] + 3) < $paginas) ? $_POST["pagina"] + 3 : ($paginas-1);

		$html .= '<div class="d100 paginacion_responsive"><nav aria-label="">
		<ul class="pagination">
		  	<li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
		  		<a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
		        	<span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
		      	</a>
		    </li>';
	    if($start > 1)
		{
			$html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
		}

		for($i = $start; $i <= $end; $i++)
		{
			$html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
		}

		if($end < ($paginas-1))
		{
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			$html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
		}
		$html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
	      	<a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
	        	<span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
	      	</a>
	    </li></ul></nav></div>';

		return new Response($html);
	}

	/**
	 * @Route("/reporte/medicoasistente/{idUsuario}")
	 */
	public function medicoAsistenteAction($idUsuario)
	{
		$em = $this->getDoctrine()->getManager();
		$asistente = $em->getRepository("LoginBundle:Usuario")->find($idUsuario);
		$medicoAsistente = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $asistente->getIdAsistente()->getId()));

		$html = '<div id="tablaMedicoAsistente" class="d100 pad10 table table-striped table-bordered mar0">
			    	<div class="d50">
			    		<div class="d100">
			    			<p style="margin:0px;" class="icon-user" aria-hidden="true"><strong>'.$asistente->getLogin().' - '.$asistente->getNombre().' '.$asistente->getApellido().'</strong></p>
			    			<input type="hidden" name="usuario" id="inputUsuario" value="'.$asistente->getId().'">
			    			<input type="hidden" name="asistente" id="inputAsistente" value="'.$asistente->getIdAsistente()->getId().'">
			    		</div>
			    	</div>
			    	<div class="d50 pad10">';
			    	foreach($medicoAsistente as $row)
			    	{
			    		$usuario = $em->getRepository("LoginBundle:Usuario")->findBy(array("idMedico" => $row->getIdMedico()->getId()));
			    		$html .= '<div class="d100 pad5 table table-striped table-bordered mar0">
			    			<div class="d100"><label>'.$usuario[0]->getNombre().' '.$usuario[0]->getApellido().'</label></div>
			    			<a href="#" name="'.$row->getIdMedico()->getId().'" class="btnDesvicular btn btn-info">Desvicular</a>
			    		</div>';
			    	}
		$html .= ' 	</div>
			    </div>';
		return new Response($html);
	}
}
