<?php

namespace AdministradorBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AdministradorBundle\Entity\Noticas;

class NoticiasController extends Controller
{
	/**
	 * @Route("/nuevas/noticias/", name="nuevasNoticias")
	 */
	public function indexAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
			
			return $this->render("@Administrador/Noticias/index.html.twig", array('usuario' => $usuario));
		}
	}

	/**
	 * @Route("/crear/noticias/", name="crearNoticias")
	 */
	public function createNoticia(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$administrador = $em->getRepository("AdministradorBundle:Administrador")->findOneBy(array("idUsuario" => $request->getSession()->get("usuario")));

		$noticia = new Noticas();
		$noticia->setTitulo($_POST["titulo"]);
		$noticia->setTexto($_POST["texto"]);
		$noticia->setImagen($_POST["imagen"]);
		$noticia->setFecha(date("Y-m-d"));
		$noticia->setIdAdministrador($administrador);
		$noticia->setEstado(true);

		$em->persist($noticia);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/noticia/imagen/", name="imagenNoticia")
	 */
	public function subirImagenNoticia()
	{
		$imagen = $_FILES["flImagen"];
		$nombreImage = md5(date("YmdHis")).".png";
		$rutaImagen = "6973e3e05f3cea01fbdedd4/noticias/".$nombreImage;
		$subir = move_uploaded_file($imagen["tmp_name"], $rutaImagen);
		//$subir = $imagen->move($_POST["inputRuta"], $nombreImage);

		if($subir)
		{
			chmod($rutaImagen, 0777);
			$this->redimensionar_imagen($rutaImagen);
			return new Response($nombreImage);
		}
		else
			return new Response("nok");
	}

	function redimensionar_imagen($rutaImagenOriginal)
	{
		$img_original = imagecreatefromjpeg($rutaImagenOriginal);
		
		$max_ancho = 500;
		$max_alto = 500;
		
		list($ancho, $alto) = getimagesize($rutaImagenOriginal);
		
		$tmp_img = imagecreatetruecolor($max_ancho, $max_alto);	
		
		imagecopyresampled($tmp_img, $img_original, 0, 0, 0, 0, $max_ancho, $max_alto, $ancho, $alto);
		
		imagedestroy($img_original);
		
		$calidad = 95;
		
		imagejpeg($tmp_img, $rutaImagenOriginal, $calidad);
	}

}
