<?php

namespace AdministradorBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AdministradorBundle\Entity\Especialidades;

class EspecialidadesController extends Controller
{
	/**
	 * @Route("/especialidades/", name="homeEspecialidades")
	 */
	public function indexAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$usuario = $repository->find($request->getSession()->get("usuario"));
			return $this->render("@Administrador/Especialidades/index.html.twig", array("usuario" => $usuario));
		}
	}

	/**
	 * @Route("/especialidades/list/", name="catalogEspecialidades")
	 */
	public function listEspecialidadesAction()
	{
		$em = $this->getDoctrine()->getManager();

		$pag = $_POST["pagina"] * $_POST["cantidad"];
		$query = "select e from AdministradorBundle:Especialidades e where e.estado = true";
		$especialidades = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
		$queryPag = "select count(e.id) from AdministradorBundle:Especialidades e where e.estado = true";
		$total = $em->createQuery($queryPag)->getSingleScalarResult();

		$html = '<table class="table table-bordered">
		<thead>
			<tr>
				<th><label>Código</label></th>
				<th><label>Nombre</label></th>
				<th></th>
				<th></th>
			</tr>
		</thead>
		<tbody>';
		if($especialidades)
		{
			foreach($especialidades as $row)
			{
				$html .= '<tr>
					<td>'.$row->getCodigo().'</td>
					<td>'.$row->getNombre().'</td>
					<td><a href="./edit/'.base64_encode($row->getId()).'" class="btn btn-primary btnEditar">Editar</a></td>
					<td><a href="#" name="'.base64_encode($row->getId()).'" class="btn btn-danger btnEliminar">Eliminar</a></td>
				</tr>';
			}
		}
		$html .= '</tbody></table>';

		$paginas = ceil($total / $_POST["cantidad"]);
		$start = (($_POST["pagina"] - 5) > 0 ) ? $_POST["pagina"] - 5 : 0;
		$end = (($_POST["pagina"] + 5) < $paginas) ? $_POST["pagina"] + 5 : ($paginas-1);

		$html .= '<div class="d100 paginacion"><nav aria-label="">
		<ul class="pagination">
		  	<li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
		  		<a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
		        	<span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
		      	</a>
		    </li>';
	    if($start > 1)
		{
			$html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
		}

		for($i = $start; $i <= $end; $i++)
		{
			$html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
		}

		if($end < ($paginas-1))
		{
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			$html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
		}
		$html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
	      	<a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
	        	<span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
	      	</a>
	    </li>
		</ul></nav></div>';

		return new Response($html);
	}

	/**
	 * @Route("/especialidades/listResp/", name="catalogRespEspecialidades")
	 */
	public function listRespEspecialidadesAction()
	{
		$em = $this->getDoctrine()->getManager();
		
		$pag = $_POST["pagina"] * $_POST["cantidad"];
		$query = "select e from AdministradorBundle:Especialidades e where e.estado = true";
		$especialidades = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
		$queryPag = "select count(e.id) from AdministradorBundle:Especialidades e where e.estado = true";
		$total = $em->createQuery($queryPag)->getSingleScalarResult();

		$html = '<table class="table table-bordered">';
		if($especialidades)
		{
			foreach($especialidades as $row)
			{
				$html .= '<tbody>
				<tr><th>Código</th><td>'.$row->getCodigo().'</td></tr>
				<tr><th>Nombre</th><td>'.$row->getNombre().'</td></tr>
				<tr><td colspan="2">
					<a href="./edit/'.base64_encode($row->getId()).'" class="btn btn-primary btnEditar">Editar</a>
					&nbsp;
					<a href="#" name="'.base64_encode($row->getId()).'" class="btn btn-danger btnEliminar">Eliminar</a>
				</td></tr>
				</tbody>';
			}
		}
		$html .= '</table>';

		$paginas = ceil($total / $_POST["cantidad"]);
		$start = (($_POST["pagina"] - 3) > 0 ) ? $_POST["pagina"] - 3 : 0;
		$end = (($_POST["pagina"] + 3) < $paginas) ? $_POST["pagina"] + 3 : ($paginas-1);

		$html .= '<div class="d100 paginacion_responsive"><nav aria-label="">
		<ul class="pagination">
		  	<li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
		  		<a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
		        	<span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
		      	</a>
		    </li>';
	    if($start > 1)
		{
			$html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
		}

		for($i = $start; $i <= $end; $i++)
		{
			$html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
		}

		if($end < ($paginas-1))
		{
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			$html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
		}
		$html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
	      	<a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
	        	<span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
	      	</a>
	    </li></ul></nav></div>';

		return new Response($html);
	}

	/**
	 * @Route("/especialidades/create/", name="createEspecialidades")
	 */
	public function createAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$usuario = $repository->find($request->getSession()->get("usuario"));
			return $this->render("@Administrador/Especialidades/create.html.twig", array("usuario" => $usuario));
		}
	}

	/**
	 * @Route("/especialidades/store/", name="storeEspecialidades")
	 */
	public function storeAction()
	{
		$em = $this->getDoctrine()->getManager();
		$especialidad = new Especialidades();
		$especialidad->setCodigo($_POST["codigo"]);
		$especialidad->setNombre($_POST["nombre"]);
		$especialidad->setEstado(true);

		$em->persist($especialidad);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/especialidades/edit/{esp}", name="editEspecialidades")
	 */
	public function editAction(Request $request, $esp)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$usuario = $repository->find($request->getSession()->get("usuario"));

			$especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find(base64_decode($esp));

			return $this->render("@Administrador/Especialidades/edit.html.twig", array("usuario" => $usuario, "especialidad" => $especialidad));
		}
	}

	/**
	 * @Route("/especialidades/update/", name="updateEspecialidades")
	 */
	public function updateAction()
	{
		$em = $this->getDoctrine()->getManager();
		$especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find($_POST["id"]);
		$especialidad->setCodigo($_POST["codigo"]);
		$especialidad->setNombre($_POST["nombre"]);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/especialidades/delete/", name="deleteEspecialidades")
	 */
	public function deleteAction()
	{
		$em = $this->getDoctrine()->getManager();
		$especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find($_POST["id"]);
		$especialidad->setEstado(false);

		$em->flush();

		return new Response("ok");
	}
}
