<?php

namespace AdministradorBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AdministradorBundle\Entity\ChatPromocion;

class ChatPromocionController extends Controller
{
	/**
	 * @Route("/chat/promocion/", name="chatPromocion")
	 */
	public function indexAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$usuario = $repository->find($request->getSession()->get("usuario"));
			$especialidades = $em->getRepository("AdministradorBundle:Especialidades")->findBy(array("estado" => true));
			
			return $this->render("@Administrador/Chat/index.html.twig", array("usuario" => $usuario, "especialidades" => $especialidades));
		}
	}

	/**
	 * @Route("/chat/promocion/create", name="createChatPromocion")
	 */
	public function createChatPromocion()
	{
		$em = $this->getDoctrine()->getManager();
		$administrador = $em->getRepository("AdministradorBundle:Administrador")->findOneBy(array("idUsuario" => $_POST["idUsuario"]));
		$queryEsp = "select me from AdministradorBundle:MedicoEspecialidad me where me.idEspecialidad in (".$_POST["especialidades"].")";
		$especialidades = $em->createQuery($queryEsp)->getResult();
		foreach($especialidades as $row)
		{
			$chat = new ChatPromocion();
			$chat->setIdAdministrador($administrador);
			$chat->setIdMedico($row->getIdMedico());
			$chat->setMensajePromocion($_POST["mensaje"]);
			//$chat->setImagenPromocion($_POST["imagen"]);
			//$chat->setUrlRedireccion();
			$chat->setEstado(false);

			$em->persist($chat);
		}
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/chat/promocion/read/", name="chatPromocionRead")
	 */
	public function getNotificacionChatPromo(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
		$notificaciones = $em->getRepository("AdministradorBundle:ChatPromocion")->findBy(array("idMedico" => $usuario->getIdMedico()->getId(), "estado" => false));

		return new Response(count($notificaciones));
	}
}
