<?php

namespace AdministradorBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use LoginBundle\Entity\Usuario;
use LoginBundle\Entity\Rol;
use AdministradorBundle\Entity\Administrador;
use AdministradorBundle\Entity\Medico;
use AdministradorBundle\Entity\Institucion;
use AdministradorBundle\Entity\Asistente;
use AdministradorBundle\Entity\Paciente;
use AdministradorBundle\Entity\MedicoEspecialidad;
use AdministradorBundle\Entity\AsistenteMedico;
use AgendaBundle\Entity\Agenda;
use AgendaBundle\Entity\Documentos;

class AdminController extends Controller
{
	/**
	 * @Route("/home/", name="catalogAdmin")
	 */
	public function indexAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$usuario = $repository->find($request->getSession()->get("usuario"));
			
			return $this->render("@Administrador/Default/admin.html.twig", array('usuario' => $usuario));
		}
	}

	/**
	 * @Route("/listUser/", name="listUserAdmin")
	 */
	public function listUserAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$admin = $repository->find($request->getSession()->get("usuario"));
			$usuarios = $repository->findAll();
			
			return $this->render("@Administrador/Default/catalog.html.twig", array('usuario' => $admin));
		}
	}

	/**
	 * @Route("/contenidos/", name="homeContenidos")
	 */
	public function contenidosAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
			
			return $this->render("@Administrador/Default/contenido.html.twig", array('usuario' => $usuario));
		}
	}

	/**
	 * @Route("/user/cedula/", name="userCedula")
	 */
	public function getUserByCedula()
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->findOneBy(array("cedula" => $_POST["cedula"]));
		$json = [
			"success" => false
		];
		if($usuario)
		{
			$json = [
				"success" => true,
				"id" => $usuario->getId(),
				"nombre" => $usuario->getNombre(),
				"apellido" => $usuario->getApellido(),
				"cedula" => $usuario->getCedula(),
				"login" => $usuario->getLogin(),
				"rol" => $usuario->getRolUsuario()->getId()
			];
		}
		return new Response(json_encode($json));
	}

	/**
	 * @Route("/user/loginusuario/", name="userLogin")
	 */
	public function getUserByLoginUsuario()
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->findOneBy(array("login" => $_POST["loginusuario"]));
		$json = [
			"success" => false
		];
		if($usuario)
		{
			$json = [
				"success" => true,
				"id" => $usuario->getId(),
				"nombre" => $usuario->getNombre(),
				"apellido" => $usuario->getApellido(),
				"cedula" => $usuario->getCedula(),
				"login" => $usuario->getLogin(),
				"rol" => $usuario->getRolUsuario()->getId()
			];
		}
		return new Response(json_encode($json));
	}

	/**
	 * @Route("/catalog/", name="catalogUsuer")
	 */
	public function catalogUser(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$repository = $em->getRepository("LoginBundle:Usuario");
		$pag = $_POST["pagina"] * $_POST["cantidad"];

		$query = "SELECT u FROM LoginBundle:Usuario u where u.rolUsuario != 4 order by u.id asc";
		$queryTot = "SELECT COUNT(u.id) FROM LoginBundle:Usuario u where u.rolUsuario != 4";

		if($_POST["buscar"] != "")
		{
			$query = "SELECT u FROM LoginBundle:Usuario u where u.rolUsuario != 4 and u.nombre like '%".$_POST["buscar"]."%' or u.rolUsuario != 4 and u.apellido like '%".$_POST["buscar"]."%' or u.rolUsuario != 4 and u.login like '%".$_POST["buscar"]."%' order by u.id asc";
			$queryTot = "SELECT COUNT(u.id) FROM LoginBundle:Usuario u where u.rolUsuario != 4 and u.nombre like '%".$_POST["buscar"]."%' or u.rolUsuario != 4 and u.apellido like '%".$_POST["buscar"]."%' or u.rolUsuario != 4 and u.login like '%".$_POST["buscar"]."%'";
		}
        
        $usuarios = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
		$total = $em->createQuery($queryTot)->getSingleScalarResult();

        $html = '<table class="table table-sm table-bordered" id="table_usuarios">
		<thead>
			<tr>
				<th><label>Usuario</label></th>
				<th><label>Nombre</label></th>
				<th><label>Perfil</label></th>
				<th><label>Estado</label></th>
				<th><label>Licencia</label></th>
				<th><label>Configuración</label></th>
			</tr>
		</thead>
		<tbody>';
		foreach($usuarios as $row)
		{
			$html .= '<tr>
				<td>'.$row->getLogin().'</td>
				<td>'.$row->getNombre()." ".$row->getApellido().'</td>
				<td>'.$row->getRolUsuario()->getNombre().'</td>
				<td>
					<a href="#" name="'.$row->getId().'" class="lkEncode btn '.(($row->getEstado()) ? "btn-success Activo" : "btn-danger Inactivo").' btnEstado u'.$row->getId().' ">
						'.(($row->getEstado()) ? "Activo" : "Inactivo" ).
					'</a>
				</td>
				<td>'
					.(($row->getRolUsuario()->getId() == 1) ? $row->getRolUsuario()->getNombre() : "").''
					.(($row->getRolUsuario()->getId() == 2) ? $row->getIdMedico()->getPeriodoLicencia()->getNombre() : "").''
					.(($row->getRolUsuario()->getId() == 3) ? $row->getIdAsistente()->getPeriodoLicencia()->getNombre() : "").'
				</td>
				<td>
					<a href="../edit/'.$row->getId().'" class="btn btn-info">Editar</a>&nbsp;
					<!--<a href="/admin/delete/'.$row->getId().'" class="btnDeleteUser btn btn-warning">Eliminar</a>-->
				</td>
			</tr>';
		}
		$html .= '</tbody></table>';

		$paginas = ceil($total / $_POST["cantidad"]);
		$start = (($_POST["pagina"] - 5) > 0 ) ? $_POST["pagina"] - 5 : 0;
		$end = (($_POST["pagina"] + 5) < $paginas) ? $_POST["pagina"] + 5 : ($paginas-1);

		$html .= '<div class="d100 paginacion"><nav aria-label="">
		<ul class="pagination">
		  	<li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
		  		<a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
		        	<span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
		      	</a>
		    </li>';
	    if($start > 1)
		{
			$html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
		}

		for($i = $start; $i <= $end; $i++)
		{
			$html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
		}

		if($end < ($paginas-1))
		{
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			$html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
		}
		$html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
	      	<a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
	        	<span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
	      	</a>
	    </li>
		</ul></nav></div>';

		return new Response($html);
	}

	/**
	 * @Route("/catalogRes/", name="catalogResUser")
	 */
	public function catalogResUser(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$repository = $em->getRepository("LoginBundle:Usuario");
		$pag = $_POST["pagina"] * $_POST["cantidad"];

		$query = "SELECT u FROM LoginBundle:Usuario u where u.rolUsuario != 4 order by u.id asc";
		$queryTot = "SELECT COUNT(u.id) FROM LoginBundle:Usuario u where u.rolUsuario != 4";

		if($_POST["buscar"] != "")
		{
			$query = "SELECT u FROM LoginBundle:Usuario u where u.rolUsuario != 4 and u.nombre like '%".$_POST["buscar"]."%' or u.rolUsuario != 4 and u.apellido like '%".$_POST["buscar"]."%' or u.rolUsuario != 4 and u.login like '%".$_POST["buscar"]."%' order by u.id asc";
			$queryTot = "SELECT COUNT(u.id) FROM LoginBundle:Usuario u where u.rolUsuario != 4 and u.nombre like '%".$_POST["buscar"]."%' or u.rolUsuario != 4 and u.apellido like '%".$_POST["buscar"]."%' or u.rolUsuario != 4 and u.login like '%".$_POST["buscar"]."%'";
		}

        $usuarios = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
		$total = $em->createQuery($queryTot)->getSingleScalarResult();
		
		$html = '<table class="table table-sm table-bordered" id="table_usuarios_responsive">';
		foreach($usuarios as $row)
		{
			$html .= '<tbody>
			    <tr>
			    	<th width="30%"><label>Usuario</label></th>
					<td width="70%">'.$row->getLogin().'</td>
				</tr>
				<tr>
					<th width="30%"><label>Nombre</label></th>
					<td width="70%">
						'.$row->getNombre().' '.$row->getApellido().'
					</td>
				</tr>
				<tr>
					<th width="30%"><label>Perfil</label></th>
					<td width="70%">'.$row->getRolUsuario()->getNombre().'</td>
				</tr>
				<tr>
					<th width="30%"><label>Estado</label></th>
					<td width="70%">
						<a href="#" name="'.$row->getId().'" class="lkEncode btn '.(($row->getEstado()) ? "btn-success Activo" : "btn-danger Inactivo" ).' btnEstado u'.$row->getId().' ">
						'.(($row->getEstado()) ? "Activo" : "Inactivo").'
					</a>
					</td>
				</tr>
				<tr>
					<th width="30%"><label>Licencia</label></th>
					<td width="70%">'
						.(($row->getRolUsuario()->getId() == 1) ? $row->getRolUsuario()->getNombre() : "").''
						.(($row->getRolUsuario()->getId() == 2) ? $row->getIdMedico()->getPeriodoLicencia()->getNombre() : "").''
						.(($row->getRolUsuario()->getId() == 3) ? $row->getIdAsistente()->getPeriodoLicencia()->getNombre() : "").'
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<a href="../edit/'.$row->getId().'" class="btn btn-info pad5">Editar</a>
						<!--<a href="/admin/delete/'.$row->getId().'" class="btnDeleteUser btn btn-warning">Eliminar</a>-->
					</td>
				</tr>
			</tbody>';
		}
		$html .= '</table>';

		$paginas = ceil($total / $_POST["cantidad"]);
		$start = (($_POST["pagina"] - 3) > 0 ) ? $_POST["pagina"] - 3 : 0;
		$end = (($_POST["pagina"] + 3) < $paginas) ? $_POST["pagina"] + 3 : ($paginas-1);

		$html .= '<div class="d100 paginacion_responsive"><nav aria-label="">
		<ul class="pagination">
		  	<li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
		  		<a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
		        	<span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
		      	</a>
		    </li>';
	    if($start > 1)
		{
			$html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
		}

		for($i = $start; $i <= $end; $i++)
		{
			$html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
		}

		if($end < ($paginas-1))
		{
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			$html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
		}
		$html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
	      	<a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
	        	<span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
	      	</a>
	    </li></ul></nav></div>';

		return new Response($html);
	}

	/**
	 * @Route("/catalogAsist/", name="catalogAsist")
	 */
	public function catalogAsist(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$pag = $_POST["pagina"] * $_POST["cantidad"];

		$query = "select u from LoginBundle:Usuario u where u.rolUsuario = 3 and u.estado = true";
		$queryPag = "select count(u.id) from LoginBundle:Usuario u where u.rolUsuario = 3";
		
		$usuarios = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
		$total = $em->createQuery($queryPag)->getSingleScalarResult();
		
		$html = '<table class="table table-sm table-bordered">
		<thead>
			<tr>
				<th width="15%"><label>Usuario</label></th>
				<th width="30%"><label>Nombre</label></th>
				<th width="20%"><label>Perfil</label></th>
				<th width="10%"><label>Estado</label></th>
				<th width="25%"><label>Configuración</label></th>
			</tr>
		</thead>
		<tbody>';
		if($usuarios)
		{
			foreach($usuarios as $row)
			{
				$html .= '<tr>
					<td>'.$row->getLogin().'</td>
					<td>'.$row->getNombre().' '.$row->getApellido().'</td>
					<td>'.$row->getRolUsuario()->getNombre().'</td>
					<td>'.(($row->getEstado()) ? "Activo" : "Inactivo").'</td>
					<td>
						<button name="'.$row->getIdAsistente()->getId().'" class="btnAsignar btn btn-info" '.(($row->getEstado()) ? "" : "disabled").'>Asignar Asistente</button>
					</td>
				</tr>';
			}
		}	
		$html .= '</tbody></table>';

		$paginas = ceil($total / $_POST["cantidad"]);
		$start = (($_POST["pagina"] - 5) > 0 ) ? $_POST["pagina"] - 5 : 0;
		$end = (($_POST["pagina"] + 5) < $paginas) ? $_POST["pagina"] + 5 : ($paginas-1);

		$html .= '<div class="d100 paginacion_responsive"><nav aria-label="">
		<ul class="pagination">
		  	<li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
		  		<a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
		        	<span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
		      	</a>
		    </li>';
	    if($start > 1)
		{
			$html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
		}

		for($i = $start; $i <= $end; $i++)
		{
			$html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
		}

		if($end < ($paginas-1))
		{
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			$html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
		}
		$html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
	      	<a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
	        	<span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
	      	</a>
	    </li></ul></nav></div>';

	    return new Response($html);
	}

	/**
	 * @Route("/catalogAsistRes/", name="catalogResAsist")
	 */
	public function catalogResAsist(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$pag = $_POST["pagina"] * $_POST["cantidad"];
		$query = "select u from LoginBundle:Usuario u where u.rolUsuario = 3 and u.estado = true";
		$usuarios = $em->createQuery($query)->setMaxResults($_POST["cantidad"])->setFirstResult($pag)->getResult();
		$queryPag = "select count(u.id) from LoginBundle:Usuario u where u.rolUsuario = 3";
		$total = $em->createQuery($queryPag)->getSingleScalarResult();

		$html = '<table class="table table-sm table-bordered">';
		if($usuarios)
		{
			foreach($usuarios as $row)
			{
				$html .= '<tbody>
				    <tr>
				    	<th width="30%"><label>Usuario</label></th>
						<td width="70%">'.$row->getLogin().'</td>
					</tr>
					<tr>
						<th width="30%" ><label>Nombre</label></th>
						<td width="70%">'.$row->getNombre().' '.$row->getApellido().'</td>
					</tr>
					<tr>
						<th width="30%" ><label>Perfil</label></th>
						<td width="70%">'.$row->getRolUsuario()->getNombre().'</td>
					</tr>
					<tr>
						<th width="30%" ><label>Estado</label></th>
						<td width="70%">'.(($row->getEstado()) ? "Activo" : "Inactivo").'</td>
					</tr>
					<tr>
						<td colspan="2">
							<button name="'.$row->getIdAsistente()->getId().'" class="btnAsignar btn btn-info" '.(($row->getEstado()) ? "" : "disabled").'>Asignar Asistente</button>
						</td>
					</tr>
				</tbody>';
			}
		}
		$html .= '</table>';
		
		$paginas = ceil($total / $_POST["cantidad"]);
		$start = (($_POST["pagina"] - 5) > 0 ) ? $_POST["pagina"] - 5 : 0;
		$end = (($_POST["pagina"] + 5) < $paginas) ? $_POST["pagina"] + 5 : ($paginas-1);

		$html .= '<div class="d100 paginacion_responsive"><nav aria-label="">
		<ul class="pagination">
		  	<li class="page-item '.(($_POST["pagina"] == 0) ? "disabled" : "").'">
		  		<a id="'.($_POST["pagina"] - 1).'" class="page-link" href="#" aria-label="Previous">
		        	<span aria-hidden="true">&laquo;</span><span class="sr-only">Previous</span>
		      	</a>
		    </li>';
	    if($start > 1)
		{
			$html .= '<li class="page-item"><a id="0" class="page-link" href="#">1</a></li>';
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
		}

		for($i = $start; $i <= $end; $i++)
		{
			$html .= '<li class="page-item '.(($_POST["pagina"] == $i) ? "active" : "").'"><a id="'.$i.'" class="page-link text-center" href="#">'.($i + 1).'</a></li>';
		}

		if($end < ($paginas-1))
		{
			$html .= '<li class="page-item disabled"><a class="page-link" href="#">...</a></li>';
			$html .= '<li class="page-item"><a id="'.($paginas-1).'" class="page-link" href="#">'.$paginas.'</a></li>';
		}
		$html .= '<li class="page-item '.(($_POST["pagina"] == ($paginas - 1) ) ? "disabled" : "").'">
	      	<a id="'.($_POST["pagina"] + 1).'" class="page-link" href="#" aria-label="Next">
	        	<span aria-hidden="true">&raquo;</span><span class="sr-only">Next</span>
	      	</a>
	    </li></ul></nav></div>';

	    return new Response($html);
	}

	/**
	 * @Route("/licencia/dias/", name="periodoLicencia")
	 */
	public function periodoLicenciaAction(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$periodo = $em->getRepository("AdministradorBundle:PeriodoLicencia")->find($request->get("id"));
		$fechaHoy = date("Y-m-d");
		$fechaCaducidad = date("Y-m-d", strtotime("+".$periodo->getNumeroDias()." day"));

		$json = [
			"fechaHoy" => $fechaHoy,
			"fechaCaducidad" => $fechaCaducidad
		];

		return new Response(json_encode($json));
	}

	/**
	 * @Route("/create/", name="createUser")
	 */
	public function createUserAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$admin = $repository->find($request->getSession()->get("usuario"));

			$especialidades = $em->getRepository("AdministradorBundle:Especialidades")->findBy(array("estado" => true));
			$asistentes = $em->getRepository("LoginBundle:Usuario")->findBy(array("rolUsuario" => 3, "estado" => true));
			$instituciones = $em->getRepository("AdministradorBundle:Institucion")->findAll();
			$periodos = $em->getRepository("AdministradorBundle:PeriodoLicencia")->findAll();

			return $this->render("@Administrador/Default/create.html.twig", array(
				"usuario" => $admin,
				"especialidades" => $especialidades,
				"asistentes" => $asistentes,
				"instituciones" => $instituciones,
				"periodos" => $periodos
			));
		}
	}

	/**
	 * @Route("/store/", name="storeUser")
	 */
	public function storeUserFunction(Request $request)
	{
		$user = new Usuario();
		$rol = new Rol();

		$em = $this->getDoctrine()->getManager();
		$repository = $em->getRepository("LoginBundle:Rol");
		$rol = $repository->find($_POST["tipousuario"]);

		$user->setCedula($_POST["cedula"]);
		$user->setLogin($_POST["nombreUsuario"]);
		$user->setPassword($_POST["password"]);
		$user->setHash($_POST["password"]);
		$user->setNombre($_POST["nombres"]);
		$user->setApellido($_POST["apellidos"]);
		$user->setTelefono($_POST["telefono"]);
		$user->setEmail($_POST["mail"]);
		$user->setRolUsuario($rol);
		$user->setEstado(true);
		$user->setTipoIdentificacion($_POST["tipo_iden"]);
		$user->setFoto("6973e3e05f3cea01fbdedd4/usuarios/user-default.png");

		$em->persist($user);

		$admMail = $_POST["adm_mail"];
		$admProg = $_POST["adm_prog"];
		$admDb = $_POST["adm_db"];
		$codmedico = $_POST["codmedico"];
		$dirmedico = $_POST["direccion"];
		$nomComercial = $_POST["nomComercial"];
		$periodo = $_POST["periodo"];
		$asistente = $_POST["asistente"];
		$idMedico = 0;

		//datos-facturacion
		$facturar = $_POST["facturar"];
		$rucMedico = $_POST["ruc_medico"];
		$nroEstabl = $_POST["nro_establ"];
		$ptoEmision = $_POST["ptoEmision"];
		$tipContrib = $_POST["tip_contrib"];
		$nroContrib = $_POST["nro_contrib"];

		$idInstitucion = $_POST["institucion"];
		$razonSocial = $_POST["razon_social"];
		$telfInstitucion = $_POST["telf_institucion"];
		$cellInstitucion = $_POST["cell_institucion"];
		$emailInstitucion = $_POST["email_institucion"];
		$dirMatriz = $_POST["dir_matriz"];
		$dirEstabl = $_POST["dir_establ"];
		$firmaElec = $_POST["firma_elec"];
		$claveFirma = $_POST["clave_firma"];

		if($_POST["tipousuario"] == 1)
		{
			$admin = new Administrador();
			$admin->setIdUsuario($user);
			$admin->setCorreoRecuperacion($admMail);
			$admin->setPassProgramamed($admProg);
			$admin->setPassDb($admDb);

			$em->persist($admin);

			$user->setIdAdministrador($admin);
		}
		else if($_POST["tipousuario"] == 2)
		{
			$img = file_get_contents("6973e3e05f3cea01fbdedd4/logos/programamed.png");
			$img64 = base64_encode($img);

			$medic = new Medico();
			$medic->setIdUsuario($user);
			$medic->setCodigo($codmedico);
			$medic->setUrlImagen("6973e3e05f3cea01fbdedd4/logos/programamed.png");
            $medic->setImagen($img64);
            $medic->setDireccion($dirmedico);
            $medic->setNombreComercial($nomComercial);

			$licencia = $em->getRepository("AdministradorBundle:PeriodoLicencia")->find($periodo);
			$medic->setPeriodoLicencia($licencia);
			$fecAct = date("Y-m-d");
			$fecCad = date("Y-m-d", strtotime("+".$licencia->getNumeroDias()." day"));
			$medic->setFechaRegistro($fecAct);
			$medic->setFechaCaducidad($fecCad);
			
			if($asistente != 0)
				$medic->setAsistente(true);
			else
				$medic->setAsistente(false);

			$em->persist($medic);

			$user->setIdMedico($medic);
			$idMedico = $medic->getId();

            if($facturar == "si")
            {
            	$medic->setFactura(true);

            	if($idInstitucion == 0)
            	{
            		$institucion = new Institucion();
	            	$institucion->setRazonSocial($razonSocial);
	            	$institucion->setNombreComercial($nomComercial);
	            	$institucion->setTelefono($telfInstitucion);
	            	$institucion->setCelular($cellInstitucion);
	            	$institucion->setEmail($emailInstitucion);
	            	$institucion->setDireccionMatriz($dirMatriz);
	            	$institucion->setDireccionEstabl($dirEstabl);
	            	$institucion->setRuc($rucMedico);
		            $institucion->setNumeroEstabl($nroEstabl);
		            $institucion->setPuntoEmision($ptoEmision);
		            $institucion->setTipoContribuyente($tipContrib);
		            $institucion->setNroContribuyente($nroContrib);
		            $institucion->setFirmaElectronica($firmaElec);
		            $institucion->setClaveFirma($claveFirma);

		            if($tipContrib == "PER_NAT_NC")
		            	$institucion->setOblContabilidad("NO");
		            elseif($tipContrib == "PER_NAT_SC" || $tipContrib == "PER_JUD" || $tipContrib == "CON_ESP")
		            	$institucion->setOblContabilidad("SI");

		            $em->persist($institucion);
            	}
            	else
            	{
            		$institucion = $em->getRepository("AdministradorBundle:Institucion")->find($idInstitucion);
            	}

            	$medic->setIdInstitucion($institucion);
            }
            else
            	$medic->setFactura(false);

			if($asistente != 0)
			{
				$asist = $em->getRepository("AdministradorBundle:Asistente")->find($asistente);
				$asisMedic = new AsistenteMedico();
				$asisMedic->setIdAsistente($asist);
				$asisMedic->setIdMedico($medic);
				$asist->setMedico(true);

				$em->persist($asisMedic);
			}

			$agenda = new Agenda();
            $agenda->setIdMedico($medic);

            $em->persist($agenda);

            $documento = new Documentos();
            $documento->setIdMedico($medic);
            $documento->setCodigo("CERTMED");
            $documento->setTexto('<p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif"><strong>CERTIFICADO M&Eacute;DICO </strong></span></span></p>

			<p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Dr./Dra. PROMDOCTOR&nbsp;M&eacute;dico PROMESPECIALIDAD del PROMCONSULTORIO<strong>&nbsp;</strong>a petici&oacute;n de/la interesada:</span></span></p>

			<p style="text-align:center"><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">CERTIFICA</span></span></p>

			<p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Que el Sr/Sra PROMPACIENTE&nbsp;con c&eacute;dula de identidad No. PROMPACIENTECED recibe tratamiento PROMCAUSA&nbsp; desde PROMDESDE hasta PROMHASTA.</span></span></p>

			<p>&nbsp;</p>

			<p><span style="font-size:11pt"><span style="font-family:Calibri,sans-serif">Es cuanto informo a la verdad, autorizo al peticionario hacer del presente certificado el uso legal que crea conveniente.</span></span></p>

			<p>&nbsp;</p>

			<p>&nbsp;</p>

			<p>PROMFECHA</p>

			<p>&nbsp;</p>');

			$em->persist($documento);
		}
		else if($_POST["tipousuario"] == 3)
		{
			$asist = new Asistente();
			$asist->setIdUsuario($user);
			$asist->setMedico(false);
			$licencia = $em->getRepository("AdministradorBundle:PeriodoLicencia")->find($periodo);
			$asist->setPeriodoLicencia($licencia);
			$fecAct = date("Y-m-d");
			$fecCad = date("Y-m-d", strtotime("+".$licencia->getNumeroDias()." day"));
			$asist->setFechaRegistro($fecAct);
			$asist->setFechaCaducidad($fecCad);

			$em->persist($asist);
			
			$user->setIdAsistente($asist);
		}

		$em->flush();

		return new Response($idMedico);
	}

	/**
	 * @Route("/create/especialidad/medico/", name="createMedicEspec")
	 */
	public function createMedicoEspecialidad()
	{
		$em = $this->getDoctrine()->getManager();
		$medico = $em->getRepository("AdministradorBundle:Medico")->find($_POST["medico"]);
		$especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find($_POST["especialidad"]);

		$espMed = new MedicoEspecialidad();
		$espMed->setIdEspecialidad($especialidad);
		$espMed->setIdMedico($medico);

		$em->persist($espMed);
		$em->flush();
		return new Response("ok");
	}

	/**
	 * @Route("/store/especialidad/medico/", name="storeMedicEspec")
	 */
	public function storeMedicoEspecialidad()
	{
		$em = $this->getDoctrine()->getManager();
		$medic = $em->getRepository("AdministradorBundle:Medico")->find($_POST["medico"]);

		for ($i=0; $i < count($_POST["especialidad"]); $i++) 
		{
			$repEsp = $em->getRepository("AdministradorBundle:Especialidades")->find($_POST["especialidad"][$i]);

			$espMed = new MedicoEspecialidad();
			$espMed->setIdEspecialidad($repEsp);
			$espMed->setIdMedico($medic);

			$em->persist($espMed);
			$em->flush();
		}

		return new Response("ok");
	}

	/**
	 * @Route("/store/asistentemedico/", name="storeAsistenteMedico")
	 */
	public function storeAsistenteMedico()
	{
		$em = $this->getDoctrine()->getManager();
		$asistente = $em->getRepository("AdministradorBundle:Asistente")->find($_POST["idAsistente"]);
		$medico = $em->getRepository("AdministradorBundle:Medico")->find($_POST["idMedico"]);

		$asisMedic = new AsistenteMedico();
		$asisMedic->setIdAsistente($asistente);
		$asisMedic->setIdMedico($medico);
		
		$asistente->setMedico(true);
		$medico->setAsistente(true);

		$em->persist($asisMedic);
		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/edit/{user}", name="editUser")
	 */
	public function editUserAction(Request $request, $user)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$usuario = $repository->find($user);
			$admin = $repository->find($request->getSession()->get("usuario"));
			$instituciones = $em->getRepository("AdministradorBundle:Institucion")->findAll();

			if(!$usuario)
			{
				throw $this->createNotFoundException("No existe el usuario");
			}

			$especialidadAsistente = "";

			if($usuario->getRolUsuario()->getId() == 2)
			{
				$especialidadAsistente = $em->getRepository("AdministradorBundle:MedicoEspecialidad")->findBy(array("idMedico" => $usuario->getIdMedico()->getId()));
			}
			elseif($usuario->getRolUsuario()->getId() == 3)
			{
				$especialidadAsistente = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $usuario->getIdAsistente()->getId()));
			}
			
			return $this->render("@Administrador/Default/edit.html.twig", array("admin" => $admin, "usuario" => $usuario, "especialidadAsistente" => $especialidadAsistente, "instituciones" => $instituciones));
		}
	}

	/**
	 * @Route("/chk/especialidades/", name="chkEspecialidades")
	 */
	public function getEspecialidadesAction()
	{
		$em = $this->getDoctrine()->getManager();
		$especialidades = $em->getRepository("AdministradorBundle:Especialidades")->findBy(array("estado" => true), array("id" => "ASC"));

		$especialidadMedico = $em->getRepository("AdministradorBundle:MedicoEspecialidad")->findBy(array("idMedico" => $_POST["medico"]));

		$html = '';
		if($especialidades)
		{
			foreach($especialidades as $row)
			{
				$html .= '<li class="d100 pad5"><label><input type="checkbox" class="chkEspecialidad" value="'.$row->getId().'" '.(($row->getCodigo() == "MEDGENE") ? "disabled" : "").' ';

				if($especialidadMedico)
				{
					foreach($especialidadMedico as $fila)
					{
						$html .= (($row->getId() == $fila->getIdEspecialidad()->getId()) ? "checked" : "");
					}
				}
				$html .= '>'.$row->getNombre().'</label></li>';
			}
		}
		return new Response($html);
	}

	/**
	 * @Route("/edit/asistente/{user}", name="editAsistUser")
	 */
	public function editAsistenteAction(Request $request, $user)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 1)
		{
			return $this->redirectToRoute("logout");
		}
		else
		{
			$em = $this->getDoctrine()->getManager();
			$repository = $em->getRepository("LoginBundle:Usuario");
			$usuario = $repository->find($user);
			$admin = $repository->find($request->getSession()->get("usuario"));

			return $this->render("@Administrador/Default/edit.asist.html.twig", array("admin" => $admin, "usuario" => $usuario));
		}
	}

	/**
	 * @Route("/update/{user}", name="updateUser")
	 */
	public function updateUserAction($user)
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($user);
		$codMed = $_POST["codmedico"];
		$dirmedico = $_POST["direccion"];
		$nomComercial = $_POST["nomComercial"];

		//datos-facturacion
		$facturar = $_POST["facturar"];
		$rucMedico = $_POST["ruc_medico"];
		$nroEstabl = $_POST["nro_establ"];
		$ptoEmision = $_POST["ptoEmision"];
		$tipContrib = $_POST["tip_contrib"];
		$nroContrib = $_POST["nro_contrib"];

		$idInstitucion = $_POST["institucion"];
		$razonSocial = $_POST["razon_social"];
		$telfInstitucion = $_POST["telf_institucion"];
		$cellInstitucion = $_POST["cell_institucion"];
		$emailInstitucion = $_POST["email_institucion"];
		$dirMatriz = $_POST["dir_matriz"];
		$dirEstabl = $_POST["dir_establ"];
		$firmaElec = $_POST["firma_elec"];
		$claveFirma = $_POST["clave_firma"];

		if($usuario->getRolUsuario()->getId() == 2)
		{
			$medic = $em->getRepository("AdministradorBundle:Medico")->find($usuario->getIdMedico()->getId());

			$medic->setCodigo($codMed);
            $medic->setDireccion($dirmedico);
            $medic->setNombreComercial($nomComercial);

           if($facturar == "si")
            {
            	$medic->setFactura(true);

            	if($idInstitucion == 0)
            	{
            		$institucion = new Institucion();
	            	$institucion->setRazonSocial($razonSocial);
	            	$institucion->setNombreComercial($nomComercial);
	            	$institucion->setTelefono($telfInstitucion);
	            	$institucion->setCelular($cellInstitucion);
	            	$institucion->setEmail($emailInstitucion);
	            	$institucion->setDireccionMatriz($dirMatriz);
	            	$institucion->setDireccionEstabl($dirEstabl);
	            	$institucion->setRuc($rucMedico);
		            $institucion->setNumeroEstabl($nroEstabl);
		            $institucion->setPuntoEmision($ptoEmision);
		            $institucion->setTipoContribuyente($tipContrib);
		            $institucion->setNroContribuyente($nroContrib);
		            $institucion->setFirmaElectronica($firmaElec);
		            $institucion->setClaveFirma($claveFirma);

		            if($tipContrib == "PER_NAT_NC")
		            	$institucion->setOblContabilidad("NO");
		            elseif($tipContrib == "PER_NAT_SC" || $tipContrib == "PER_JUD" || $tipContrib == "CON_ESP")
		            	$institucion->setOblContabilidad("SI");

		            $em->persist($institucion);
            	}
            	else
            	{
            		$institucion = $em->getRepository("AdministradorBundle:Institucion")->find($idInstitucion);
            	}

            	$medic->setIdInstitucion($institucion);
            }
            else
            {
            	$medic->setFactura(false);
            	$medic->setIdInstitucion(null);
            }
		}

		$usuario->setCedula($_POST["cedula"]);
		$usuario->setLogin($_POST["username"]);
		$usuario->setNombre($_POST["nombres"]);
		$usuario->setApellido($_POST["apellidos"]);
		$usuario->setTelefono($_POST["telefono"]);
		$usuario->setEmail($_POST["mail"]);
		$usuario->setTipoIdentificacion($_POST["tipo_iden"]);

		$em->flush();

		return new Response("El usuario a sido modificado con éxito");
	}

	/**
	 * @Route("/updatePass/{user}", name="updatePassUser")
	 */
	public function updatePassUserAction($user = 0)
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($user);
		$usuario->setPassword($_POST["passwd1"]);
		$usuario->setHash($_POST["passwd1"]);

		$em->flush();

		return new Response("La contraseña a sido cambiada con éxito");
	}

	/**
	 * @Route("/updateEstado/{user}/{estado}", name="updateEstadoUser")
	 */
	public function updateEstadoUserAction($user, $estado)
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($user);

		if($estado == 0){
			$usuario->setEstado(false);
			$em->flush();
			return new Response("0");
		}
		else{
			$usuario->setEstado(true);
			$em->flush();
			return new Response("1");
		}
	}

	/**
	 * @Route("/update/licencia/usuario/", name="updateLicenciaUser")
	 */
	public function updateLicenciaUsuario()
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($_POST["id"]);
		if($usuario)
		{
			$sigAnio = date("Y") + 1;
			if($usuario->getRolUsuario()->getId() == 2)
			{
				$medico = $em->getRepository("AdministradorBundle:Medico")->find($usuario->getIdMedico()->getId());
				$medico->setFechaRegistro(date("Y-m-d"));
				$medico->setFechaCaducidad(date($sigAnio."-m-d"));

				$em->flush();
			}
			elseif($usuario->getRolUsuario()->getId() == 3)
			{
				$asistente = $em->getRepository("AdministradorBundle:Asistente")->find($usuario->getIdAsistente()->getId());
				$asistente->setFechaRegistro(date("Y-m-d"));
				$asistente->setFechaCaducidad(date($sigAnio."-m-d"));

				$em->flush();
			}
		}
		return new Response("ok");
	}


	/**
	 * @Route("/delete/{user}", name="deleteUser")
	 */
	public function deleteUserAction($user)
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($user);
		if($usuario->getRolUsuario()->getId() == 1)
		{
			$administrador = $em->getRepository("AdministradorBundle:Administrador")->find($usuario->getIdAdministrador()->getId());
			
			$em->remove($administrador);
			$em->remove($usuario);
			$em->flush();
		}
		elseif($usuario->getRolUsuario()->getId() == 2)
		{
			$medico = $em->getRepository("AdministradorBundle:Medico")->find($usuario->getIdMedico()->getId());
			$espMed = $em->getRepository("AdministradorBundle:MedicoEspecialidad")->findBy(array("idMedico" => $medico->getId()));
			
			$em->remove($espMed);
			$em->remove($medico);
			$em->remove($usuario);
			$em->flush();
		}
		elseif($usuario->getRolUsuario()->getId() == 3)
		{
			$medicoAsistente = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $usuario->getIdAsistente()->getId()));
			$asistente = $em->getRepository("AdministradorBundle:Asistente")->find($usuario->getIdAsistente()->getId());
			
			$em->remove($medicoAsistente);
			$em->remove($asistente);
			$em->remove($usuario);
			$em->flush();
		}

		return $this->redirectToRoute("listUserAdmin");
	}

	/**
	 * @Route("/delete/medicoasistente/{idMedico}/{idAsistente}")
	 */
	public function deleteAsistenteMedico($idMedico, $idAsistente)
	{
		$em = $this->getDoctrine()->getManager();
		$medicoAsistente = $em->getRepository("AdministradorBundle:AsistenteMedico")->findOneBy(array("idAsistente" => $idAsistente, "idMedico" => $idMedico));
		
		$em->remove($medicoAsistente);
		
		$asist = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $idAsistente));
		if(!$asist)
		{
			$asistente = $em->getRepository("AdministradorBundle:Asistente")->find($idAsistente);
			$asistente->setMedico(false);
		}
		$medico = $em->getRepository("AdministradorBundle:Medico")->find($idMedico);
		$medico->setAsistente(false);

		$em->flush();

		return new Response("ok");
	}

	/**
	 * @Route("/delete/especialidad/medico/", name="deleteMedicEspec")
	 */
	public function deleteMedicoEspecialidad()
	{
		$em = $this->getDoctrine()->getManager();
		$espMed = $em->getRepository("AdministradorBundle:MedicoEspecialidad")->findOneBy(array("idMedico" => $_POST["medico"], "idEspecialidad" => $_POST["especialidad"]));
		
		$em->remove($espMed);
		$em->flush();
		return new Response("ok");
	}

	/**
	 * @Route("/usuario/update/foto", name="updateFotoUsuario")
	 */
	public function updateFotoUsuario()
	{
		$em = $this->getDoctrine()->getManager();
		$usuario = $em->getRepository("LoginBundle:Usuario")->find($_POST["usuario"]);
		$usuario->setFoto($_POST["fotoUsuario"]);;
		$em->flush();
		return new Response("ok");
	}

	/**
	 * @Route("/usuario/subir/foto", name="subirFoto")
	 */
	public function subirFotoUsuario()
	{
		$em = $this->getDoctrine()->getManager();

		$imagen = $_FILES["flFotoUsuario"];
		$array = explode(".", $imagen["name"]);
		$extension = end($array);

		$nombreImage = md5($_POST["inputFotoUsuario"]."_foto").".".$extension;
		$rutaImagen = "6973e3e05f3cea01fbdedd4/usuarios/".$nombreImage;
		$subir = move_uploaded_file($imagen["tmp_name"], $rutaImagen);

		if($subir)
		{
			chmod($rutaImagen, 0777);
			$this->redimensionar_imagen($rutaImagen, $extension);

			return new Response($rutaImagen);
		}
		else
			return new Response("nok");
	}

	/**
	 * @Route("/usuario/subir/firma", name="subirFirma")
	 */
	public function subirFirmaElectronica()
	{
		$em = $this->getDoctrine()->getManager();

		$firma = $_FILES["flFirmaElectronica"];
		$array = explode(".", $firma["name"]);
		$nombre = $array[0];
		$extension = end($array);

		$nombreFirma = md5($nombre."_".date("YmdHis")).".".$extension;
		$rutaFirma = "6973e3e05f3cea01fbdedd4/firmas/".$nombreFirma;
		$subir = move_uploaded_file($firma["tmp_name"], $rutaFirma);

		if($subir)
		{
			chmod($rutaFirma, 0777);

			return new Response($rutaFirma);
		}
		else
			return new Response("nok");
	}

	function redimensionar_imagen($rutaImagenOriginal, $extensionImagen)
	{
				
		list($ancho, $alto) = getimagesize($rutaImagenOriginal);

		$max_ancho = 200;
		$max_alto = 200;
		
		if($extensionImagen == "jpg" || $extensionImagen == "jpeg")
			$img_original=imagecreatefromjpeg($rutaImagenOriginal);
	    else if ($extensionImagen == "png")
	        $img_original = imagecreatefrompng($rutaImagenOriginal);
	    else if ($extensionImagen == "gif")
	        $img_original=imagecreatefromgif($rutaImagenOriginal);
		
		
		$tmp_img = imagecreatetruecolor($max_ancho, $max_alto);	
		
		imagecopyresampled($tmp_img, $img_original, 0, 0, 0, 0, $max_ancho, $max_alto, $ancho, $alto);
		
		imagedestroy($img_original);
		
		$calidad = 95;
		
		imagejpeg($tmp_img, $rutaImagenOriginal, $calidad);
	}
}
