<?php

namespace HistoriaClinica\listarCitasBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

use HistoriaClinica\listarCitasBundle\Entity\EstadoCitaMedica;
use Symfony\Component\HttpFoundation\Response;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Query\ResultSetMapping;
use Doctrine\ORM\Tools\Setup;
use Doctrine\ORM\EntityRepository;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\XmlEncoder;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;

use Symfony\Component\HttpFoundation\File\Exception\FileException;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use HistoriaClinica\listarCitasBundle\Entity\PuntosEspecialidad;
use HistoriaClinica\listarCitasBundle\Form\PuntosEspecialidadImgType;



class ListaCitasController extends Controller
{
    /**
     * @Route("/listaCitasMedicas/{idMedico}/{nombreMedico}/{apellidoMedico}", name="lista_citas")
     * @Template()
     */
    public function listarCitasAction(Request $request,$idMedico = 0,$nombreMedico = 0, $apellidoMedico = 0)
    {
        if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2)
        {
            return $this->redirectToRoute("logout");
        }
        else
        {
            $idUsuario = $idMedico;
            $fechaActual = date('Y-m-d');
            
            $sqlNativo = "SELECT cm.id_cita_medica, p.id_paciente, u.nombre_usuario, u.apellido_usuario
            , cm.fecha_cita_medica, cm.hora_cita_medica, e.nombre_especialidad, ecm.nombre_es_cita_medica
            , ecm.boton_es_cita_medica, m.id_medico
             FROM cita_medica cm, agenda a, paciente p, usuario u, medico m, especialidad e, estado_cita_medica ecm
             WHERE a.id_agenda=cm.id_agenda AND cm.id_paciente=p.id_paciente AND p.id_usuario=u.id_usuario AND cm.id_especialidad=e.id_especialidad
             AND cm.id_estado_cita_medica=ecm.id_estado_cita_medica AND a.id_medico=m.id_medico AND m.id_medico=? AND ecm.estado_es_cita_medica=TRUE 
             AND cm.fecha_cita_medica=?;";
            
            $stmtCita = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtCita->bindValue(1,$idUsuario);
            $stmtCita->bindValue(2,$fechaActual);
            $stmtCita->execute();
            $resultCitas = $stmtCita->fetchAll();

            $anio = date("Y");
            $mes = date("m");

            $em = $this->getDoctrine()->getManager();
            $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
            $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            $medico = $em->getRepository("AdministradorBundle:Medico")->find($idMedico);
            
            return $this->render("@HistoriaClinicalistarCitas/CitaMedica/listaCitasMedicas.html.twig", array(
                "citas" => $resultCitas,
                "idUsuarioAux" => $idUsuario,
                "nombreMedico" => $nombreMedico,
                "apellidoMedico" => $apellidoMedico,
                "mes" => $mes,
                "anio" => $anio,
                "noticias" => $noticias,
                "formLogoMedico" => $idMedico,
                "urlMedicoIcono" => $this->urlMedico($idMedico),
                "fotoUsuario" => $medico->getIdUsuario()->getFoto(),
                "nombreComercial" => $medico->getNombreComercial(),
                "usuarioId" => $medico->getIdUsuario()->getId()
            ));
        }
    }

    /**
     * @Route("/listaCitasMedicasFecha", name="ajaxCitaFecha")
     * @Method({"POST"})
     */
    public function postAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();
            $fechaActual = $postData["fecha"];
            $idUsuario = $postData["idUsuarioAux"];
                    
             $sqlNativo = "SELECT cm.id_cita_medica, p.id_paciente, u.nombre_usuario, u.apellido_usuario
             , cm.fecha_cita_medica, cm.hora_cita_medica, e.nombre_especialidad, ecm.nombre_es_cita_medica
             , ecm.boton_es_cita_medica, m.id_medico
              FROM cita_medica cm, agenda a, paciente p, usuario u, medico m, especialidad e, estado_cita_medica ecm
              WHERE a.id_agenda=cm.id_agenda AND cm.id_paciente=p.id_paciente AND p.id_usuario=u.id_usuario AND cm.id_especialidad=e.id_especialidad
              AND cm.id_estado_cita_medica=ecm.id_estado_cita_medica AND a.id_medico=m.id_medico AND m.id_medico=? AND ecm.estado_es_cita_medica=TRUE 
              AND cm.fecha_cita_medica=?;";             
            
            $stmtCita = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtCita->bindValue(1,$idUsuario);
            $stmtCita->bindValue(2,$fechaActual);
            $stmtCita->execute();
            $resultCitas = $stmtCita->fetchAll();

            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success',
                'citas' => $serializer->serialize($resultCitas, 'json')
            ));
            $session = $request->getSession();
            $session->set('controlDetalleHistoriaClinica', 0);            
            return $response;
        }
    }

    /**
     * @Route("/listaCitasMedicasFechaDH", name="ajaxCitaFechaDH")
     * @Method({"POST"})
     */
    public function postDHAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();
            $fechaDesde = $postData["fechaD"];
            $fechaHasta = $postData["fechaH"];
            $idUsuario = $postData["idUsuarioAux"];
            
            $sqlNativo = "SELECT cm.id_cita_medica, p.id_paciente, u.nombre_usuario, u.apellido_usuario
            , cm.fecha_cita_medica, cm.hora_cita_medica, e.nombre_especialidad, ecm.nombre_es_cita_medica
            , ecm.boton_es_cita_medica, m.id_medico
             FROM cita_medica cm, agenda a, paciente p, usuario u, medico m, especialidad e, estado_cita_medica ecm
             WHERE a.id_agenda=cm.id_agenda AND cm.id_paciente=p.id_paciente AND p.id_usuario=u.id_usuario AND cm.id_especialidad=e.id_especialidad
             AND cm.id_estado_cita_medica=ecm.id_estado_cita_medica AND a.id_medico=m.id_medico AND m.id_medico=? AND ecm.estado_es_cita_medica=TRUE 
             AND cm.fecha_cita_medica BETWEEN ? AND ?;";             
            
            $stmtCita = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtCita->bindValue(1,$idUsuario);
            $stmtCita->bindValue(2,$fechaDesde);
            $stmtCita->bindValue(3,$fechaHasta);
            $stmtCita->execute();
            $resultCitas = $stmtCita->fetchAll();
            
            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success',
                'citas' => $serializer->serialize($resultCitas, 'json')
            ));

            $session = $request->getSession();
            $session->set('controlDetalleHistoriaClinica', 0);

            return $response;
        }
    }

    /**
     * @Route("/historialCitaMedicas/{idCitaMedica}/{idPaciente}/{idMedico}/{nombreEspecialidad}/{estadoCita}/{nombreMedico}/{apellidoMedico}/{idUsuarioAux}", name="historial_citas")
     * @Template()
     */
    public function listarHistorialCitasAction(Request $request, $idCitaMedica=0, $idPaciente=0, $idMedico=0, $nombreEspecialidad=""
    ,$estadoCita="",$nombreMedico="",$apellidoMedico="",$idUsuarioAux=0)
    {
        if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2)
        {
            return $this->redirectToRoute("logout");
        }
        else
        {
            $em = $this->getDoctrine()->getManager();
            $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
            $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            $medico = $em->getRepository("AdministradorBundle:Medico")->find($idMedico);
            $historialPac = $em->getRepository("AgendaBundle:HistoriaClinica")->findOneBy(array("idPaciente" => $idPaciente));

            if($estadoCita == "Finalizada")
            {
                return $this->redirectToRoute('fin_consulta', array(
                    'nombreEspecialidad' => $nombreEspecialidad
                    ,"idPaciente" => $idPaciente
                    ,"idMedico" => $idMedico
                    ,"idCitaMedica" => $idCitaMedica
                    ,"nombreMedico" => $nombreMedico
                    ,"apellidoMedico" => $apellidoMedico
                    ,"idUsuarioAux" => $idUsuarioAux
                    ,"estadoCita" => $estadoCita
                    ,"noticias" => $noticias
                ));
            }
            else
            {
                $query = "select r from AgendaBundle:ResumenHistoriaClinica r where exists (select c.id from AgendaBundle:CitaMedica c where r.idCitaMedica = c.id and c.idPaciente = :paciente and c.idEstadoCita = 3) and r.idMedico = :medico order by r.idCitaMedica desc";
                $citasMedicas = $em->createQuery($query)->setParameter("medico", $idMedico)->setParameter("paciente", $idPaciente);

                $paginator = $this->get("knp_paginator");
                $pagination = $paginator->paginate($citasMedicas, $request->query->getInt("page", 1), 5);

                return $this->render("@HistoriaClinicalistarCitas/CitaMedica/historialCitasMedicas.html.twig", array(
                    "nombreEspecialidad" => $nombreEspecialidad
                    ,"consultas" => $pagination
                    ,"idPaciente" => $idPaciente
                    ,"historialPac" => $historialPac
                    ,"idMedico" => $idMedico
                    ,"idCitaMedica" => $idCitaMedica
                    ,"nombreMedico" => $nombreMedico,"apellidoMedico" => $apellidoMedico
                    ,"idUsuarioAux" => $idUsuarioAux,"estadoCita" => $estadoCita
                    ,"noticias" => $noticias
                    ,"formLogoMedico" => $idMedico
                    ,"urlMedicoIcono" => $this->urlMedico($idMedico)
                    ,"fotoUsuario" => $medico->getIdUsuario()->getFoto()
                    ,"nombreComercial" => $medico->getNombreComercial()
                    ,"usuarioId" => $medico->getIdUsuario()->getId()
                ));
            }
        }
    }

    public function medicamentosCitaMedica($idResumenHc)
    {
        $em = $this->getDoctrine()->getManager();
        $resumenHisMed = $em->getRepository("AgendaBundle:ResumenHistoriaMedicamento")->findBy(array("idResumenHc" => $idResumenHc));

        $html = '';
        if($resumenHisMed)
        {
            $html .= '<table class="table table-sm"><thead class="thead-light">
                <tr>
                    <th>Cantidad</th><th>Medicamento</th><th>Indicaciones</th>
                </tr>
            </thead><tbody>';
            foreach($resumenHisMed as $row)
            {
                $html .= '<tr>
                    <td>'.$row->getCantidadMedicamento().'</td>
                    <td>'.$row->getIdMedicamento()->getNombre().'</td>
                    <td>'.$row->getIndicacionesMedicamento().'</td>
                </tr>';
            }
            $html .= '</tbody></table>';
        }

        return new Response($html);
    }

    public function diagnosticosCitaMedica($idResumenHc)
    {
        $em = $this->getDoctrine()->getManager();
        $resumenDiagnostico = $em->getRepository("AgendaBundle:ResumenHistoriaDiagnostico")->findBy(array("idResumenHc" => $idResumenHc));
        $html = '';

        if($resumenDiagnostico)
        {
            $html .= '<table class="table table-sm"><thead class="thead-light">
                <tr>
                    <th>Diagnóstico</th><th>CIE-10</th><th>Tipo</th>
                </tr>
            </thead><tbody>';
            foreach($resumenDiagnostico as $row)
            {
                $html .= '<tr>
                    <td>'.$row->getDiagnostico().'</td>
                    <td>'.$row->getIdCieDiez()->getNombre().'</td>
                    <td>'.$row->getIdTipoDiagnostico()->getNombre().'</td>
                </tr>';
            }
            $html .= '</tbody></table>';
        }

        return new Response($html);
    }

    public function observacionCitaMedica($idPaciente, $idMedico, $idEspecialidad)
    {
        $em = $this->getDoctrine()->getManager();
        $obserEspecialidad = $em->getRepository("AgendaBundle:PuntosEspecialidad")->findOneBy(array("idPaciente" => $idPaciente, "idMedico" => $idMedico, "idEspecialidad" => $idEspecialidad));
        $html = '';
        if($obserEspecialidad)
        {
            $html .= '<div class="row">
                <div class="col-md-12">
                    <h3>Observaciones</h3>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <p>'.nl2br($obserEspecialidad->getObservaciones()).'</p>
                </div>
            </div>';
        }

        return new Response($html);
    }

    public function urlMedico($idMedico){
        $sqlNativo = "SELECT url_logo_medico FROM medico WHERE id_medico=?;";        
        $stmyEspecialidad = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmyEspecialidad->bindValue(1,$idMedico);
        $stmyEspecialidad->execute();
        return $stmyEspecialidad->fetchAll();  
    }

    /**
     * @Route("/subir/historial/pdf", name="subirPdfHistorial")
     */
    public function subirPdfHistorial(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $historialPac = $em->getRepository("AgendaBundle:HistoriaClinica")->findOneBy(array("idPaciente" => $request->get("input_paciente")));

        $pdf = $_FILES["fl_pdf"];
        $array = explode(".", $pdf["name"]);
        $extension = end($array);

        $nombrePdf = md5($historialPac->getId().date("YmdHis")).".".$extension;
        $rutaPdf = "6973e3e05f3cea01fbdedd4/historial_pdf/".$nombrePdf;
        $subir = move_uploaded_file($pdf["tmp_name"], $rutaPdf);

        if($subir)
        {
            if(file_exists($historialPac->getPdfHistoria()))
                unlink($historialPac->getPdfHistoria());

            chmod($rutaPdf, 0777);
            $historialPac->setPdfHistoria($rutaPdf);
            $em->flush();

            return new Response($rutaPdf);
        }
        else
            return new Response("nok");
    }

}
