<?php

namespace HistoriaClinica\listarCitasBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

use Symfony\Component\HttpFoundation\Response;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Query\ResultSetMapping;
use Doctrine\ORM\Tools\Setup;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\HttpFoundation\Session\Session;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\XmlEncoder;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;

use HistoriaClinica\listarCitasBundle\Entity\ResumenHistoriaClinica;
use HistoriaClinica\listarCitasBundle\Entity\Paciente;
use HistoriaClinica\listarCitasBundle\Entity\CitaMedica;
use HistoriaClinica\listarCitasBundle\Entity\EstadoCitaMedica;
use HistoriaClinica\listarCitasBundle\Entity\Medico;
use HistoriaClinica\listarCitasBundle\Entity\HistoriaClinica;
use HistoriaClinica\listarCitasBundle\Entity\DetalleHistoriaClinica;
use HistoriaClinica\listarCitasBundle\Entity\CieDiez;
use HistoriaClinica\listarCitasBundle\Entity\TipoDiagnostico;
use HistoriaClinica\listarCitasBundle\Entity\PedidoImagen;
use HistoriaClinica\listarCitasBundle\Entity\PedidoExaComplemt;
use HistoriaClinica\listarCitasBundle\Entity\Medicamento;
use HistoriaClinica\listarCitasBundle\Entity\MedicoEspecialidad;
use AgendaBundle\Entity\AntecedentesFamiliares;
use AgendaBundle\Entity\AntecedentesPersonales;
use AgendaBundle\Entity\AntecedentesGinecobstetricos;

use Symfony\Component\HttpFoundation\File\Exception\FileException;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use HistoriaClinica\listarCitasBundle\Entity\PuntosEspecialidad;
use HistoriaClinica\listarCitasBundle\Form\PuntosEspecialidadImgType;


class HistorialCitasController extends Controller 
{

    /**
     * @Route("/nuevaConsultaMedica/{nombreEspecialidad}/{idPaciente}/{idMedico}/{idCitaMedica}/{estadoCita}/{nombreMedico}/{apellidoMedico}/{idUsuarioAux}", name="nueva_consulta")
     * @Template()
     */
    public function nuevaConsultaMedicaAction(Request $request,$nombreEspecialidad=0, $idPaciente=0
    , $idMedico=0,$idCitaMedica=0,$estadoCita="",$nombreMedico="",$apellidoMedico="",$idUsuarioAux=0)
    {
        if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2)
        {
            return $this->redirectToRoute("logout");
        }
        else
        {
            $entityManager = $this->getDoctrine()->getManager();

            $repositoryTipoDiagnostico = $this->getDoctrine()->getRepository(TipoDiagnostico::class);
            $tiposDiagnostico = $repositoryTipoDiagnostico->findAll();        

            $repositoryPaciente = $this->getDoctrine()->getRepository(HistoriaClinica::class);
            $historiaClinica = $repositoryPaciente->findOneByIdPaciente($idPaciente);

            $repositoryMedico = $this->getDoctrine()->getRepository(Medico::class);
            $medic = $repositoryMedico->find($idMedico);  
                        
            $repositoryEstadoCitaMedica = $this->getDoctrine()->getRepository(EstadoCitaMedica::class);
            $estadoCitaMedica = $repositoryEstadoCitaMedica->findOneByCodigoEsCitaMedica('CITAENPRO');                  
           
            $repositoryCitaMedica = $this->getDoctrine()->getRepository(CitaMedica::class);
            $citaMedica = $repositoryCitaMedica->find($idCitaMedica);

            $repositoryEstadoCitaMedicaActual = $this->getDoctrine()->getRepository(EstadoCitaMedica::class);
            $estadoCitaMedicaActual = $repositoryEstadoCitaMedicaActual->find($citaMedica->getIdEstadoCitaMedica());

            $repositoryAntecedentesFamiliares = $this->getDoctrine()->getRepository(AntecedentesFamiliares::class);
            $antecedentesFamiliares = $repositoryAntecedentesFamiliares->findOneBy(array("idPaciente" => $idPaciente));

            $repositoryAntecedentesPersonales = $this->getDoctrine()->getRepository(AntecedentesPersonales::class);
            $antecedentesPersonales = $repositoryAntecedentesPersonales->findOneBy(array("idPaciente" => $idPaciente));

            $repositoryAntecedentesGine = $entityManager->getRepository("AgendaBundle:AntecedentesGinecobstetricos");
            $antecedentesGine = $repositoryAntecedentesGine->findOneBy(array("idPaciente" => $idPaciente));

            $edad = "0";
            $edadMeses = "no";
            if($antecedentesPersonales->getIdPaciente()->getFechaNacimiento() != null)
            {
                $fechaHoy = date_create(date("Y-m-d"));
                $fechaNac = date_create($antecedentesPersonales->getIdPaciente()->getFechaNacimiento());
                $resultado = date_diff($fechaNac, $fechaHoy);
                $arrayEdad = explode(":", $resultado->format("%y:%m"));
                $edad = $arrayEdad[0];
                $edadMeses = ($arrayEdad[0] * 12) + $arrayEdad[1];
            }

            $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
            $noticias = $entityManager->createQuery($queryNot)->setMaxResults(1)->getResult();
            $medico = $entityManager->getRepository("AdministradorBundle:Medico")->find($idMedico);
                  
            //\Doctrine\Common\Util\Debug::dump($estadoCitaMedicaActual->getCodigoEsCitaMedica());        

            if($estadoCitaMedicaActual->getCodigoEsCitaMedica() == "CITAINI"){ 

                $citaMedica->setIdEstadoCitaMedica($estadoCitaMedica);
                $resumenHistoriaClinica = new ResumenHistoriaClinica();    
                $resumenHistoriaClinica->setIdHistoriaClinica($historiaClinica);            
                $resumenHistoriaClinica->setIdMedico($medic);
                $resumenHistoriaClinica->setIdCitaMedica($citaMedica);        
        
                $detalleHistoriaClinica = new DetalleHistoriaClinica();
                $detalleHistoriaClinica->setIdResumenHc($resumenHistoriaClinica);
                $entityManager->persist($resumenHistoriaClinica);
                $entityManager->persist($detalleHistoriaClinica);
                $entityManager->flush();

                //\Doctrine\Common\Util\Debug::dump($medicoEspecialidad[2]->getIdEspecialidad());    
                    
                return $this->render("@HistoriaClinicalistarCitas/CitaMedica/consultaMedica.html.twig",
                array("nombreEspecialidad" => $nombreEspecialidad
                    ,"idResumenHistoriaC" => $resumenHistoriaClinica->getIdResumenHc()
                    ,"idDetalleHistoriaC" => $detalleHistoriaClinica->getIdDetalleHc()
                    ,"idPaciente" => $idPaciente,"idMedico" => $idMedico,"idCitaMedica" => $idCitaMedica
                    ,"edad" => $edad
                    ,"edadMeses" => $edadMeses
                    ,"idUsuarioAux" => $idUsuarioAux,"estadoCita" => $estadoCita
                    ,"tiposDiagnostico" => $tiposDiagnostico
                    ,"antecedentesPersonales" => $antecedentesPersonales
                    ,"antecedentesFamiliares" => $antecedentesFamiliares
                    ,"antecedentesGine" => $antecedentesGine
                    ,"especialidadesMedico" => $this->especialidadesMedico($idMedico)
                    ,"nombreMedico" => $nombreMedico,"apellidoMedico" => $apellidoMedico,"logoMedico" => $medico->getUrlImagen()
                    ,"noticias" => $noticias
                    ,"fotoUsuario" => $medico->getIdUsuario()->getFoto()
                    ,"nombreComercial" => $medico->getNombreComercial()
                    ,"usuarioId" => $medico->getIdUsuario()->getId()
                ));
            }
            if($estadoCitaMedicaActual->getCodigoEsCitaMedica() == "CITAENPRO"){
                return $this->render("@HistoriaClinicalistarCitas/CitaMedica/consultaMedicaPro.html.twig",
                array("nombreEspecialidad" => $nombreEspecialidad
                    ,"idPaciente" => $idPaciente,"idMedico" => $idMedico,"idCitaMedica" => $idCitaMedica 
                    ,"edad" => $edad
                    ,"edadMeses" => $edadMeses
                    ,"idUsuarioAux" => $idUsuarioAux,"estadoCita" => $estadoCita        
                    ,"tiposDiagnostico" => $tiposDiagnostico
                    ,"antecedentesPersonales" => $antecedentesPersonales
                    ,"antecedentesFamiliares" => $antecedentesFamiliares
                    ,"antecedentesGine" => $antecedentesGine
                    ,"especialidadesMedico" => $this->especialidadesMedico($idMedico)
                    ,"nombreMedico" => $nombreMedico,"apellidoMedico" => $apellidoMedico,"logoMedico" => $medico->getUrlImagen()
                    ,"detalleCitaMedica" => $this->listarDetalleCitaMedica($idCitaMedica)
                    ,"noticias" => $noticias
                    ,"fotoUsuario" => $medico->getIdUsuario()->getFoto()
                    ,"nombreComercial" => $medico->getNombreComercial()
                    ,"usuarioId" => $medico->getIdUsuario()->getId()
                ));
            }
            if($estadoCitaMedicaActual->getCodigoEsCitaMedica() == "CITAFIN"){
                $detalleCitaMedica = $this->listarDetalleCitaMedica($idCitaMedica);

                $resumenDiagnostico = $entityManager->getRepository("AgendaBundle:ResumenHistoriaDiagnostico")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"]));

                $resumenMedicamento = $entityManager->getRepository("AgendaBundle:ResumenHistoriaMedicamento")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));
                $resumenImagen = $entityManager->getRepository("AgendaBundle:ResumenHistoriaImagen")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));
                $resumenLaboratorio = $entityManager->getRepository("AgendaBundle:ResumenHistoriaLab")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));
                $resumenCompleme = $entityManager->getRepository("AgendaBundle:ResumenExamenComp")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));

                return $this->render("@HistoriaClinicalistarCitas/CitaMedica/consultaMedicaFin.html.twig",
                array("nombreEspecialidad" => $nombreEspecialidad
                    ,"idPaciente" => $idPaciente,"idMedico" => $idMedico,"idCitaMedica" => $idCitaMedica 
                    ,"edad" => $edad
                    ,"edadMeses" => $edadMeses
                    ,"idUsuarioAux" => $idUsuarioAux,"estadoCita" => $estadoCita
                    ,"antecedentesPersonales" => $antecedentesPersonales
                    ,"antecedentesFamiliares" => $antecedentesFamiliares
                    ,"antecedentesGine" => $antecedentesGine
                    ,"especialidadesMedico" => $this->especialidadesMedico($idMedico)
                    ,"nombreMedico" => $nombreMedico,"apellidoMedico" => $apellidoMedico
                    ,"detalleCitaMedica" => $detalleCitaMedica
                    ,"noticias" => $noticias
                    ,"resumenDiagnostico" => $resumenDiagnostico
                    ,"resumenImagen" => $resumenImagen
                    ,"resumenLaboratorio" => $resumenLaboratorio
                    ,"resumenMedicamento" => $resumenMedicamento
                    ,"resumenCompleme" => $resumenCompleme
                    ,"fotoUsuario" => $medico->getIdUsuario()->getFoto()
                    ,"nombreComercial" => $medico->getNombreComercial()
                    ,"usuarioId" => $medico->getIdUsuario()->getId()
                ));
            }
        }
    } 


    /**
     * @Route("/finConsultaMedica/{nombreEspecialidad}/{idPaciente}/{idMedico}/{idCitaMedica}/{estadoCita}/{nombreMedico}/{apellidoMedico}/{idUsuarioAux}", name="fin_consulta")
     * @Template()
     */
    public function finConsultaMedicaAction(Request $request,$nombreEspecialidad=0, $idPaciente=0
    , $idMedico=0,$idCitaMedica=0,$estadoCita="",$nombreMedico="",$apellidoMedico="",$idUsuarioAux="")
    {
        if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2)
        {
            return $this->redirectToRoute("logout");
        }
        else
        {
            $entityManager = $this->getDoctrine()->getManager();

            $medico = $entityManager->getRepository("AdministradorBundle:Medico")->find($idMedico);

            $repositoryTipoDiagnostico = $this->getDoctrine()->getRepository(TipoDiagnostico::class);
            $tiposDiagnostico = $repositoryTipoDiagnostico->findAll();

            $repositoryAntecedentesFamiliares = $this->getDoctrine()->getRepository(AntecedentesFamiliares::class);
            $antecedentesFamiliares = $repositoryAntecedentesFamiliares->findOneBy(array("idPaciente" => $idPaciente));

            $repositoryAntecedentesPersonales = $this->getDoctrine()->getRepository(AntecedentesPersonales::class);
            $antecedentesPersonales = $repositoryAntecedentesPersonales->findOneBy(array("idPaciente" => $idPaciente));

            $repositoryAntecedentesGine = $entityManager->getRepository("AgendaBundle:AntecedentesGinecobstetricos");
            $antecedentesGine = $repositoryAntecedentesGine->findOneBy(array("idPaciente" => $idPaciente));

            $edad = "0";
            $edadMeses = "no";
            if($antecedentesPersonales->getIdPaciente()->getFechaNacimiento() != null)
            {
                $fechaHoy = date_create(date("Y-m-d"));
                $fechaNac = date_create($antecedentesPersonales->getIdPaciente()->getFechaNacimiento());
                $resultado = date_diff($fechaNac, $fechaHoy);
                $arrayEdad = explode(":", $resultado->format("%y:%m"));
                $edad = $arrayEdad[0];
                $edadMeses = ($arrayEdad[0] * 12) + $arrayEdad[1];
            }

            $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
            $noticias = $entityManager->createQuery($queryNot)->setMaxResults(1)->getResult();
            
            $detalleCitaMedica = $this->listarDetalleCitaMedica($idCitaMedica);

            $resumenDiagnostico = $entityManager->getRepository("AgendaBundle:ResumenHistoriaDiagnostico")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"]));

            $resumenMedicamento = $entityManager->getRepository("AgendaBundle:ResumenHistoriaMedicamento")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));
            $resumenImagen = $entityManager->getRepository("AgendaBundle:ResumenHistoriaImagen")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));
            $resumenLaboratorio = $entityManager->getRepository("AgendaBundle:ResumenHistoriaLab")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));
            $resumenCompleme = $entityManager->getRepository("AgendaBundle:ResumenExamenComp")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));

            return $this->render("@HistoriaClinicalistarCitas/CitaMedica/consultaMedicaFin.html.twig",
            array("nombreEspecialidad" => $nombreEspecialidad
                ,"idPaciente" => $idPaciente,"idMedico" => $idMedico,"idCitaMedica" => $idCitaMedica,"idUsuarioAux" => $idUsuarioAux
                ,"edad" => $edad
                ,"edadMeses" => $edadMeses
                ,"antecedentesPersonales" => $antecedentesPersonales
                ,"antecedentesFamiliares" => $antecedentesFamiliares
                ,"antecedentesGine" => $antecedentesGine
                ,"listaExamenes" => $this->listarCatalogoExamenes()
                ,"especialidadesMedico" => $this->especialidadesMedico($idMedico)
                ,"nombreMedico" => $nombreMedico,"apellidoMedico" => $apellidoMedico
                ,"detalleCitaMedica" => $this->listarDetalleCitaMedica($idCitaMedica)
                ,"noticias" => $noticias
                ,"resumenDiagnostico" => $resumenDiagnostico
                ,"resumenImagen" => $resumenImagen
                ,"resumenLaboratorio" => $resumenLaboratorio
                ,"resumenMedicamento" => $resumenMedicamento
                ,"resumenCompleme" => $resumenCompleme
                ,"fotoUsuario" => $medico->getIdUsuario()->getFoto()
                ,"nombreComercial" => $medico->getNombreComercial()
                ,"usuarioId" => $medico->getIdUsuario()->getId()
            ));
        }
    }     

    /**
     * @Route("/evolucion/{nombreEspecialidad}/{idPaciente}/{idMedico}/{idCitaMedica}/{estadoCita}/{nombreMedico}/{apellidoMedico}/{idUsuarioAux}", name="evolucion")
     * @Template()
     */
    public function evolucionAction(Request $request,$nombreEspecialidad=0, $idPaciente=0
    , $idMedico=0,$idCitaMedica=0,$estadoCita="",$nombreMedico="",$apellidoMedico="",$idUsuarioAux=0)
    {
        if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") != 2)
        {
            return $this->redirectToRoute("logout");
        }
        else
        {
            //\Doctrine\Common\Util\Debug::dump($this->idResumenHistoriaClinica($idCitaMedica)[0]["id_resumen_hc"]);
            $em = $this->getDoctrine()->getManager();
            $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
            $queryEvo = "select r.evolucionSubjetiva, r.evolucionObjetiva, r.apreciacion, r.planes from AgendaBundle:ResumenHistoriaClinica r where r.idCitaMedica = ".$idCitaMedica;
            $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            $evolucion = $em->createQuery($queryEvo)->getResult();
            
            $medico = $em->getRepository("AdministradorBundle:Medico")->find($idMedico);

            $repositoryTipoDiagnostico = $this->getDoctrine()->getRepository(TipoDiagnostico::class);
            $tiposDiagnostico = $repositoryTipoDiagnostico->findAll();        

            $repositoryPaciente = $this->getDoctrine()->getRepository(HistoriaClinica::class);
            $historiaClinica = $repositoryPaciente->findOneByIdPaciente($idPaciente);
            
            $repositoryEstadoCitaMedica = $this->getDoctrine()->getRepository(EstadoCitaMedica::class);
            $estadoCitaMedica = $repositoryEstadoCitaMedica->findOneByCodigoEsCitaMedica('CITAENPRO');                  
           
            $repositoryCitaMedica = $this->getDoctrine()->getRepository(CitaMedica::class);
            $citaMedica = $repositoryCitaMedica->find($idCitaMedica);

            $repositoryEstadoCitaMedicaActual = $this->getDoctrine()->getRepository(EstadoCitaMedica::class);
            $estadoCitaMedicaActual = $repositoryEstadoCitaMedicaActual->find($citaMedica->getIdEstadoCitaMedica());

            $repositoryAntecedentesFamiliares = $this->getDoctrine()->getRepository(AntecedentesFamiliares::class);
            $antecedentesFamiliares = $repositoryAntecedentesFamiliares->findOneBy(array("idPaciente" => $idPaciente));

            $repositoryAntecedentesPersonales = $this->getDoctrine()->getRepository(AntecedentesPersonales::class);
            $antecedentesPersonales = $repositoryAntecedentesPersonales->findOneBy(array("idPaciente" => $idPaciente));

            $repositoryAntecedentesGine = $em->getRepository("AgendaBundle:AntecedentesGinecobstetricos");
            $antecedentesGine = $repositoryAntecedentesGine->findOneBy(array("idPaciente" => $idPaciente));

            $edad = "0";
            $edadMeses = "no";
            if($antecedentesPersonales->getIdPaciente()->getFechaNacimiento() != null)
            {
                $fechaHoy = date_create(date("Y-m-d"));
                $fechaNac = date_create($antecedentesPersonales->getIdPaciente()->getFechaNacimiento());
                $resultado = date_diff($fechaNac, $fechaHoy);
                $arrayEdad = explode(":", $resultado->format("%y:%m"));
                $edad = $arrayEdad[0];
                $edadMeses = ($arrayEdad[0] * 12) + $arrayEdad[1];
            }

            $detalleCitaMedica = $this->listarDetalleCitaMedica($idCitaMedica);
            $resumenDiagnostico = $em->getRepository("AgendaBundle:ResumenHistoriaDiagnostico")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"]));

            $resumenMedicamento = $em->getRepository("AgendaBundle:ResumenHistoriaMedicamento")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));
            $resumenImagen = $em->getRepository("AgendaBundle:ResumenHistoriaImagen")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));
            $resumenLaboratorio = $em->getRepository("AgendaBundle:ResumenHistoriaLab")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));
            $resumenCompleme = $em->getRepository("AgendaBundle:ResumenExamenComp")->findBy(array("idResumenHc" => $detalleCitaMedica[0]["id_resumen_hc"], "tipoPedido" => "CITA"));

            return $this->render("@HistoriaClinicalistarCitas/CitaMedica/evolucion.html.twig", array(
                "nombreEspecialidad" => $nombreEspecialidad
                ,"idPaciente" => $idPaciente,"idMedico" => $idMedico,"idCitaMedica" => $idCitaMedica 
                ,"edad" => $edad
                ,"edadMeses" => $edadMeses
                ,"idUsuarioAux" => $idUsuarioAux,"estadoCita" => $estadoCita        
                ,"tiposDiagnostico" => $tiposDiagnostico
                ,"antecedentesPersonales" => $antecedentesPersonales
                ,"antecedentesFamiliares" => $antecedentesFamiliares
                ,"antecedentesGine" => $antecedentesGine
                ,"especialidadesMedico" => $this->especialidadesMedico($idMedico)
                ,"nombreMedico" => $nombreMedico,"apellidoMedico" => $apellidoMedico,"logoMedico" => $medico->getUrlImagen()
                ,"detalleCitaMedica" => $this->listarDetalleCitaMedica($idCitaMedica)
                ,"noticias" => $noticias
                ,"resumenDiagnostico" => $resumenDiagnostico
                ,"resumenImagen" => $resumenImagen
                ,"resumenLaboratorio" => $resumenLaboratorio
                ,"resumenMedicamento" => $resumenMedicamento
                ,"resumenCompleme" => $resumenCompleme
                ,"fotoUsuario" => $medico->getIdUsuario()->getFoto()
                ,"nombreComercial" => $medico->getNombreComercial()
                ,"usuarioId" => $medico->getIdUsuario()->getId()
            ));
        }
    }
    
    public function idResumenHistoriaClinica($idCitaMedica){
        $sqlNativo = "SELECT rhc.id_resumen_hc FROM resumen_historia_clinica rhc, cita_medica cm 
         WHERE rhc.id_cita_medica=cm.id_cita_medica AND cm.id_cita_medica=?;";        
        $stmRHC = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmRHC->bindValue(1,$idCitaMedica);
        $stmRHC->execute();
        return $stmRHC->fetchAll();        
    }     

    public function listarCatalogoExamenes(){
        $sqlNativo = "SELECT nombre_exa_comple FROM pedido_exa_complemt;";        
        $stmyExamenes = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmyExamenes->execute();
        return $stmyExamenes->fetchAll();        
    }    

    public function especialidadesMedico($idMedico){
        $sqlNativo = "SELECT e.id_especialidad, e.nombre_especialidad,e.codigo_especialidad FROM especialidad e, medico_especialidad me
         WHERE e.id_especialidad=me.id_especialidad AND me.id_medico=? AND e.estado_especialidad=TRUE 
         AND e.codigo_especialidad!='MEDGENE';";        
        $stmyEspecialidad = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmyEspecialidad->bindValue(1,$idMedico);
        $stmyEspecialidad->execute();
        return $stmyEspecialidad->fetchAll();  
    }

    public function listarDetalleCitaMedica($idCitaMedica){
        /*$sqlNativo = "SELECT dhc.*, rhc.id_resumen_hc, rhc.motivo_consulta, rhc.enfermedad_actual, rhc.planificacion*/
        $sqlNativo = "SELECT dhc.*, rhc.id_resumen_hc, rhc.motivo_consulta, rhc.enfermedad_actual, rhc.planificacion, rhc.observacion_plan
        , rhc.indicaciones_medicas, rhc.evo_subjetivo, rhc.evo_objetivo, rhc.evo_apreciacion, rhc.evo_planes, rhc.indicaciones_imagen, rhc.indicaciones_examen, rhc.indicaciones_complem, rhc.indicaciones_evo_imagen, rhc.indicaciones_evo_examen, rhc.indicaciones_evo_complem, rhc.indicaciones_receta
         FROM detalle_historia_clinica dhc, resumen_historia_clinica rhc, cita_medica cm
         WHERE dhc.id_resumen_hc=rhc.id_resumen_hc AND rhc.id_cita_medica=cm.id_cita_medica	AND cm.id_cita_medica=?;";        
        $stmyDetalle = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmyDetalle->bindValue(1,$idCitaMedica);
        $stmyDetalle->execute();
        return $stmyDetalle->fetchAll();        
    }

}
