<?php

namespace HistoriaClinica\listarCitasBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

use HistoriaClinica\listarCitasBundle\Entity\EstadoCitaMedica;
use Symfony\Component\HttpFoundation\Response;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Query\ResultSetMapping;
use Doctrine\ORM\Tools\Setup;
use Doctrine\ORM\EntityRepository;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\XmlEncoder;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;


use Symfony\Component\HttpFoundation\File\Exception\FileException;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use HistoriaClinica\listarCitasBundle\Entity\PuntosEspecialidad;
use HistoriaClinica\listarCitasBundle\Form\PuntosEspecialidadImgType;
use Knp\Bundle\SnappyBundle\Snappy\Response\PdfResponse;



class ConsultaMedicaController extends Controller
{

    /**
     * @Route("/actualizaCampoHistoria", name="actualizar_campo_historia")
     * @Method({"POST"})
     */
    public function actualizarAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();

            $idDetalleHistoria = $postData["idDetalleH"];
            $idNombreTabla = $postData["idNombreTabla"];
            $tabla = $postData["nombreTabla"];
            $nombreColumnaTabla = $postData["columna"];
            $valor = $postData["valor"];
        
            $sqlNativo = "UPDATE ".$tabla." SET ".$nombreColumnaTabla."='".$valor."' WHERE "
            .$idNombreTabla."=".$idDetalleHistoria.";";
            
            $stmtActualizar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtActualizar->execute();
            $resultActualizar = $stmtActualizar->fetchAll();

            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success',
                'citas' => $serializer->serialize($resultActualizar, 'json')
            ));
            return $response;
        }
    }

    /**
     * @Route("/buscarCampo", name="buscar_campo")
     * @Method({"POST"})
     */
    public function buscarAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();

            $nombreTabla = $postData["nombreTabla"];
            $nombreColumnaTabla = $postData["nombreColumnaTabla"];
            $valorInput = $postData["valorInput"];
            $limite = $postData["limite"];               
         
            $sqlNativo = "SELECT ".$nombreColumnaTabla." FROM ".$nombreTabla." WHERE "
            .$nombreColumnaTabla." ILIKE '%".$valorInput."%' LIMIT ".$limite.";";
                     
            $stmtBuscar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtBuscar->execute();
            $resultBuscar = $stmtBuscar->fetchAll();

            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success',
                'nombre' => $serializer->serialize($resultBuscar, 'json')
            ));
            return $response;
        }
    }    

    /**
     * @Route("/finalizarConsulta/{idCita}/{nombreMedico}/{apellidoMedico}/{idUsuarioAux}", name="finalizar_consulta")
     * @Template()
     */
    public function finalizarConsultaAction(Request $request,$idCita=0,$nombreMedico="",$apellidoMedico="",$idUsuarioAux=0)
    {
        
        $sqlNativo = "UPDATE cita_medica SET id_estado_cita_medica=(SELECT id_estado_cita_medica FROM estado_cita_medica WHERE codigo_es_cita_medica='CITAFIN') 
         WHERE id_cita_medica=?;";
        
        $stmyUpdate = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmyUpdate->bindValue(1,$idCita);    
        $stmyUpdate->execute();
        $resultUpdate = $stmyUpdate->fetchAll();
        
        return $this->redirectToRoute('lista_citas', array(
            'idMedico' => $idUsuarioAux,
            "nombreMedico" => $nombreMedico,
            "apellidoMedico" => $apellidoMedico,            
        ));


    }  
    
    /**
     * @Route("/cargarObservaciones", name="cargar_observaciones")
     * @Method({"POST"})
     */
    public function cargarObservacionesAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();

            $medico = $postData["medico"];
            $especialidad = $postData["especialidad"];
            $paciente = $postData["paciente"];
            
            //$sqlNativo = "SELECT observaciones FROM puntos_especialidad WHERE id_especialidad=? AND id_medico=? AND id_paciente=?";
            $sqlNativo = "SELECT observaciones FROM puntos_especialidad WHERE id_especialidad=? AND id_paciente=?";
                     
            $stmtCargar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtCargar->bindValue(1,$especialidad);
            //$stmtCargar->bindValue(2,$medico);
            //$stmtCargar->bindValue(3,$paciente);
            $stmtCargar->bindValue(2,$paciente);
            $stmtCargar->execute();
            $resultCargar = $stmtCargar->fetchAll();

            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success',
                'observaciones' => $serializer->serialize($resultCargar, 'json')
            ));
            return $response;
        }
    }   
    
    /**
     * @Route("/actualizarObservaciones", name="actualizar_observaciones")
     * @Method({"POST"})
     */
    public function actualizarObservacionesAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();

            $medico = $postData["medico"];
            $especialidad = $postData["especialidad"];
            $paciente = $postData["paciente"];
            $observaciones = $postData["obs"];
                       
            //$sqlNativo = "UPDATE puntos_especialidad SET observaciones=? WHERE id_especialidad=? AND id_medico=? AND id_paciente=? ;";
            $sqlNativo = "UPDATE puntos_especialidad SET observaciones=? WHERE id_especialidad=? AND id_paciente=? ;";
                     
            $stmtActualizar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtActualizar->bindValue(1,$observaciones);
            $stmtActualizar->bindValue(2,$especialidad);
            //$stmtActualizar->bindValue(3,$medico);
            //$stmtActualizar->bindValue(4,$paciente);
            $stmtActualizar->bindValue(3,$paciente);
            $stmtActualizar->execute();
            $resultActualizar = $stmtActualizar->fetchAll();

            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success'
            ));
            return $response;
        }
    }     

    /**
     * @Route("/actualizarPunto", name="actualizar_punto")
     * @Method({"POST"})
     */
    public function actualizarPuntoAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();

            $datos = $postData["datos"];
            $datosArray = json_decode($datos);
            $puntos = json_encode($datosArray[3]);
                                 
            //$sqlNativo = "UPDATE puntos_especialidad SET puntos=? WHERE id_especialidad=? AND id_medico=? AND id_paciente=?";
            $sqlNativo = "UPDATE puntos_especialidad SET puntos=? WHERE id_especialidad=? AND id_paciente=?";
                     
            $stmtActualizar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtActualizar->bindValue(1,$puntos);
            $stmtActualizar->bindValue(2,$datosArray[1]);
            //$stmtActualizar->bindValue(3,$datosArray[0]);
            //$stmtActualizar->bindValue(4,$datosArray[2]);
            $stmtActualizar->bindValue(3,$datosArray[2]);
            $stmtActualizar->execute();
            $resultActualizar = $stmtActualizar->fetchAll();

            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success'
            ));
            return $response;
        }
    }     

    /**
     * @Route("/cargarPunto", name="cargar_punto")
     * @Method({"POST"})
     */
    public function cargarPuntoAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();

            $medico = $postData["medico"];
            $especialidad = $postData["especialidad"];
            $paciente = $postData["paciente"];
                                             
            //$sqlNativo = "SELECT puntos FROM puntos_especialidad WHERE id_especialidad=? AND id_medico=? AND id_paciente=?;";
            $sqlNativo = "SELECT puntos FROM puntos_especialidad WHERE id_especialidad=? AND id_paciente=?;";
                     
            $stmtCargar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtCargar->bindValue(1,$especialidad);
            //$stmtCargar->bindValue(2,$medico);
            $stmtCargar->bindValue(2,$paciente);
            //$stmtCargar->bindValue(3,$paciente);

            $stmtCargar->execute();
            $resultCargar = $stmtCargar->fetchAll();

            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success',
                'puntos' => $resultCargar
                //'puntos' => $serializer->serialize($resultCargar, 'json')
            ));
            return $response;
        }
    }     

    /**
     * @Route("/cargarPuntosEspecialidad", name="cargar_puntos_especialidad")
     * @Method({"POST"})
     */
    public function cargarPuntosEspecialidadAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();

            $medico = $postData["medico"];
            $especialidad = $postData["especialidad"];
            $paciente = $postData["paciente"];
            
            //$sqlNativo = "SELECT id_punto_especialidad, puntos, observaciones FROM puntos_especialidad WHERE id_especialidad=? AND id_medico=? AND id_paciente=?";
            $sqlNativo = "SELECT id_punto_especialidad, puntos, observaciones FROM puntos_especialidad WHERE id_especialidad=? AND id_paciente=?";
                     
            $stmtCargar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtCargar->bindValue(1,$especialidad);
            //$stmtCargar->bindValue(2,$medico);
            //$stmtCargar->bindValue(3,$paciente);
            $stmtCargar->bindValue(2,$paciente);
            $stmtCargar->execute();
            $resultCargar = $stmtCargar->fetchAll();

            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success',
                'data' => $serializer->serialize($resultCargar, 'json')
            ));
            return $response;
        }
    }   
    
    /**
     * @Route("/subirArchivo", name="subir_archivo")
     * @Template()
     */
    public function subirArchivoAction(Request $request)
    {
        $puntoEspecialidad = new PuntosEspecialidad();
        $formCardio = $this->createForm(PuntosEspecialidadImgType::class, $puntoEspecialidad);      
        $formCardio->handleRequest($request);      
        //\Doctrine\Common\Util\Debug::dump($request);  

        if ($formCardio->isSubmitted() && $formCardio->isValid()) {
            //\Doctrine\Common\Util\Debug::dump($request);
            
            $fileI = $formCardio['urlImagenes']->getData();                        
            $medicoTemp = $formCardio['idMedicoAux']->getData();    
            $puntoEspecialidadTemp = $formCardio['puntoEspecialidadAux']->getData();    
            $pacienteTemp = $formCardio['idPacienteAux']->getData();
            $dataUrlTemp = $formCardio['dataUrlAux']->getData();
            $tipoDataTemp = $formCardio['tipoDataAux']->getData();
            $nombreEspecialidadTemp = $formCardio['nombreEspecialidadAux']->getData();
            $citaMedicaTemp = $formCardio['citaMedicaAux']->getData();
            //$idUsuarioTemp = $formCardio["idUsuarioAuxx"]->getData();

            $nombreMedicoTemp = $formCardio['nombreMedicoAux']->getData();
            $apellidoMedicoTemp = $formCardio['apellidoMedicoAux']->getData();   
            echo $nombreMedicoTemp;         

            $tamanioTipoData = strlen($dataUrlTemp);
            //echo $tamanioTipoData." ---- ".$dataUrlTemp; 

            if($tipoDataTemp == "imagenOK"){
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $fileI = $puntoEspecialidad->getUrlImagenes();
                $fileNameI = $medicoTemp.$pacienteTemp.$this->generateUniqueFileName().'.'.$fileI->guessExtension();
                try {
                    $fileI->move($this->getParameter('img_directory'),$fileNameI);
                } catch (FileException $e) {
                    // ... handle exception if something happens during file upload
                }      
                
                $nuevoUrlArray = Array();
                if($tamanioTipoData > 4){
                    $nuevoUrlArray = json_decode($dataUrlTemp,true);
                    array_push($nuevoUrlArray, $fileNameI);
                    $this->actualizarUrl(json_encode($nuevoUrlArray),"url_imagenes",$puntoEspecialidadTemp);
                    
                }
                else{                                    
                    array_push($nuevoUrlArray, $fileNameI); 
                    $this->actualizarUrl(json_encode($nuevoUrlArray),"url_imagenes",$puntoEspecialidadTemp);
                    
                }
                               

            }
            if($tipoDataTemp == "videoOK"){      
                
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $fileI = $puntoEspecialidad->getUrlImagenes();
                $fileNameI = $medicoTemp.$pacienteTemp.$this->generateUniqueFileName().'.'.$fileI->guessExtension();
                try {
                    $fileI->move($this->getParameter('video_directory'),$fileNameI);
                } catch (FileException $e) {
                    // ... handle exception if something happens during file upload
                }      
                
                $nuevoUrlArray = Array();
                if($tamanioTipoData > 4){
                    $nuevoUrlArray = json_decode($dataUrlTemp);
                    array_push($nuevoUrlArray, $fileNameI);
                    
                    $this->actualizarUrl(json_encode($nuevoUrlArray),"url_videos",$puntoEspecialidadTemp);
                }
                else{                    
                    array_push($nuevoUrlArray, $fileNameI);                       
                    $this->actualizarUrl(json_encode($nuevoUrlArray),"url_videos",$puntoEspecialidadTemp);
                }                

            }

            return $this->redirectToRoute('nueva_consulta', array(
                'nombreEspecialidad' => $nombreEspecialidadTemp,
                "idPaciente" => $pacienteTemp,
                "idMedico" => $medicoTemp,
                "idCitaMedica" => $citaMedicaTemp
                ,"estadoCita" => "En Proceso"
                ,"nombreMedico" => $nombreMedicoTemp
                ,"apellidoMedico" => $apellidoMedicoTemp
                //,"idUsuarioAux" =>  $idUsuarioTemp
            ));

        }  
    }      

    /**
     * @Route("/imgVideo", name="img_video")
     * @Method({"POST"})
     */
    public function imgVideoAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();

            $columna = $postData["columna"];
            $idPuntoEspecialidad = $postData["idPuntoEspecialidad"];
                                             
            $sqlNativo = "SELECT ".$columna." FROM puntos_especialidad WHERE id_punto_especialidad=?;";
                     
            $stmtCargar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtCargar->bindValue(1,$idPuntoEspecialidad);
            $stmtCargar->execute();
            $resultCargar = $stmtCargar->fetchAll();

            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success',
                'data' => $resultCargar
                //'puntos' => $serializer->serialize($resultCargar, 'json')
            ));
            return $response;
        }
    }    

    /**
     * @Route("/crearPuntoEspecialidad", name="crear_punto_especialidad")
     * @Method({"POST"})
     */
    public function crearPuntoEspecialidadAction(Request $request)
    {
        if($request->isXmlHttpRequest())
        {            
            $encoders = array(new JsonEncoder());
            $normalizers = array(new ObjectNormalizer());
            $serializer = new Serializer($normalizers, $encoders);

            $postData = $request->request->all();

            $medico = $postData["medico"];
            $especialidad = $postData["especialidad"];
            $paciente = $postData["paciente"];
                                             
            $sqlNativo = "INSERT INTO puntos_especialidad (id_paciente, id_medico, id_especialidad, puntos, observaciones) 
             VALUES(?,?,?,'','');";
                     
            $stmtUpdate = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
            $stmtUpdate->bindValue(1,$paciente);
            $stmtUpdate->bindValue(2,$medico);
            $stmtUpdate->bindValue(3,$especialidad);

            $stmtUpdate->execute();
            $resultUpdate = $stmtUpdate->fetchAll();

            $response = new JsonResponse();
            $response->setStatusCode(200);
            $response->setData(array(
                'response' => 'success',
                //'puntos' => $serializer->serialize($resultCargar, 'json')
            ));
            return $response;
        }
    }     
   

    /**
     * @Route("/pdfExamenes/{idResumenHc}/{tipo}/{tipoPedido}", name="pdf_examenes")
     * @Template()
     */
    public function pdfExamenesAction($idResumenHc = 0, $tipo = "", $tipoPedido = "")
    {
        $em = $this->getDoctrine()->getManager();
        $resumenHc = $em->getRepository("AgendaBundle:ResumenHistoriaClinica")->find($idResumenHc);
        $edad = "";
        if($resumenHc->getIdCitaMedica()->getIdPaciente()->getFechaNacimiento() != null)
        {
            $fechaHoy = date_create(date("Y-m-d"));
            $fechaNac = date_create($resumenHc->getIdCitaMedica()->getIdPaciente()->getFechaNacimiento());
            $resultado = date_diff($fechaNac, $fechaHoy);
            $edad = $resultado->format('%y')." años";
        }

        if($tipo == "IMG"){
            $consultaImagen = $em->getRepository("AgendaBundle:ResumenHistoriaImagen")->findBy(array("idResumenHc" => $idResumenHc, "tipoPedido" => $tipoPedido));

            $html = $this->renderView('@HistoriaClinicalistarCitas/CitaMedica/pdfExamenes.html.twig', array(
                "resumenHc" => $resumenHc,
                "consultaImagen" => $consultaImagen,
                "tipo" => "Imagen",
                "edad" => $edad,
                "tipoPedido" => $tipoPedido
            ));
            return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html),$resumenHc->getIdCitaMedica()->getIdPaciente()->getIdUsuario()->getCedula().'-Pedido-Imagen.pdf'); 
        }
        elseif($tipo == "LAB")
        {
            $consultaLab = $em->getRepository("AgendaBundle:ResumenHistoriaLab")->findBy(array("idResumenHc" => $idResumenHc, "tipoPedido" => $tipoPedido));

            $html = $this->renderView('@HistoriaClinicalistarCitas/CitaMedica/pdfExamenes.html.twig', array(
                "resumenHc" => $resumenHc,
                "consultaLab" => $consultaLab,
                "tipo" => "Laboratorio",
                "edad" => $edad,
                "tipoPedido" => $tipoPedido
            ));
            return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html),$resumenHc->getIdCitaMedica()->getIdPaciente()->getIdUsuario()->getCedula().'-Pedido-Laboratorio.pdf'); 
        }
        elseif($tipo == "COMP")
        {
            $consultaCompl = $em->getRepository("AgendaBundle:ResumenExamenComp")->findBy(array("idResumenHc" => $idResumenHc, "tipoPedido" => $tipoPedido));

            $html = $this->renderView('@HistoriaClinicalistarCitas/CitaMedica/pdfExamenes.html.twig', array(
                "resumenHc" => $resumenHc,
                "consultaCompl" => $consultaCompl,
                "tipo" => "Complementario",
                "edad" => $edad,
                "tipoPedido" => $tipoPedido
            ));
            return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html),$resumenHc->getIdCitaMedica()->getIdPaciente()->getIdUsuario()->getCedula().'-Pedido-Examen-Complementario.pdf'); 
        }

    } 

    /**
     * @Route("/pdfMedicamento/{idResumenHc}/{tipoPedido}/{e}/{p}", name="pdf_medicamento")
     * @Template()
     */
    public function pdfMedicamentoAction($idResumenHc = 0, $tipoPedido = "", $e = 0, $p = 0)
    {
        $em = $this->getDoctrine()->getManager();
        $medicamentoConsulta = $em->getRepository("AgendaBundle:ResumenHistoriaMedicamento")->findBy(array("idResumenHc" => $idResumenHc, "tipoPedido" => $tipoPedido));
        $resumenHc = $em->getRepository("AgendaBundle:ResumenHistoriaClinica")->find($idResumenHc);
        if($resumenHc->getNumeroReceta() == 0){
            $resumenHc->setNumeroReceta(1);
            $medico = $em->getRepository("AdministradorBundle:Medico")->find($resumenHc->getIdMedico());
            $numeroRecetaOld = $medico->getNumeroReceta();
            $numeroRecetaNew = $numeroRecetaOld + 1;
            $medico->setNumeroReceta($numeroRecetaNew);
            $em->flush();
        }

        $html = $this->renderView('@HistoriaClinicalistarCitas/CitaMedica/pdfMedicamentos.html.twig', array(
            "medicamentoConsulta" => $medicamentoConsulta,
            "e" => $e,
            "p" => $p
        ));
        return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html, array("orientation" => "Landscape")), $medicamentoConsulta[0]->getIdResumenHc()->getIdCitaMedica()->getIdPaciente()->getIdUsuario()->getCedula().'-Medicamento.pdf');
    }   
    
    /**
     * @Route("/pdfFinHistoria/{idResumenHc}", name="pdf_fin_historia")
     * @Template()
     */
    public function pdfFinHistoriaAction($idResumenHc=0)
    {
        $em = $this->getDoctrine()->getManager();
        $resumenHc = $em->getRepository("AgendaBundle:ResumenHistoriaClinica")->find($idResumenHc);
        $detalleHc = $em->getRepository("AgendaBundle:DetalleHistoriaClinica")->findOneBy(array("idResumenHc" => $idResumenHc));
        $resumenDiagnostico = $em->getRepository("AgendaBundle:ResumenHistoriaDiagnostico")->findBy(array("idResumenHc" => $idResumenHc));
        $resumenImagen = $em->getRepository("AgendaBundle:ResumenHistoriaImagen")->findBy(array("idResumenHc" => $idResumenHc));
        $resumenLaboratorio = $em->getRepository("AgendaBundle:ResumenHistoriaLab")->findBy(array("idResumenHc" => $idResumenHc));
        $resumenMedicamento = $em->getRepository("AgendaBundle:ResumenHistoriaMedicamento")->findBy(array("idResumenHc" => $idResumenHc));

        $html = $this->renderView('@HistoriaClinicalistarCitas/CitaMedica/pdfFinHistoriaClinica.html.twig', array(
            "resumenHc" => $resumenHc,
            "detalleHc" => $detalleHc,
            "resumenDiagnostico" => $resumenDiagnostico,
            "resumenImagen" => $resumenImagen,
            "resumenLaboratorio" => $resumenLaboratorio,
            "resumenMedicamento" => $resumenMedicamento
        ));
        return new PdfResponse($this->get('knp_snappy.pdf')->getOutputFromHtml($html),$resumenHc->getIdCitaMedica()->getIdPaciente()->getIdUsuario()->getCedula().'-Consulta.pdf');
    }     
   

    /**
     * @Route("/subirLogo", name="subir_logo")
     * @Template()
     */
    public function subirLogoAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $puntoEspecialidad = new PuntosEspecialidad();
        $formCardio = $this->createForm(PuntosEspecialidadImgType::class, $puntoEspecialidad);      
        $formCardio->handleRequest($request);      
        //\Doctrine\Common\Util\Debug::dump($request);  

        if ($formCardio->isSubmitted() && $formCardio->isValid()) {
            
            
            $fileI = $formCardio['urlImagenes']->getData();                        
            $idMedicoTemp = $formCardio['idMedicoAux']->getData();    

            $citaMedicaAux = $formCardio['citaMedicaAux']->getData();
            $nombreEspecialidadAux = $formCardio['nombreEspecialidadAux']->getData();
            $nombreMedicoAux = $formCardio['nombreMedicoAux']->getData();
            $apellidoMedicoAux = $formCardio['apellidoMedicoAux']->getData();
            $idUsuarioAux = $formCardio['dataUrlAux']->getData(); 
            $estadoCitaAux = $formCardio['tipoDataAux']->getData();
            $idPacienteAux = $formCardio['idPacienteAux']->getData();
            
            /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
            $fileI = $puntoEspecialidad->getUrlImagenes();
            $fileNameI = $idMedicoTemp.$this->generateUniqueFileName().'.'.$fileI->guessExtension();

            $imgbinary = fread(fopen($fileI, "r"), filesize($fileI));
            $imgTemp = 'data:image/'. $fileI->guessExtension() . ';base64,' . base64_encode($imgbinary);
            //\Doctrine\Common\Util\Debug::dump($imgTemp);            
            //$this->actualizarUrlLogo("/6973e3e05f3cea01fbdedd4/logos/".$fileNameI, $idMedicoTemp, $imgTemp);

            $medico = $em->getRepository("AdministradorBundle:Medico")->find($idMedicoTemp);
            $medico->setUrlImagen("6973e3e05f3cea01fbdedd4/logos/".$fileNameI);
            $medico->setImagen($imgTemp);
            $em->flush();

            try {
                $fileI->move($this->getParameter('logo_directory'),$fileNameI);
            } catch (FileException $e) {                
                return $this->redirectToRoute("homeUsuario");
            }

            if($idPacienteAux == "")
            {
                return $this->redirectToRoute('lista_citas', array(
                    "idMedico" => $idMedicoTemp
                    ,"nombreMedico" => $nombreMedicoAux
                    ,"apellidoMedico" => $apellidoMedicoAux         
                ));
            }
            else
            {
                return $this->redirectToRoute('historial_citas', array(
                    "idCitaMedica" => $citaMedicaAux
                    ,"idPaciente" => $idPacienteAux
                    ,"idMedico" => $idMedicoTemp
                    ,"nombreEspecialidad" => $nombreEspecialidadAux
                    ,"estadoCita" => $estadoCitaAux
                    ,"nombreMedico" => $nombreMedicoAux
                    ,"apellidoMedico" => $apellidoMedicoAux 
                    ,"idUsuarioAux" => $idUsuarioAux
                    ,"urlMedicoIcono" => $this->urlMedico($idMedicoTemp)          
                ));
            }
        }  
    }  

    public function urlMedico($idMedico){
        $sqlNativo = "SELECT url_logo_medico FROM medico WHERE id_medico=?;";        
        $stmyEspecialidad = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmyEspecialidad->bindValue(1,$idMedico);
        $stmyEspecialidad->execute();
        return $stmyEspecialidad->fetchAll();  
    }     
    
    private function cabeceraImpresion($idPaciente){
        $sqlNativo = "SELECT u.nombre_usuario || ' ' || u.apellido_usuario AS nombres, u.cedula_usuario,u.correo_usuario,u.telefono_usuario
        ,p.genero_paciente,p.fecha_nacimiento_paciente FROM usuario u, paciente p WHERE p.id_usuario=u.id_usuario AND p.id_paciente=?;";        
        $stmySeleccionar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmySeleccionar->bindValue(1,$idPaciente);
        $stmySeleccionar->execute();
        $resultSeleccionar = $stmySeleccionar->fetchAll();
        return $resultSeleccionar;        
    }

    private function cabeceraImgLogo($idMedico){
        $sqlNativo = "SELECT img_base FROM medico WHERE id_medico=?;";        
        $stmySeleccionar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmySeleccionar->bindValue(1,$idMedico);
        $stmySeleccionar->execute();
        $resultSeleccionar = $stmySeleccionar->fetchAll();
        return $resultSeleccionar;        
    }    

    private function generateUniqueFileName()
    {
        return md5(uniqid());
    }   

    public function actualizarUrl($data,$columnaImgVideo,$idPuntoEspecialidad){
        $sqlNativo = "UPDATE puntos_especialidad SET ".$columnaImgVideo."=? WHERE id_punto_especialidad=?";        
        $stmyActualizar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmyActualizar->bindValue(1,$data);
        $stmyActualizar->bindValue(2,$idPuntoEspecialidad);
        $stmyActualizar->execute();
        return "OK";  
    }       

    public function actualizarUrlLogo($nuevaUrl,$idMedico,$imgBase){
        $sqlNativo = "UPDATE medico SET url_logo_medico=?, img_base=? WHERE id_medico=?";        
        $stmyActualizar = $this->getDoctrine()->getEntityManager()->getConnection()->prepare($sqlNativo);
        $stmyActualizar->bindValue(1,$nuevaUrl);
        $stmyActualizar->bindValue(2,$imgBase);
        $stmyActualizar->bindValue(3,$idMedico);
        $stmyActualizar->execute();
        return "OK";  
    }      

}
